/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.newsletter;

import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.scheduler.BaseJob;
import org.exoplatform.services.scheduler.JobContext;
import org.exoplatform.services.wcm.newsletter.NewsletterManagerService;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class NewsletterEmailJob
extends BaseJob {
    private static Log log = ExoLogger.getLogger(NewsletterEmailJob.class);
    private ExoContainer container;

    public void execute(JobExecutionContext context) throws JobExecutionException {
        String containerName = context.getJobDetail().getGroup().split(":")[0];
        this.container = RootContainer.getInstance().getPortalContainer(containerName);
        super.execute(context);
    }

    public void execute(JobContext context) {
        NewsletterManagerService newsletterManagerService = (NewsletterManagerService)this.container.getComponentInstanceOfType(NewsletterManagerService.class);
        if (newsletterManagerService == null) {
            return;
        }
        try {
            newsletterManagerService.sendNewsletter();
        }
        catch (Exception e) {
            log.error((Object)"Error when execute send email by scheduler", (Throwable)e);
        }
    }
}

