/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.processor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.social.common.ResourceBundleUtil;
import org.exoplatform.social.core.activity.model.Activity;
import org.exoplatform.social.core.processor.ActivityResourceBundlePlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class I18NActivityProcessor {
    private static final Log LOG = ExoLogger.getLogger(I18NActivityProcessor.class);
    private Map<String, ActivityResourceBundlePlugin> resourceBundlePluginMap;
    private ResourceBundleService resourceBundleService;

    public void addActivityResourceBundlePlugin(ActivityResourceBundlePlugin activityResourceBundlePlugin) {
        activityResourceBundlePlugin.setActivityType(activityResourceBundlePlugin.getName());
        if (!activityResourceBundlePlugin.isValid()) {
            LOG.warn((Object)"Failed to register the plugin: not valid");
            return;
        }
        if (this.resourceBundlePluginMap == null) {
            this.resourceBundlePluginMap = new HashMap<String, ActivityResourceBundlePlugin>();
        }
        this.resourceBundlePluginMap.put(activityResourceBundlePlugin.getActivityType(), activityResourceBundlePlugin);
    }

    public void removeActivityResourceBundlePlugin(ActivityResourceBundlePlugin activityResourceBundlePlugin) {
        if (!activityResourceBundlePlugin.isValid()) {
            LOG.warn((Object)"Failed to remove the plugin: not valid");
        }
        if (this.resourceBundlePluginMap == null) {
            LOG.info((Object)"resourceBundlePluginMap is null.");
            return;
        }
        this.resourceBundlePluginMap.remove(activityResourceBundlePlugin.getActivityType());
    }

    public Activity process(Activity i18nActivity, Locale selectedLocale) {
        if (i18nActivity.getTitleId() != null && this.activityTypeRegistered(i18nActivity)) {
            ResourceBundle resourceBundle = this.getResourceBundle(i18nActivity, selectedLocale);
            if (resourceBundle == null) {
                LOG.warn((Object)("no resource bundle key found registered for: " + this.getResourceBundleKeyFile(i18nActivity)));
                return i18nActivity;
            }
            if (this.getMessageBundleKey(i18nActivity) == null) {
                LOG.warn((Object)("Failed to find registered message bundle key for titleId: " + i18nActivity.getTitleId()));
                return i18nActivity;
            }
            String newTitle = this.appRes(resourceBundle, this.getMessageBundleKey(i18nActivity), i18nActivity.getTemplateParams());
            if (newTitle != null) {
                i18nActivity.setTitle(newTitle);
            }
        }
        return i18nActivity;
    }

    public void setResourceBundleService(ResourceBundleService resourceBundleService) {
        this.resourceBundleService = resourceBundleService;
    }

    private boolean activityTypeRegistered(Activity i18nActivity) {
        if (this.resourceBundlePluginMap == null) {
            return false;
        }
        return this.resourceBundlePluginMap.containsKey(i18nActivity.getType());
    }

    private String getMessageBundleKey(Activity i18nActivity) {
        ActivityResourceBundlePlugin resourceBundlePlugin = this.resourceBundlePluginMap.get(i18nActivity.getType());
        return resourceBundlePlugin.getMessageBundleKey(i18nActivity.getTitleId());
    }

    private String getResourceBundleKeyFile(Activity i18nActivity) {
        return this.resourceBundlePluginMap.get(i18nActivity.getType()).getResourceBundleKeyFile();
    }

    private String appRes(ResourceBundle resourceBundle, String msgKey, Map<String, String> templateParams) {
        String value = this.appRes(resourceBundle, msgKey);
        ArrayList<String> arguments = null;
        if (templateParams != null) {
            arguments = new ArrayList<String>(templateParams.values());
        }
        if (arguments != null && arguments.size() > 0) {
            value = ResourceBundleUtil.replaceArgs((String)value, arguments);
        }
        return value;
    }

    private String appRes(ResourceBundle res, String msgKey) {
        String value = null;
        try {
            value = res.getString(msgKey);
        }
        catch (MissingResourceException ex) {
            LOG.warn((Object)("Failed find message bundle value for key : " + msgKey));
        }
        return value;
    }

    private ResourceBundle getResourceBundle(Activity i18nActivity, Locale selectedLocale) {
        if (this.resourceBundleService == null) {
            this.resourceBundleService = (ResourceBundleService)PortalContainer.getInstance().getComponentInstanceOfType(ResourceBundleService.class);
        }
        if (this.resourceBundleService == null) {
            LOG.error((Object)"Failed to get resourceBundleService for I18N activity type.");
            return null;
        }
        if (this.resourceBundlePluginMap == null || this.resourceBundlePluginMap.size() == 0) {
            LOG.warn((Object)"No registered activity resource bundle");
            return null;
        }
        ActivityResourceBundlePlugin resourceBundlePlugin = this.resourceBundlePluginMap.get(i18nActivity.getType());
        return this.resourceBundleService.getResourceBundle(resourceBundlePlugin.getResourceBundleKeyFile(), selectedLocale);
    }
}

