/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.relationship;

import org.exoplatform.social.common.lifecycle.AbstractLifeCycle;
import org.exoplatform.social.core.manager.RelationshipManager;
import org.exoplatform.social.core.relationship.RelationshipEvent;
import org.exoplatform.social.core.relationship.RelationshipListener;
import org.exoplatform.social.core.relationship.model.Relationship;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationshipLifeCycle
extends AbstractLifeCycle<RelationshipListener, RelationshipEvent> {
    protected void dispatchEvent(RelationshipListener listener, RelationshipEvent event) {
        switch (event.getType()) {
            case CONFIRM: {
                listener.confirmed(event);
                break;
            }
            case REMOVE: {
                listener.removed(event);
                break;
            }
            case IGNORE: {
                listener.ignored(event);
                break;
            }
            case PENDING: {
                listener.requested(event);
                break;
            }
            case DENIED: {
                listener.denied(event);
                break;
            }
        }
    }

    public void relationshipConfirmed(RelationshipManager relationshipManager, Relationship relationship) {
        this.broadcast(new RelationshipEvent(RelationshipEvent.Type.CONFIRM, relationshipManager, relationship));
    }

    public void relationshipRemoved(RelationshipManager relationshipManager, Relationship relationship) {
        this.broadcast(new RelationshipEvent(RelationshipEvent.Type.REMOVE, relationshipManager, relationship));
    }

    public void relationshipIgnored(RelationshipManager relationshipManager, Relationship relationship) {
        this.broadcast(new RelationshipEvent(RelationshipEvent.Type.IGNORE, relationshipManager, relationship));
    }

    public void relationshipRequested(RelationshipManager relationshipManager, Relationship relationship) {
        this.broadcast(new RelationshipEvent(RelationshipEvent.Type.PENDING, relationshipManager, relationship));
    }

    public void relationshipDenied(RelationshipManager relationshipManager, Relationship relationship) {
        this.broadcast(new RelationshipEvent(RelationshipEvent.Type.DENIED, relationshipManager, relationship));
    }
}

