/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.storage;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.access.SystemIdentity;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.util.IdGenerator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.common.jcr.JCRSessionManager;
import org.exoplatform.social.common.jcr.LockManager;
import org.exoplatform.social.common.jcr.SocialDataLocation;
import org.exoplatform.social.core.model.AvatarAttachment;
import org.exoplatform.social.core.space.model.Space;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpaceStorage {
    private static final Log LOG = ExoLogger.getLogger(SpaceStorage.class);
    private static final String SPACE_NODETYPE = "exo:space".intern();
    private static final String SPACE_NAME = "exo:name".intern();
    private static final String SPACE_GROUPID = "exo:groupId".intern();
    private static final String SPACE_APP = "exo:app".intern();
    private static final String SPACE_PARENT = "exo:parent".intern();
    private static final String SPACE_DESCRIPTION = "exo:description".intern();
    private static final String SPACE_TAG = "exo:tag".intern();
    private static final String SPACE_PENDING_USER = "exo:pendingUsers".intern();
    private static final String SPACE_INVITED_USER = "exo:invitedUsers".intern();
    private static final String SPACE_TYPE = "exo:type".intern();
    private static final String SPACE_URL = "exo:url".intern();
    private static final String SPACE_VISIBILITY = "exo:visibility".intern();
    private static final String SPACE_REGISTRATION = "exo:registration".intern();
    private static final String SPACE_PRIORITY = "exo:priority".intern();
    private static final String SPACE_PROPERTIES_NAME_PATTERN;
    private SocialDataLocation dataLocation;
    private JCRSessionManager sessionManager;
    private String workspace;
    private final LockManager lockManager;
    private final ExoCache<String, Space> spaceCache;

    public SpaceStorage(SocialDataLocation dataLocation, LockManager lockManager, CacheService cacheService) {
        this.spaceCache = cacheService.getCacheInstance(this.getClass().getName() + "spaceCache");
        this.lockManager = lockManager;
        this.dataLocation = dataLocation;
        this.sessionManager = dataLocation.getSessionManager();
        this.workspace = dataLocation.getWorkspace();
    }

    private Node getSpaceHome(Session session) throws Exception {
        String path = this.dataLocation.getSocialSpaceHome();
        return session.getRootNode().getNode(path);
    }

    public String getWorkspace() throws Exception {
        return this.workspace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Space> getAllSpaces() {
        ArrayList<Space> spaces = new ArrayList<Space>();
        try {
            Session session = this.sessionManager.openSession();
            Node spaceHomeNode = this.getSpaceHome(session);
            NodeIterator iter = spaceHomeNode.getNodes();
            while (iter.hasNext()) {
                Node spaceNode = iter.nextNode();
                Space space = this.getSpace(spaceNode, session);
                spaces.add(space);
            }
            ArrayList<Space> arrayList = spaces;
            return arrayList;
        }
        catch (Exception e) {
            e.printStackTrace();
            List<Space> list = null;
            return list;
        }
        finally {
            this.sessionManager.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Space getSpaceById(String id) {
        Space cachedSpace = (Space)this.spaceCache.get((Serializable)((Object)id));
        if (cachedSpace != null) {
            return cachedSpace;
        }
        try {
            Session session = this.sessionManager.openSession();
            Node spaceHomeNode = this.getSpaceHome(session);
            StringBuilder queryString = new StringBuilder("/").append(spaceHomeNode.getPath()).append("/element(*,").append(SPACE_NODETYPE).append(")[(@").append("jcr:uuid").append("='").append(id).append("')]");
            QueryManager queryManager = session.getWorkspace().getQueryManager();
            Query query = queryManager.createQuery(queryString.toString(), "xpath");
            QueryResult queryResult = query.execute();
            NodeIterator nodeIterator = queryResult.getNodes();
            Node identityNode = null;
            if (nodeIterator.hasNext()) {
                identityNode = (Node)nodeIterator.next();
            } else {
                LOG.debug((Object)"No node found for space");
            }
            Space space = this.getSpace(identityNode, session);
            return space;
        }
        catch (Exception exception) {
        }
        finally {
            this.sessionManager.closeSession();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Space getSpaceByGroupId(String id) {
        try {
            Session session = this.sessionManager.openSession();
            Node spaceHomeNode = this.getSpaceHome(session);
            StringBuilder queryString = new StringBuilder("/").append(spaceHomeNode.getPath()).append("/element(*,").append(SPACE_NODETYPE).append(")[(@").append(SPACE_GROUPID).append("='").append(id).append("')]");
            QueryManager queryManager = session.getWorkspace().getQueryManager();
            Query query = queryManager.createQuery(queryString.toString(), "xpath");
            QueryResult queryResult = query.execute();
            NodeIterator nodeIterator = queryResult.getNodes();
            Node spaceNode = null;
            if (!nodeIterator.hasNext()) {
                LOG.debug((Object)("No space could be found with the group id " + id));
                Space space = null;
                return space;
            }
            spaceNode = (Node)nodeIterator.next();
            Space space = this.getSpace(spaceNode, session);
            return space;
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            this.sessionManager.closeSession();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Space> getSpacesBySearchCondition(String condition) throws Exception {
        Session session = this.sessionManager.openSession();
        Node spaceHomeNode = this.getSpaceHome(session);
        ArrayList<Space> listSpace = new ArrayList<Space>();
        NodeIterator nodeIterator = null;
        try {
            QueryManager queryManager = session.getWorkspace().getQueryManager();
            StringBuilder queryString = new StringBuilder("/").append(spaceHomeNode.getPath()).append("/element(*,").append(SPACE_NODETYPE).append(')');
            if (condition.length() != 0) {
                queryString.append("[");
                if (condition.indexOf("*") < 0) {
                    if (condition.charAt(0) != '*') {
                        condition = "*" + condition;
                    }
                    if (condition.charAt(condition.length() - 1) != '*') {
                        condition = condition + "*";
                    }
                }
                queryString.append("(jcr:contains(@exo:name, ").append("'").append(condition).append("'))");
                queryString.append(" or (jcr:contains(@exo:description, '").append(condition).append("'))");
                queryString.append("]");
            }
            Query query = queryManager.createQuery(queryString.toString(), "xpath");
            QueryResult queryResult = query.execute();
            nodeIterator = queryResult.getNodes();
        }
        catch (Exception e) {
            LOG.warn((Object)("error while filtering identities: " + e.getMessage()));
            ArrayList<Space> queryString = new ArrayList<Space>();
            return queryString;
        }
        finally {
            this.sessionManager.closeSession();
        }
        while (nodeIterator.hasNext()) {
            Node spaceNode = nodeIterator.nextNode();
            Space space = this.getSpace(spaceNode, session);
            listSpace.add(space);
        }
        return listSpace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Space getSpaceByName(String spaceName) {
        try {
            Session session = this.sessionManager.openSession();
            Node spaceHomeNode = this.getSpaceHome(session);
            NodeIterator iter = spaceHomeNode.getNodes();
            while (iter.hasNext()) {
                Node spaceNode = iter.nextNode();
                Space space = this.getSpace(spaceNode, session);
                if (!space.getName().equals(spaceName)) continue;
                Space space2 = space;
                return space2;
            }
        }
        catch (Exception e) {
            Space space = null;
            return space;
        }
        finally {
            this.sessionManager.closeSession();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Space getSpaceByUrl(String url) {
        try {
            Session session = this.sessionManager.openSession();
            Node spaceHomeNode = this.getSpaceHome(session);
            NodeIterator iter = spaceHomeNode.getNodes();
            while (iter.hasNext()) {
                Node spaceNode = iter.nextNode();
                Space space = this.getSpace(spaceNode, session);
                if (!space.getUrl().equals(url)) continue;
                Space space2 = space;
                return space2;
            }
        }
        catch (Exception e) {
            Space space = null;
            return space;
        }
        finally {
            this.sessionManager.closeSession();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSpace(String id) {
        Session session = this.sessionManager.openSession();
        try {
            Node spaceNode = session.getNodeByUUID(id);
            if (spaceNode != null) {
                spaceNode.remove();
                session.save();
            }
            this.spaceCache.remove((Serializable)((Object)id));
        }
        catch (Exception e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            this.sessionManager.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveSpace(Space space, boolean isNew) {
        try {
            Session session = this.sessionManager.openSession();
            Node spaceHomeNode = this.getSpaceHome(session);
            this.saveSpace(spaceHomeNode, space, isNew, session);
        }
        catch (Exception exception) {
        }
        finally {
            this.sessionManager.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveSpace(Node spaceHomeNode, Space space, boolean isNew, Session session) {
        block21: {
            Lock lock = this.lockManager.getLock("Space", space.getName());
            lock.lock();
            try {
                try {
                    Node spaceNode;
                    if (isNew) {
                        spaceNode = spaceHomeNode.addNode(IdGenerator.generate(), SPACE_NODETYPE);
                        spaceNode.addMixin("mix:referenceable");
                    } else {
                        spaceNode = session.getNodeByUUID(space.getId());
                    }
                    if (space.getId() == null) {
                        space.setId(spaceNode.getUUID());
                    }
                    spaceNode.setProperty(SPACE_NAME, space.getName());
                    spaceNode.setProperty(SPACE_GROUPID, space.getGroupId());
                    spaceNode.setProperty(SPACE_APP, space.getApp());
                    spaceNode.setProperty(SPACE_PARENT, space.getParent());
                    spaceNode.setProperty(SPACE_DESCRIPTION, space.getDescription());
                    spaceNode.setProperty(SPACE_TAG, space.getTag());
                    spaceNode.setProperty(SPACE_PENDING_USER, space.getPendingUsers());
                    spaceNode.setProperty(SPACE_INVITED_USER, space.getInvitedUsers());
                    spaceNode.setProperty(SPACE_TYPE, space.getType());
                    spaceNode.setProperty(SPACE_URL, space.getUrl());
                    spaceNode.setProperty(SPACE_VISIBILITY, space.getVisibility());
                    spaceNode.setProperty(SPACE_REGISTRATION, space.getRegistration());
                    spaceNode.setProperty(SPACE_PRIORITY, space.getPriority());
                    AvatarAttachment attachment = space.getAvatarAttachment();
                    if (attachment != null) {
                        ExtendedNode extNode = (ExtendedNode)spaceNode;
                        if (extNode.canAddMixin("exo:privilegeable")) {
                            extNode.addMixin("exo:privilegeable");
                        }
                        String[] arrayPers = new String[]{"read", "add_node", "set_property", "remove"};
                        extNode.setPermission(SystemIdentity.ANY, arrayPers);
                        List permsList = extNode.getACL().getPermissionEntries();
                        for (AccessControlEntry accessControlEntry : permsList) {
                            extNode.setPermission(accessControlEntry.getIdentity(), arrayPers);
                        }
                        if (attachment.getFileName() != null) {
                            Node nodeFile = null;
                            try {
                                nodeFile = spaceNode.getNode("image");
                            }
                            catch (PathNotFoundException ex) {
                                nodeFile = spaceNode.addNode("image", "nt:file");
                            }
                            Node nodeContent = null;
                            try {
                                nodeContent = nodeFile.getNode("jcr:content");
                            }
                            catch (PathNotFoundException ex) {
                                nodeContent = nodeFile.addNode("jcr:content", "nt:resource");
                            }
                            long lastModified = attachment.getLastModified();
                            long lastSaveTime = 0L;
                            if (nodeContent.hasProperty("jcr:lastModified")) {
                                lastSaveTime = nodeContent.getProperty("jcr:lastModified").getLong();
                            }
                            if (lastModified != 0L && lastModified != lastSaveTime) {
                                nodeContent.setProperty("jcr:mimeType", attachment.getMimeType());
                                nodeContent.setProperty("jcr:data", attachment.getInputStream(session));
                                nodeContent.setProperty("jcr:lastModified", attachment.getLastModified());
                            }
                        }
                    } else if (spaceNode.hasNode("image")) {
                        spaceNode.getNode("image").remove();
                        session.save();
                    }
                    if (isNew) {
                        spaceHomeNode.save();
                        break block21;
                    }
                    spaceNode.save();
                    this.spaceCache.remove((Serializable)((Object)spaceNode.getUUID()));
                }
                catch (Exception e) {
                    LOG.error((Object)"failed to save space", (Throwable)e);
                }
            }
            finally {
                lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Space getSpace(Node spaceNode, Session session) throws Exception {
        String id = spaceNode.getUUID();
        Space space = (Space)this.spaceCache.get((Serializable)((Object)id));
        if (space != null) {
            return space;
        }
        Lock lock = this.lockManager.getLock("SpaceById", id);
        lock.lock();
        try {
            Node image;
            space = (Space)this.spaceCache.get((Serializable)((Object)id));
            if (space != null) {
                Space space2 = space;
                return space2;
            }
            space = new Space();
            space.setId(spaceNode.getUUID());
            PropertyIterator it = spaceNode.getProperties(SPACE_PROPERTIES_NAME_PATTERN);
            while (it.hasNext()) {
                Property p = it.nextProperty();
                String propertyName = p.getName();
                if (SPACE_NAME.equals(propertyName)) {
                    space.setName(p.getString());
                    continue;
                }
                if (SPACE_GROUPID.equals(propertyName)) {
                    space.setGroupId(p.getString());
                    continue;
                }
                if (SPACE_APP.equals(propertyName)) {
                    space.setApp(p.getString());
                    continue;
                }
                if (SPACE_PARENT.equals(propertyName)) {
                    space.setParent(p.getString());
                    continue;
                }
                if (SPACE_DESCRIPTION.equals(propertyName)) {
                    space.setDescription(p.getString());
                    continue;
                }
                if (SPACE_TAG.equals(propertyName)) {
                    space.setTag(p.getString());
                    continue;
                }
                if (SPACE_PENDING_USER.equals(propertyName)) {
                    space.setPendingUsers(this.convertValuesToStrings(p.getValues()));
                    continue;
                }
                if (SPACE_INVITED_USER.equals(propertyName)) {
                    space.setInvitedUsers(this.convertValuesToStrings(p.getValues()));
                    continue;
                }
                if (SPACE_TYPE.equals(propertyName)) {
                    space.setType(p.getString());
                    continue;
                }
                if (SPACE_URL.equals(propertyName)) {
                    space.setUrl(p.getString());
                    continue;
                }
                if (SPACE_VISIBILITY.equals(propertyName)) {
                    space.setVisibility(p.getString());
                    continue;
                }
                if (SPACE_REGISTRATION.equals(propertyName)) {
                    space.setRegistration(p.getString());
                    continue;
                }
                if (!SPACE_PRIORITY.equals(propertyName)) continue;
                space.setPriority(p.getString());
            }
            if (spaceNode.hasNode("image") && (image = spaceNode.getNode("image")).isNodeType("nt:file")) {
                AvatarAttachment file = new AvatarAttachment();
                file.setId(image.getPath());
                file.setMimeType(image.getNode("jcr:content").getProperty("jcr:mimeType").getString());
                try {
                    file.setInputStream(image.getNode("jcr:content").getProperty("jcr:data").getValue().getStream());
                }
                catch (Exception ex) {
                    LOG.warn((Object)ex.getMessage(), (Throwable)ex);
                }
                file.setFileName(image.getName());
                file.setLastModified(image.getNode("jcr:content").getProperty("jcr:lastModified").getLong());
                file.setWorkspace(session.getWorkspace().getName());
                space.setAvatarAttachment(file);
            }
            this.spaceCache.put((Serializable)((Object)id), (Object)space);
        }
        finally {
            lock.unlock();
        }
        return space;
    }

    private String[] convertValuesToStrings(Value[] values) throws Exception {
        if (values.length == 1) {
            return new String[]{values[0].getString()};
        }
        String[] strArrays = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            strArrays[i] = values[i].getString();
        }
        return strArrays;
    }

    static {
        StringBuilder buffer = new StringBuilder(256);
        int separator = 124;
        buffer.append(SPACE_NAME).append('|');
        buffer.append(SPACE_GROUPID).append('|');
        buffer.append(SPACE_APP).append('|');
        buffer.append(SPACE_PARENT).append('|');
        buffer.append(SPACE_DESCRIPTION).append('|');
        buffer.append(SPACE_TAG).append('|');
        buffer.append(SPACE_PENDING_USER).append('|');
        buffer.append(SPACE_INVITED_USER).append('|');
        buffer.append(SPACE_TYPE).append('|');
        buffer.append(SPACE_URL).append('|');
        buffer.append(SPACE_VISIBILITY).append('|');
        buffer.append(SPACE_REGISTRATION).append('|');
        buffer.append(SPACE_PRIORITY);
        SPACE_PROPERTIES_NAME_PATTERN = buffer.toString();
    }
}

