/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.impl;

import java.util.Map;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringEscapeUtils;
import org.exoplatform.ecm.utils.text.Text;
import org.exoplatform.services.jcr.core.ExtendedNode;

public class Utils {
    public static Node makePath(Node rootNode, String path, String nodetype) throws PathNotFoundException, RepositoryException {
        return Utils.makePath(rootNode, path, nodetype, null);
    }

    public static Node makePath(Node rootNode, String path, String nodetype, Map permissions) throws PathNotFoundException, RepositoryException {
        String[] tokens = path.split("/");
        Node node = rootNode;
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (token.length() <= 0) continue;
            if (node.hasNode(token)) {
                node = node.getNode(token);
                continue;
            }
            if ((node = node.addNode(token, nodetype)).canAddMixin("exo:privilegeable")) {
                node.addMixin("exo:privilegeable");
            }
            if (permissions == null) continue;
            ((ExtendedNode)node).setPermissions(permissions);
        }
        return node;
    }

    public static String getTitle(Node node) throws Exception {
        Node content;
        String title = null;
        if (node.hasProperty("exo:title")) {
            title = node.getProperty("exo:title").getValue().getString();
        } else if (node.hasNode("jcr:content") && (content = node.getNode("jcr:content")).hasProperty("dc:title")) {
            try {
                title = content.getProperty("dc:title").getValues()[0].getString();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (title == null) {
            if (node.isNodeType("nt:frozenNode")) {
                String uuid = node.getProperty("jcr:frozenUuid").getString();
                Node originalNode = node.getSession().getNodeByUUID(uuid);
                title = originalNode.getName();
            } else {
                title = node.getName();
            }
        }
        return StringEscapeUtils.escapeHtml((String)Text.unescapeIllegalJcrChars(title));
    }
}

