/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.controller.impl.event;

import org.gatein.pc.api.Portlet;
import org.gatein.pc.api.PortletInvoker;
import org.gatein.pc.api.PortletInvokerException;
import org.gatein.pc.api.info.PortletInfo;
import org.gatein.pc.api.invocation.response.PortletInvocationResponse;
import org.gatein.pc.controller.event.EventControllerContext;
import org.gatein.pc.controller.event.EventPhaseContext;
import org.gatein.pc.controller.event.PortletWindowEvent;

public class EventControllerContextImpl
implements EventControllerContext {
    private PortletInvoker invoker;

    public EventControllerContextImpl(PortletInvoker invoker) {
        this.invoker = invoker;
    }

    public void eventProduced(EventPhaseContext context, PortletWindowEvent producedEvent, PortletWindowEvent sourceEvent) {
        try {
            for (Portlet portlet : this.invoker.getPortlets()) {
                PortletInfo portletInfo = portlet.getInfo();
                if (!portletInfo.getEventing().getConsumedEvents().containsKey(producedEvent.getName())) continue;
                PortletWindowEvent distributedEvent = new PortletWindowEvent(producedEvent.getName(), producedEvent.getPayload(), portlet.getContext().getId());
                context.queueEvent(distributedEvent);
            }
        }
        catch (PortletInvokerException e) {
            System.out.println("e = " + (Object)((Object)e));
            context.interrupt();
        }
    }

    public void eventConsumed(EventPhaseContext context, PortletWindowEvent consumedEvent, PortletInvocationResponse consumerResponse) {
    }

    public void eventFailed(EventPhaseContext context, PortletWindowEvent failedEvent, Throwable throwable) {
    }

    public void eventDiscarded(EventPhaseContext context, PortletWindowEvent discardedEvent, int cause) {
    }
}

