/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.service;

import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.model.AvatarAttachment;

public class LinkProvider {
    private IdentityManager identityManager;
    private static Log LOG = ExoLogger.getLogger(LinkProvider.class);

    public LinkProvider(InitParams params, IdentityManager identityManager) {
        this.identityManager = identityManager;
        this.init(params);
    }

    private void init(InitParams params) {
    }

    public String getProfileUri(String username) {
        return this.getProfileUri(username, null);
    }

    public String getProfileUri(String username, String portalOwner) {
        String url = null;
        try {
            Identity identity = this.identityManager.getIdentity("organization:" + username, true);
            if (identity == null) {
                throw new RuntimeException("could not find a user identity for " + username);
            }
            String container = PortalContainer.getCurrentPortalContainerName();
            if (portalOwner == null || portalOwner.equals("")) {
                PortalRequestContext context = Util.getPortalRequestContext();
                portalOwner = context.getPortalOwner();
            }
            url = "/" + container + "/private/" + portalOwner + "/profile/" + identity.getRemoteId();
        }
        catch (Exception e) {
            LOG.warn((Object)("failed to substitute username for " + username + ": " + e.getMessage()));
        }
        return url;
    }

    public String getProfileLink(String username) {
        return this.getProfileLink(username, null);
    }

    public String getProfileLink(String username, String portalOwner) {
        String link = null;
        try {
            Identity identity = this.identityManager.getIdentity("organization:" + username, true);
            if (identity == null) {
                return "<strike>" + username + "</strike>";
            }
            String container = PortalContainer.getCurrentPortalContainerName();
            if (portalOwner == null || portalOwner.equals("")) {
                PortalRequestContext context = Util.getPortalRequestContext();
                portalOwner = context.getPortalOwner();
            }
            String url = "/" + container + "/private/" + portalOwner + "/profile/" + identity.getRemoteId();
            link = "<a href=\"" + url + "\" target=\"_parent\">" + identity.getProfile().getFullName() + "</a>";
        }
        catch (Exception e) {
            LOG.warn((Object)("failed to substitute username for " + username + ": " + e.getMessage()));
        }
        return link;
    }

    public String getAbsoluteProfileUrl(String userName, String portalName, String portalOwner, String host) {
        String url = null;
        try {
            Identity identity = this.identityManager.getIdentity("organization:" + userName, true);
            if (identity == null) {
                throw new RuntimeException("could not find a user identity for " + userName);
            }
            url = host + "/" + portalName + "/private/" + portalOwner + "/profile/" + identity.getRemoteId();
        }
        catch (Exception e) {
            LOG.warn((Object)("failed to substitute username for " + userName + ": " + e.getMessage()));
        }
        return url;
    }

    public static String buildAvatarUrl(AvatarAttachment avatarAttachment) {
        String avatarUrl = null;
        try {
            String repository = ((RepositoryService)PortalContainer.getComponent(RepositoryService.class)).getCurrentRepository().getConfiguration().getName();
            avatarUrl = "/" + PortalContainer.getCurrentRestContextName() + "/jcr/" + repository + "/" + avatarAttachment.getWorkspace() + avatarAttachment.getDataPath() + "/?rnd=" + avatarAttachment.getLastModified();
        }
        catch (Exception e) {
            LOG.warn((Object)("Failed to build avatar url from avatar attachment for: " + e.getMessage()));
        }
        return avatarUrl;
    }
}

