/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.StandardRecord;
import org.apache.poi.util.LittleEndianOutput;

public final class PaletteRecord
extends StandardRecord {
    public static final short sid = 146;
    public static final byte STANDARD_PALETTE_SIZE = 56;
    public static final short FIRST_COLOR_INDEX = 8;
    private List<PColor> field_2_colors;

    public PaletteRecord() {
        PColor[] defaultPalette = PaletteRecord.createDefaultPalette();
        this.field_2_colors = new ArrayList<PColor>(defaultPalette.length);
        for (int i = 0; i < defaultPalette.length; ++i) {
            this.field_2_colors.add(defaultPalette[i]);
        }
    }

    public PaletteRecord(RecordInputStream in) {
        int field_1_numcolors = in.readShort();
        this.field_2_colors = new ArrayList<PColor>(field_1_numcolors);
        for (int k = 0; k < field_1_numcolors; ++k) {
            this.field_2_colors.add(new PColor(in));
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[PALETTE]\n");
        buffer.append("  numcolors     = ").append(this.field_2_colors.size()).append('\n');
        for (int i = 0; i < this.field_2_colors.size(); ++i) {
            PColor c = this.field_2_colors.get(i);
            buffer.append("* colornum      = ").append(i).append('\n');
            buffer.append(c.toString());
            buffer.append("/*colornum      = ").append(i).append('\n');
        }
        buffer.append("[/PALETTE]\n");
        return buffer.toString();
    }

    public void serialize(LittleEndianOutput out) {
        out.writeShort(this.field_2_colors.size());
        for (int i = 0; i < this.field_2_colors.size(); ++i) {
            this.field_2_colors.get(i).serialize(out);
        }
    }

    protected int getDataSize() {
        return 2 + this.field_2_colors.size() * 4;
    }

    public short getSid() {
        return 146;
    }

    public byte[] getColor(short byteIndex) {
        int i = byteIndex - 8;
        if (i < 0 || i >= this.field_2_colors.size()) {
            return null;
        }
        PColor color = this.field_2_colors.get(i);
        return new byte[]{color.red, color.green, color.blue};
    }

    public void setColor(short byteIndex, byte red, byte green, byte blue) {
        int i = byteIndex - 8;
        if (i < 0 || i >= 56) {
            return;
        }
        while (this.field_2_colors.size() <= i) {
            this.field_2_colors.add(new PColor(0, 0, 0));
        }
        PColor custColor = new PColor(red, green, blue);
        this.field_2_colors.set(i, custColor);
    }

    private static PColor[] createDefaultPalette() {
        return new PColor[]{PaletteRecord.pc(0, 0, 0), PaletteRecord.pc(255, 255, 255), PaletteRecord.pc(255, 0, 0), PaletteRecord.pc(0, 255, 0), PaletteRecord.pc(0, 0, 255), PaletteRecord.pc(255, 255, 0), PaletteRecord.pc(255, 0, 255), PaletteRecord.pc(0, 255, 255), PaletteRecord.pc(128, 0, 0), PaletteRecord.pc(0, 128, 0), PaletteRecord.pc(0, 0, 128), PaletteRecord.pc(128, 128, 0), PaletteRecord.pc(128, 0, 128), PaletteRecord.pc(0, 128, 128), PaletteRecord.pc(192, 192, 192), PaletteRecord.pc(128, 128, 128), PaletteRecord.pc(153, 153, 255), PaletteRecord.pc(153, 51, 102), PaletteRecord.pc(255, 255, 204), PaletteRecord.pc(204, 255, 255), PaletteRecord.pc(102, 0, 102), PaletteRecord.pc(255, 128, 128), PaletteRecord.pc(0, 102, 204), PaletteRecord.pc(204, 204, 255), PaletteRecord.pc(0, 0, 128), PaletteRecord.pc(255, 0, 255), PaletteRecord.pc(255, 255, 0), PaletteRecord.pc(0, 255, 255), PaletteRecord.pc(128, 0, 128), PaletteRecord.pc(128, 0, 0), PaletteRecord.pc(0, 128, 128), PaletteRecord.pc(0, 0, 255), PaletteRecord.pc(0, 204, 255), PaletteRecord.pc(204, 255, 255), PaletteRecord.pc(204, 255, 204), PaletteRecord.pc(255, 255, 153), PaletteRecord.pc(153, 204, 255), PaletteRecord.pc(255, 153, 204), PaletteRecord.pc(204, 153, 255), PaletteRecord.pc(255, 204, 153), PaletteRecord.pc(51, 102, 255), PaletteRecord.pc(51, 204, 204), PaletteRecord.pc(153, 204, 0), PaletteRecord.pc(255, 204, 0), PaletteRecord.pc(255, 153, 0), PaletteRecord.pc(255, 102, 0), PaletteRecord.pc(102, 102, 153), PaletteRecord.pc(150, 150, 150), PaletteRecord.pc(0, 51, 102), PaletteRecord.pc(51, 153, 102), PaletteRecord.pc(0, 51, 0), PaletteRecord.pc(51, 51, 0), PaletteRecord.pc(153, 51, 0), PaletteRecord.pc(153, 51, 102), PaletteRecord.pc(51, 51, 153), PaletteRecord.pc(51, 51, 51)};
    }

    private static PColor pc(int r, int g, int b) {
        return new PColor(r, g, b);
    }

    private static final class PColor {
        public static final short ENCODED_SIZE = 4;
        public byte red;
        public byte green;
        public byte blue;

        public PColor(int red, int green, int blue) {
            this.red = (byte)red;
            this.green = (byte)green;
            this.blue = (byte)blue;
        }

        public PColor(RecordInputStream in) {
            this.red = in.readByte();
            this.green = in.readByte();
            this.blue = in.readByte();
            in.readByte();
        }

        public void serialize(LittleEndianOutput out) {
            out.writeByte(this.red);
            out.writeByte(this.green);
            out.writeByte(this.blue);
            out.writeByte(0);
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("  red           = ").append(this.red & 0xFF).append('\n');
            buffer.append("  green         = ").append(this.green & 0xFF).append('\n');
            buffer.append("  blue          = ").append(this.blue & 0xFF).append('\n');
            return buffer.toString();
        }
    }
}

