/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.fonts;

import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.fonts.FontFactory;
import org.icepdf.core.pobjects.fonts.FontFile;
import org.icepdf.core.util.Defs;
import org.icepdf.core.util.FontUtil;

public class FontManager {
    private static final Logger logger = Logger.getLogger(FontManager.class.toString());
    private static ArrayList<Object[]> fontList;
    private static int PLAIN;
    private static int BOLD;
    private static int ITALIC;
    private static int BOLD_ITALIC;
    private static final String[][] TYPE1_FONT_DIFFS;
    private static final String[] JAPANESE_FONT_NAMES;
    private static final String[] CHINESE_SIMPLIFIED_FONT_NAMES;
    private static final String[] CHINESE_TRADITIONAL_FONT_NAMES;
    private static final String[] KOREAN_FONT_NAMES;
    private static String[] SYSTEM_FONT_PATHS;
    private static FontManager fontManager;

    public static FontManager getInstance() {
        if (fontManager == null) {
            fontManager = new FontManager();
        }
        return fontManager;
    }

    public Properties getFontProperties() {
        if (fontList == null) {
            this.readSystemFonts(null);
        }
        Properties fontProperites = new Properties();
        for (Object[] currentFont : fontList) {
            String name = (String)currentFont[0];
            String family = (String)currentFont[1];
            Integer decorations = (Integer)currentFont[2];
            String path = (String)currentFont[3];
            fontProperites.put(name, family + "|" + decorations + "|" + path);
        }
        return fontProperites;
    }

    public void setFontProperties(Properties fontProperties) throws IllegalArgumentException {
        String errorString = "Error parsing font properties ";
        try {
            fontList = new ArrayList(150);
            Enumeration<?> fonts = fontProperties.propertyNames();
            while (fonts.hasMoreElements()) {
                String name = (String)fonts.nextElement();
                StringTokenizer tokens = new StringTokenizer((String)fontProperties.get(name), "|");
                String family = tokens.nextToken();
                Integer decorations = new Integer(tokens.nextToken());
                String path = tokens.nextToken();
                if (name != null && family != null && path != null) {
                    fontList.add(new Object[]{name, family, decorations, path});
                    continue;
                }
                throw new IllegalArgumentException(errorString);
            }
        }
        catch (Throwable e) {
            logger.log(Level.FINE, "Error setting font properties ", e);
            throw new IllegalArgumentException(errorString);
        }
    }

    public void clearFontList() {
        if (fontList != null) {
            fontList.clear();
            fontList.trimToSize();
        }
    }

    public void readSystemFonts(String[] extraFontPaths) {
        String[] fontDirectories;
        if (fontList == null) {
            fontList = new ArrayList(150);
        }
        if (extraFontPaths == null) {
            fontDirectories = SYSTEM_FONT_PATHS;
        } else {
            int length = SYSTEM_FONT_PATHS.length + extraFontPaths.length;
            fontDirectories = new String[length];
            System.arraycopy(SYSTEM_FONT_PATHS, 0, fontDirectories, 0, SYSTEM_FONT_PATHS.length);
            System.arraycopy(extraFontPaths, 0, fontDirectories, SYSTEM_FONT_PATHS.length, extraFontPaths.length);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Reading system fonts:");
        }
        for (int i = fontDirectories.length - 1; i >= 0; --i) {
            File directory;
            String path = fontDirectories[i];
            if (path == null || !(directory = new File(path)).canRead()) continue;
            String[] fontPaths = directory.list();
            for (int j = fontPaths.length - 1; j >= 0; --j) {
                FontFile font;
                String fontName = fontPaths[j];
                StringBuilder fontPath = new StringBuilder(25);
                fontPath.append(directory.getAbsolutePath()).append(File.separatorChar).append(fontName);
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Trying to load font file: " + fontPath);
                }
                if ((font = this.buildFont(fontPath.toString())) == null) continue;
                fontName = font.getName().toLowerCase();
                fontList.add(new Object[]{font.getName().toLowerCase(), FontUtil.normalizeString(font.getFamily()), FontManager.guessFontStyle(fontName), fontPath.toString()});
                if (!logger.isLoggable(Level.FINER)) continue;
                logger.finer("Adding system font: " + font.getName() + " " + fontPath.toString());
            }
        }
    }

    public static String guessFamily(String name) {
        String fam = name;
        int inx = fam.indexOf(44);
        if (inx > 0) {
            fam = fam.substring(0, inx);
        }
        if ((inx = fam.lastIndexOf(45)) > 0) {
            fam = fam.substring(0, inx);
        }
        return fam;
    }

    public String[] getAvailableNames() {
        if (fontList != null) {
            String[] availableNames = new String[fontList.size()];
            Iterator<Object[]> nameIterator = fontList.iterator();
            int i = 0;
            while (nameIterator.hasNext()) {
                Object[] fontData = nameIterator.next();
                availableNames[i] = fontData[0].toString();
                ++i;
            }
            return availableNames;
        }
        return null;
    }

    public String[] getAvailableFamilies() {
        if (fontList != null) {
            String[] availableNames = new String[fontList.size()];
            Iterator<Object[]> nameIterator = fontList.iterator();
            int i = 0;
            while (nameIterator.hasNext()) {
                Object[] fontData = nameIterator.next();
                availableNames[i] = fontData[1].toString();
                ++i;
            }
            return availableNames;
        }
        return null;
    }

    public String[] getAvailableStyle() {
        if (fontList != null) {
            String[] availableStyles = new String[fontList.size()];
            Iterator<Object[]> nameIterator = fontList.iterator();
            String style = "";
            int i = 0;
            while (nameIterator.hasNext()) {
                Object[] fontData = nameIterator.next();
                int decorations = (Integer)fontData[2];
                if ((decorations & BOLD_ITALIC) == BOLD_ITALIC) {
                    style = style + " BoldItalic";
                } else if ((decorations & BOLD) == BOLD) {
                    style = style + " Bold";
                } else if ((decorations & ITALIC) == ITALIC) {
                    style = style + " Italic";
                } else if ((decorations & PLAIN) == PLAIN) {
                    style = style + " Plain";
                }
                availableStyles[i] = style;
                style = "";
                ++i;
            }
            return availableStyles;
        }
        return null;
    }

    public FontFile getJapaneseInstance(String name, int fontFlags) {
        return this.getAsianInstance(name, JAPANESE_FONT_NAMES, fontFlags);
    }

    public FontFile getKoreanInstance(String name, int fontFlags) {
        return this.getAsianInstance(name, KOREAN_FONT_NAMES, fontFlags);
    }

    public FontFile getChineseTraditionalInstance(String name, int fontFlags) {
        return this.getAsianInstance(name, CHINESE_TRADITIONAL_FONT_NAMES, fontFlags);
    }

    public FontFile getChineseSimplifiedInstance(String name, int fontFlags) {
        return this.getAsianInstance(name, CHINESE_SIMPLIFIED_FONT_NAMES, fontFlags);
    }

    private FontFile getAsianInstance(String name, String[] list, int flags) {
        if (fontList == null) {
            this.readSystemFonts(null);
        }
        FontFile font = null;
        if (list != null) {
            int i;
            for (i = list.length - 1; i >= 0; --i) {
                font = this.findFont(name, flags);
                if (font == null) continue;
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Font Substitution: Found Asian font: " + font.getName() + " for named font " + name);
                }
                return font;
            }
            for (i = list.length - 1; i >= 0; --i) {
                font = this.findFont(list[i], flags);
                if (font == null) continue;
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Font Substitution: Found Asian font: " + font.getName() + " for named font " + name);
                }
                return font;
            }
        }
        return font;
    }

    public FontFile getInstance(String name, int flags) {
        FontFile font;
        if (fontList == null) {
            this.readSystemFonts(null);
        }
        if ((font = this.getType1Fonts(name, flags)) != null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Font Substitution: Found type1 font: " + font.getName() + " for named font " + name);
            }
            return font;
        }
        font = this.findFont(name, flags);
        if (font != null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Font Substitution: Found system font: " + font.getName() + " for named font " + name);
            }
            return font;
        }
        font = this.getCoreJavaFont(name, flags);
        if (font != null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Font Substitution: Found java font: " + font.getName() + " for named font " + name);
            }
            return font;
        }
        if (fontList.size() > 0) {
            Object[] fontData = fontList.get(0);
            font = this.buildFont((String)fontData[3]);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Font Substitution: Found failed " + name + " " + font.getName());
            }
        }
        if (font == null && logger.isLoggable(Level.FINE)) {
            logger.fine("No Fonts can be found on your system. ");
        }
        return font;
    }

    private FontFile findFont(String fontName, int flags) {
        FontFile font = null;
        int decorations = FontManager.guessFontStyle(fontName);
        String name = FontUtil.normalizeString(fontName);
        if (fontList != null) {
            for (int i = fontList.size() - 1; i >= 0; --i) {
                Object[] fontData = fontList.get(i);
                String baseName = (String)fontData[0];
                String familyName = (String)fontData[1];
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest(baseName + " : " + familyName + "  : " + name);
                }
                if (name.indexOf(familyName) < 0 && fontName.toLowerCase().indexOf(baseName) < 0) continue;
                int style = (Integer)fontData[2];
                boolean found = false;
                if (!(baseName.equals("opensymbol") || baseName.equals("starsymbol") || baseName.equals("arial-black") || baseName.equals("arial-blackitalic") || baseName.equals("timesnewromanps"))) {
                    if ((decorations & BOLD_ITALIC) == BOLD_ITALIC && (style & BOLD_ITALIC) == BOLD_ITALIC) {
                        found = true;
                    } else if ((decorations & BOLD) == BOLD && (style & BOLD) == BOLD) {
                        found = true;
                    } else if ((decorations & ITALIC) == ITALIC && (style & ITALIC) == ITALIC) {
                        found = true;
                    } else if ((decorations & PLAIN) == PLAIN && (style & PLAIN) == PLAIN) {
                        found = true;
                    } else if (baseName.indexOf("wingdings") >= 0 || baseName.indexOf("zapfdingbats") >= 0 || baseName.indexOf("symbol") >= 0) {
                        found = true;
                    }
                }
                if (!found) continue;
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("----> Found font: " + baseName + " family: " + this.getFontSytle(style, 0) + " for: " + fontName);
                }
                if ((font = this.buildFont((String)fontData[3])) != null) break;
            }
        }
        return font;
    }

    private FontFile buildFont(String fontPath) {
        FontFile font = null;
        try {
            File file = new File(fontPath);
            if (!file.canRead()) {
                return null;
            }
            FontFactory fontFactory = FontFactory.getInstance();
            if (fontPath.endsWith(".ttf") || fontPath.endsWith(".TTF") || fontPath.endsWith(".dfont") || fontPath.endsWith(".DFONT") || fontPath.endsWith(".ttc") || fontPath.endsWith(".TTC")) {
                font = fontFactory.createFontFile(file, 0);
            } else if (fontPath.endsWith(".pfa") || fontPath.endsWith(".PFA") || fontPath.endsWith(".pfb") || fontPath.endsWith(".PFB")) {
                font = fontFactory.createFontFile(file, 1);
            } else if (fontPath.endsWith(".otf") || fontPath.endsWith(".OTF") || fontPath.endsWith(".otc") || fontPath.endsWith(".OTC")) {
                font = fontFactory.createFontFile(file, 5);
            }
        }
        catch (Throwable e) {
            logger.log(Level.FINE, "Error reading font program.", e);
        }
        return font;
    }

    private FontFile getCoreJavaFont(String fontName, int flags) {
        int decorations = FontManager.guessFontStyle(fontName);
        FontFile font = (fontName = FontUtil.normalizeString(fontName)).indexOf("timesnewroman") >= 0 || fontName.indexOf("bodoni") >= 0 || fontName.indexOf("garamond") >= 0 || fontName.indexOf("minionweb") >= 0 || fontName.indexOf("stoneserif") >= 0 || fontName.indexOf("georgia") >= 0 || fontName.indexOf("bitstreamcyberbit") >= 0 ? this.findFont("lucidabright-" + this.getFontSytle(decorations, flags), 0) : (fontName.indexOf("helvetica") != -1 || fontName.indexOf("arial") != -1 || fontName.indexOf("trebuchet") != -1 || fontName.indexOf("avantgardegothic") != -1 || fontName.indexOf("verdana") != -1 || fontName.indexOf("univers") != -1 || fontName.indexOf("futura") != -1 || fontName.indexOf("stonesans") != -1 || fontName.indexOf("gillsans") != -1 || fontName.indexOf("akzidenz") != -1 || fontName.indexOf("frutiger") != -1 || fontName.indexOf("grotesk") != -1 ? this.findFont("lucidasans-" + this.getFontSytle(decorations, flags), 0) : (fontName.indexOf("courier") != -1 || fontName.indexOf("couriernew") != -1 || fontName.indexOf("prestige") != -1 || fontName.indexOf("eversonmono") != -1 ? this.findFont("lucidasanstypewriter-" + this.getFontSytle(decorations, flags), 0) : this.findFont("lucidabright-" + this.getFontSytle(decorations, flags), 0)));
        return font;
    }

    private FontFile getType1Fonts(String fontName, int flags) {
        FontFile font = null;
        boolean found = false;
        boolean isType1Available = true;
        int max = TYPE1_FONT_DIFFS.length;
        for (int i = 0; i < max; ++i) {
            int max2 = TYPE1_FONT_DIFFS[i].length;
            for (int j = 0; j < max2; ++j) {
                if (TYPE1_FONT_DIFFS[i][0].indexOf(fontName) < 0) continue;
                if (isType1Available) {
                    font = this.findFont(TYPE1_FONT_DIFFS[i][1], flags);
                    if (font != null) {
                        found = true;
                        break;
                    }
                    isType1Available = false;
                }
                if ((font = this.findFont(TYPE1_FONT_DIFFS[i][j], flags)) == null) continue;
                found = true;
                break;
            }
            if (found) break;
        }
        return font;
    }

    private static int guessFontStyle(String name) {
        name = name.toLowerCase();
        int decorations = 0;
        decorations = name.indexOf("boldital") > 0 || name.indexOf("demiital") > 0 ? (decorations |= BOLD_ITALIC) : (name.indexOf("bold") > 0 || name.indexOf("black") > 0 || name.indexOf("demi") > 0 ? (decorations |= BOLD) : (name.indexOf("ital") > 0 || name.indexOf("obli") > 0 ? (decorations |= ITALIC) : (decorations |= PLAIN)));
        return decorations;
    }

    private String getFontSytle(int sytle, int flags) {
        String style = "";
        if ((sytle & BOLD_ITALIC) == BOLD_ITALIC) {
            style = style + " BoldItalic";
        } else if ((sytle & BOLD) == BOLD) {
            style = style + " Bold";
        } else if ((sytle & ITALIC) == ITALIC) {
            style = style + " Italic";
        } else if ((sytle & PLAIN) == PLAIN) {
            style = style + " Plain";
        }
        return style;
    }

    static {
        PLAIN = -268435455;
        BOLD = -268435440;
        ITALIC = -268435200;
        BOLD_ITALIC = -268431360;
        TYPE1_FONT_DIFFS = new String[][]{{"Bookman-Demi", "URWBookmanL-DemiBold", "Arial"}, {"Bookman-DemiItalic", "URWBookmanL-DemiBoldItal", "Arial"}, {"Bookman-Light", "URWBookmanL-Ligh", "Arial"}, {"Bookman-LightItalic", "URWBookmanL-LighItal", "Arial"}, {"Courier", "NimbusMonL-Regu", "Nimbus Mono L", "CourierNew", "CourierNewPSMT"}, {"Courier-Oblique", "NimbusMonL-ReguObli", "Nimbus Mono L", "Courier,Italic", "CourierNew-Italic", "CourierNew,Italic", "CourierNewPS-ItalicMT"}, {"Courier-Bold", "NimbusMonL-Bold", "Nimbus Mono L", "Courier,Bold", "CourierNew,Bold", "CourierNew-Bold", "CourierNewPS-BoldMT"}, {"Courier-BoldOblique", "NimbusMonL-BoldObli", "Nimbus Mono L", "Courier,BoldItalic", "CourierNew-BoldItalic", "CourierNew,BoldItalic", "CourierNewPS-BoldItalicMT"}, {"AvantGarde-Book", "URWGothicL-Book", "Arial"}, {"AvantGarde-BookOblique", "URWGothicL-BookObli", "Arial"}, {"AvantGarde-Demi", "URWGothicL-Demi", "Arial"}, {"AvantGarde-DemiOblique", "URWGothicL-DemiObli", "Arial"}, {"Helvetica", "Arial", "ArialMT", "NimbusSanL-Regu", "Nimbus Sans L"}, {"Helvetica-Oblique", "NimbusSanL-ReguItal", "Nimbus Sans L", "Helvetica,Italic", "Helvetica-Italic", "Arial,Italic", "Arial-Italic", "Arial-ItalicMT"}, {"Helvetica-Bold", "Helvetica,Bold", "Arial,Bold", "Arial-Bold", "Arial-BoldMT", "NimbusSanL-Bold", "Nimbus Sans L"}, {"Helvetica-BoldOblique", "NimbusSanL-BoldItal", "Helvetica-BlackOblique", "Nimbus Sans L", "Helvetica,BoldItalic", "Helvetica-BoldItalic", "Arial,BoldItalic", "Arial-BoldItalic", "Arial-BoldItalicMT"}, {"Helvetica-Black", "Helvetica,Bold", "Arial,Bold", "Arial-Bold", "Arial-BoldMT", "NimbusSanL-Bold", "Nimbus Sans L"}, {"Helvetica-BlackOblique", "NimbusSanL-BoldItal", "Helvetica-BlackOblique", "Nimbus Sans L", "Helvetica,BoldItalic", "Helvetica-BoldItalic", "Arial,BoldItalic", "Arial-BoldItalic", "Arial-BoldItalicMT"}, {"Helvetica-Narrow", "NimbusSanL-ReguCond", "Nimbus Sans L"}, {"Helvetica-Narrow-Oblique", "NimbusSanL-ReguCondItal", "Nimbus Sans L"}, {"Helvetica-Narrow-Bold", "NimbusSanL-BoldCond", "Nimbus Sans L"}, {"Helvetica-Narrow-BoldOblique", "NimbusSanL-BoldCondItal", "Nimbus Sans L"}, {"Helvetica-Condensed", "NimbusSanL-ReguCond", "Nimbus Sans L"}, {"Helvetica-Condensed-Oblique", "NimbusSanL-ReguCondItal", "Nimbus Sans L"}, {"Helvetica-Condensed-Bold", "NimbusSanL-BoldCond", "Nimbus Sans L"}, {"Helvetica-Condensed-BoldOblique", "NimbusSanL-BoldCondItal", "Nimbus Sans L"}, {"Palatino-Roman", "URWPalladioL-Roma", "Arial"}, {"Palatino-Italic", "URWPalladioL-Ital", "Arial"}, {"Palatino-Bold", "URWPalladioL-Bold", "Arial"}, {"Palatino-BoldItalic", "URWPalladioL-BoldItal", "Arial"}, {"NewCenturySchlbk-Roman", "CenturySchL-Roma", "Arial"}, {"NewCenturySchlbk-Italic", "CenturySchL-Ital", "Arial"}, {"NewCenturySchlbk-Bold", "CenturySchL-Bold", "Arial"}, {"NewCenturySchlbk-BoldItalic", "CenturySchL-BoldItal", "Arial"}, {"Times-Roman", "NimbusRomNo9L-Regu", "Nimbus Roman No9 L", "TimesNewRoman", "TimesNewRomanPSMT", "TimesNewRomanPS"}, {"Times-Italic", "NimbusRomNo9L-ReguItal", "Nimbus Roman No9 L", "TimesNewRoman,Italic", "TimesNewRoman-Italic", "TimesNewRomanPS-Italic", "TimesNewRomanPS-ItalicMT"}, {"Times-Bold", "NimbusRomNo9L-Medi", "Nimbus Roman No9 L", "TimesNewRoman,Bold", "TimesNewRoman-Bold", "TimesNewRomanPS-Bold", "TimesNewRomanPS-BoldMT"}, {"Times-BoldItalic", "NimbusRomNo9L-MediItal", "Nimbus Roman No9 L", "TimesNewRoman,BoldItalic", "TimesNewRoman-BoldItalic", "TimesNewRomanPS-BoldItalic", "TimesNewRomanPS-BoldItalicMT"}, {"Symbol", "StandardSymL", "Standard Symbols L"}, {"ZapfChancery-MediumItalic", "URWChanceryL-MediItal", "Arial"}, {"ZapfDingbats", "Dingbats", "Zapf-Dingbats"}};
        JAPANESE_FONT_NAMES = new String[]{"Arial Unicode MS", "PMingLiU", "MingLiU", "MS PMincho", "MS Mincho", "Kochi Mincho", "Hiragino Mincho Pro", "KozMinPro Regular Acro", "HeiseiMin W3 Acro", "Adobe Ming Std Acro"};
        CHINESE_SIMPLIFIED_FONT_NAMES = new String[]{"Arial Unicode MS", "PMingLiU", "MingLiU", "SimSun", "NSimSun", "Kochi Mincho", "STFangsong", "STSong Light Acro", "Adobe Song Std Acro"};
        CHINESE_TRADITIONAL_FONT_NAMES = new String[]{"Arial Unicode MS", "PMingLiU", "MingLiU", "SimSun", "NSimSun", "Kochi Mincho", "BiauKai", "MSungStd Light Acro", "Adobe Song Std Acro"};
        KOREAN_FONT_NAMES = new String[]{"Arial Unicode MS", "Gulim", "Batang", "BatangChe", "HYSMyeongJoStd Medium Acro", "Adobe Myungjo Std Acro"};
        SYSTEM_FONT_PATHS = new String[]{"c:\\windows\\fonts\\", "d:\\windows\\fonts\\", "e:\\windows\\fonts\\", "f:\\windows\\fonts\\", "c:\\winnt\\Fonts\\", "d:\\winnt\\Fonts\\", "c:\\cygwin\\usr\\share\\ghostscript\\fonts\\", "d:\\cygwin\\usr\\share\\ghostscript\\fonts\\", "/Network/Library/Fonts/", "/System/Library/Fonts/", "/System Folder/Fonts", "/usr/local/share/ghostscript/", "/Applications/GarageBand.app/Contents/Resources/", "/Applications/NeoOffice.app/Contents/share/fonts/truetype/", "/Library/Dictionaries/Shogakukan Daijisen.dictionary/Contents/", "/Library/Dictionaries/Shogakukan Progressive English-Japanese Japanese-English Dictionary.dictionary/Contents/", "/Library/Dictionaries/Shogakukan Ruigo Reikai Jiten.dictionary/Contents/", "/Library/Fonts/", "/Volumes/Untitled/WINDOWS/Fonts/", "/usr/share/enscript/", "/usr/share/groff/1.19.2/font/devps/generate/", "/usr/X11/lib/X11/fonts/Type1/", "/usr/X11/lib/X11/fonts/TrueType/", "/usr/X11/lib/X11/fonts/", "/etc/fonts/", "/system/etc/fonts/", "/usr/lib/X11/fonts", "/usr/share/a2ps/afm/", "/usr/share/enscript/afm/", "/usr/share/fonts/local/", "/usr/share/fonts/truetype/", "/usr/share/fonts/truetype/freefont/", "/usr/share/fonts/truetype/msttcorefonts/", "/usr/share/fonts/Type1/", "/usr/share/fonts/type1/gsfonts/", "/usr/share/fonts/X11/Type1/", "/usr/share/ghostscript/fonts/", "/usr/share/groff/1.18.1/font/devps/", "/usr/share/groff/1.18.1/font/devps/generate/", "/usr/share/libwmf/fonts/", "/usr/share/ogonkify/afm/", "/usr/X11R6/lib/X11/fonts/", "/var/lib/defoma/gs.d/dirs/fonts/", "/usr/openwin/lib/locale/ar/X11/fonts/TrueType/", "/usr/openwin/lib/locale/euro_fonts/X11/fonts/TrueType/", "/usr/openwin/lib/locale/hi_IN.UTF-8/X11/fonts/TrueType/", "/usr/openwin/lib/locale/iso_8859_13/X11/fonts/TrueType/", "/usr/openwin/lib/locale/iso_8859_15/X11/fonts/TrueType/", "/usr/openwin/lib/locale/iso_8859_2/X11/fonts/TrueType/", "/usr/openwin/lib/locale/iso_8859_2/X11/fonts/Type1/afm/", "/usr/openwin/lib/locale/iso_8859_4/X11/fonts/Type1/afm/", "/usr/openwin/lib/locale/iso_8859_5/X11/fonts/TrueType/", "/usr/openwin/lib/locale/iso_8859_5/X11/fonts/Type1/afm/", "/usr/openwin/lib/locale/iso_8859_7/X11/fonts/TrueType/", "/usr/openwin/lib/locale/iso_8859_7/X11/fonts/Type1/afm/", "/usr/openwin/lib/locale/iso_8859_8/X11/fonts/TrueType/", "/usr/openwin/lib/locale/iso_8859_8/X11/fonts/Type1/", "/usr/openwin/lib/locale/iso_8859_8/X11/fonts/Type1/afm/", "/usr/openwin/lib/locale/iso_8859_9/X11/fonts/TrueType/", "/usr/openwin/lib/locale/iso_8859_9/X11/fonts/Type1/afm/", "/usr/openwin/lib/locale/ja//X11/fonts/TrueType/", "/usr/openwin/lib/locale/K0I8-R/X11/fonts/TrueType/", "/usr/openwin/lib/locale/ru.ansi-1251/X11/fonts/TrueType/", "/usr/openwin/lib/locale/th_TH/X11/fonts/TrueType/", "/usr/openwin/lib/locale/zh.GBK/X11/fonts/TrueType/", "/usr/openwin/lib/locale/zh/X11/fonts/TrueType/", "/usr/openwin/lib/locale/zh_CN.GB18030/X11/fonts/TrueType/", "/usr/openwin/lib/locale/zh_TW.BIG5/X11/fonts/TrueType/", "/usr/openwin/lib/locale/zh_TW/X11/fonts/TrueType/", "/usr/openwin/lib/X11/fonts/", "/usr/openwin/lib/X11/fonts/F3/afm/", "/usr/openwin/lib/X11/fonts/misc/", "/usr/openwin/lib/X11/fonts/TrueType/", "/usr/openwin/lib/X11/fonts/Type1/", "/usr/openwin/lib/X11/fonts/Type1/afm/", "/usr/openwin/lib/X11/fonts/Type1/outline/", "/usr/openwin/lib/X11/fonts/Type1/sun/", "/usr/openwin/lib/X11/fonts/Type1/sun/afm/", "/usr/sfw/share/a2ps/afm/", "/usr/sfw/share/ghostscript/fonts/", "/usr/sfw/share/ghostscript/fonts/", Defs.sysProperty("java.home") + "/lib/fonts"};
    }
}

