/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.popup.admin;

import java.util.List;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import org.exoplatform.commons.utils.ObjectPageList;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.popup.admin.UISimpleCategoryManager;
import org.exoplatform.ecm.webui.selector.UISelectable;
import org.exoplatform.ecm.webui.utils.JCRExceptionManager;
import org.exoplatform.services.cms.categories.CategoriesService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPageIterator;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.exception.MessageException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="app:/groovy/webui/component/explorer/popup/admin/UICategoriesAddedList.gtmpl", events={@EventConfig(listeners={DeleteActionListener.class}, confirm="UICategoriesAddedList.msg.confirm-delete")})
public class UISimpleCategoriesAddedList
extends UIContainer
implements UISelectable {
    private UIPageIterator uiPageIterator_ = (UIPageIterator)this.addChild(UIPageIterator.class, null, "SimpleCategoriesAddedList");
    private static final Log LOG = ExoLogger.getLogger((String)"explorer.UISimpleCategoriesAddedList");

    public UIPageIterator getUIPageIterator() {
        return this.uiPageIterator_;
    }

    public List getListCategories() throws Exception {
        return this.uiPageIterator_.getCurrentPageData();
    }

    public void updateGrid(int currentPage) throws Exception {
        ObjectPageList objPageList = new ObjectPageList(this.getCategories(), 10);
        this.uiPageIterator_.setPageList((PageList)objPageList);
        if (currentPage > this.getUIPageIterator().getAvailablePage()) {
            this.getUIPageIterator().setCurrentPage(currentPage - 1);
        } else {
            this.getUIPageIterator().setCurrentPage(currentPage);
        }
    }

    public List<Node> getCategories() throws Exception {
        UIJCRExplorer uiJCRExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        CategoriesService categoriesService = (CategoriesService)this.getApplicationComponent(CategoriesService.class);
        return categoriesService.getCategories(uiJCRExplorer.getCurrentNode(), uiJCRExplorer.getRepositoryName());
    }

    public void doSelect(String selectField, Object value) throws Exception {
        UIJCRExplorer uiJCRExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        CategoriesService categoriesService = (CategoriesService)this.getApplicationComponent(CategoriesService.class);
        try {
            Node currentNode = uiJCRExplorer.getCurrentNode();
            uiJCRExplorer.addLockToken(currentNode);
            categoriesService.addCategory(currentNode, value.toString(), uiJCRExplorer.getRepositoryName());
            uiJCRExplorer.getCurrentNode().save();
            uiJCRExplorer.getSession().save();
            this.updateGrid(1);
            this.setRenderSibling(UISimpleCategoriesAddedList.class);
        }
        catch (Exception e) {
            LOG.error((Object)"Unexpected error", (Throwable)e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DeleteActionListener
    extends EventListener<UISimpleCategoriesAddedList> {
        public void execute(Event<UISimpleCategoriesAddedList> event) throws Exception {
            UISimpleCategoriesAddedList uiAddedList = (UISimpleCategoriesAddedList)((Object)event.getSource());
            UISimpleCategoryManager uiManager = (UISimpleCategoryManager)uiAddedList.getParent();
            UIApplication uiApp = (UIApplication)uiAddedList.getAncestorOfType(UIApplication.class);
            String nodePath = event.getRequestContext().getRequestParameter("objectId");
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uiAddedList.getAncestorOfType(UIJCRExplorer.class);
            CategoriesService categoriesService = (CategoriesService)uiAddedList.getApplicationComponent(CategoriesService.class);
            try {
                categoriesService.removeCategory(uiExplorer.getCurrentNode(), nodePath, uiExplorer.getRepositoryName());
                uiAddedList.updateGrid(uiAddedList.getUIPageIterator().getCurrentPage());
            }
            catch (AccessDeniedException ace) {
                throw new MessageException(new ApplicationMessage("UICategoriesAddedList.msg.access-denied", null, 1));
            }
            catch (Exception e) {
                JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
            }
            uiManager.setRenderedChild("UISimpleCategoriesAddedList");
        }
    }
}

