/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.jdbc;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import org.exoplatform.services.database.DAO;
import org.exoplatform.services.database.DBObject;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.jdbc.JDBCUserListAccess;

public class SimpleJDBCUserListAccess
extends JDBCUserListAccess {
    public SimpleJDBCUserListAccess(DAO dao, String findQuery, String countQuery) {
        super(dao, findQuery, countQuery);
    }

    protected User[] load(Connection connection, int index, int length) throws Exception {
        if (index < 0) {
            throw new IllegalArgumentException("Illegal index: index must be a positive number");
        }
        if (length < 0) {
            throw new IllegalArgumentException("Illegal length: length must be a positive number");
        }
        User[] users = new User[length];
        Statement statement = connection.createStatement(1004, 1007);
        ResultSet resultSet = statement.executeQuery(this.findQuery);
        int p = 0;
        int counter = 0;
        while (counter < length) {
            if (resultSet.isAfterLast()) {
                throw new IllegalArgumentException("Illegal index or length: sum of the index and the length cannot be greater than the list size");
            }
            resultSet.next();
            DBObject bean = this.dao.createInstance();
            this.dao.getDBObjectMapper().mapResultSet(resultSet, bean);
            if (p >= index) {
                users[counter++] = (User)bean;
            }
            ++p;
        }
        resultSet.close();
        statement.close();
        return users;
    }

    protected int getSize(Connection connection) throws Exception {
        Object retObj = this.dao.loadDBField(this.countQuery);
        if (retObj instanceof Integer) {
            return (Integer)retObj;
        }
        if (retObj instanceof BigDecimal) {
            return ((BigDecimal)retObj).intValue();
        }
        return ((Long)retObj).intValue();
    }
}

