/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.naming;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.exoplatform.services.naming.InitialContextInitializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InitialContextBinder {
    public static final String BIND_REFERENCES_ELEMENT = "bind-references";
    public static final String REFERENCE_ELEMENT = "reference";
    public static final String PROPERTY_ELEMENT = "property";
    public static final String REFADDR_ELEMENT = "ref-addr";
    public static final String BIND_NAME_ATTR = "bind-name";
    public static final String CLASS_NAME_ATTR = "class-name";
    public static final String FACTORY_ATTR = "factory-name";
    public static final String FACTORY_LOCATION_ATTR = "factory-location";
    protected final InitialContextInitializer initialContextInitializer;
    protected final String bindingsStorePath;
    protected Map<String, Reference> bindings;

    InitialContextBinder(InitialContextInitializer initialContextInitializer) throws FileNotFoundException, XMLStreamException, NamingException {
        this.initialContextInitializer = initialContextInitializer;
        this.bindings = new HashMap<String, Reference>();
        this.bindingsStorePath = System.getProperty("java.io.tmpdir") + File.separator + "bind-references.xml";
        if (new File(this.bindingsStorePath).exists()) {
            Map<String, Reference> importedRefs = this.readBindings();
            for (Map.Entry<String, Reference> entry : importedRefs.entrySet()) {
                this.bind(entry.getKey(), entry.getValue());
            }
        }
    }

    public void bind(String bindName, String className, String factory, String factoryLocation, Map<String, String> refAddr) throws NamingException, FileNotFoundException, XMLStreamException {
        Reference reference = new Reference(className, factory, factoryLocation);
        for (Map.Entry<String, String> entry : refAddr.entrySet()) {
            reference.add(new StringRefAddr(entry.getKey(), entry.getValue()));
        }
        this.bind(bindName, reference);
        this.saveBindings();
    }

    private void bind(String bindName, Reference reference) throws NamingException {
        try {
            this.initialContextInitializer.getInitialContext().bind(bindName, (Object)reference);
        }
        catch (NameAlreadyBoundException e) {
            this.initialContextInitializer.getInitialContext().rebind(bindName, (Object)reference);
        }
        this.bindings.put(bindName, reference);
    }

    protected void saveBindings() throws FileNotFoundException, XMLStreamException {
        XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
        XMLStreamWriter writer = outputFactory.createXMLStreamWriter(new FileOutputStream(this.bindingsStorePath), "UTF-8");
        writer.writeStartDocument("UTF-8", "1.0");
        writer.writeStartElement(BIND_REFERENCES_ELEMENT);
        for (Map.Entry<String, Reference> entry : this.bindings.entrySet()) {
            String bindName = entry.getKey();
            Reference reference = entry.getValue();
            writer.writeStartElement(REFERENCE_ELEMENT);
            writer.writeAttribute(BIND_NAME_ATTR, bindName);
            if (reference.getClassName() != null) {
                writer.writeAttribute(CLASS_NAME_ATTR, reference.getClassName());
            }
            if (reference.getFactoryClassName() != null) {
                writer.writeAttribute(FACTORY_ATTR, reference.getFactoryClassName());
            }
            if (reference.getFactoryClassLocation() != null) {
                writer.writeAttribute(FACTORY_LOCATION_ATTR, reference.getFactoryClassLocation());
            }
            writer.writeStartElement(REFADDR_ELEMENT);
            for (int i = 0; i < reference.size(); ++i) {
                writer.writeStartElement(PROPERTY_ELEMENT);
                writer.writeAttribute(reference.get(i).getType(), (String)reference.get(i).getContent());
                writer.writeEndElement();
            }
            writer.writeEndElement();
            writer.writeEndElement();
        }
        writer.writeEndElement();
        writer.writeEndDocument();
    }

    protected Map<String, Reference> readBindings() throws FileNotFoundException, XMLStreamException {
        Stack<RefEntity> stack = new Stack<RefEntity>();
        HashMap<String, Reference> importedRefs = new HashMap<String, Reference>();
        XMLInputFactory factory = XMLInputFactory.newInstance();
        XMLEventReader reader = factory.createXMLEventReader(new FileInputStream(this.bindingsStorePath), "UTF-8");
        while (reader.hasNext()) {
            XMLEvent event = reader.nextEvent();
            switch (event.getEventType()) {
                case 1: {
                    StartElement startElement = event.asStartElement();
                    HashMap<String, String> attr = new HashMap<String, String>();
                    Iterator<Attribute> attributes = startElement.getAttributes();
                    while (attributes.hasNext()) {
                        Attribute attribute = attributes.next();
                        attr.put(attribute.getName().getLocalPart(), attribute.getValue());
                    }
                    String localName = startElement.getName().getLocalPart();
                    if (localName.equals(REFERENCE_ELEMENT)) {
                        String bindName = (String)attr.get(BIND_NAME_ATTR);
                        String className = (String)attr.get(CLASS_NAME_ATTR);
                        String factoryName = (String)attr.get(FACTORY_ATTR);
                        String factoryLocation = (String)attr.get(FACTORY_LOCATION_ATTR);
                        Reference reference = new Reference(className, factoryName, factoryLocation);
                        stack.push(new RefEntity(bindName, reference));
                        break;
                    }
                    if (!localName.equals(PROPERTY_ELEMENT)) break;
                    RefEntity refEntity = (RefEntity)stack.pop();
                    Reference reference = refEntity.getValue();
                    for (Map.Entry entry : attr.entrySet()) {
                        reference.add(new StringRefAddr((String)entry.getKey(), (String)entry.getValue()));
                    }
                    refEntity.setValue(reference);
                    stack.push(refEntity);
                    break;
                }
                case 2: {
                    EndElement endElement = event.asEndElement();
                    String localName = endElement.getName().getLocalPart();
                    if (!localName.equals(REFERENCE_ELEMENT)) break;
                    RefEntity refEntity = (RefEntity)stack.pop();
                    importedRefs.put(refEntity.getKey(), refEntity.getValue());
                    break;
                }
            }
        }
        return importedRefs;
    }

    class RefEntity
    implements Map.Entry {
        private final String key;
        private Reference value;

        public RefEntity(String key, Reference value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public Reference getValue() {
            return this.value;
        }

        public Reference setValue(Object value) {
            Reference oldValue = this.value;
            this.value = (Reference)value;
            return oldValue;
        }
    }
}

