/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.graph.def;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jbpm.JbpmException;
import org.jbpm.graph.def.GraphElement;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.SuperState;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.exe.Token;
import org.jbpm.graph.log.TransitionLog;
import org.jbpm.jpdl.el.impl.JbpmExpressionEvaluator;

public class Transition
extends GraphElement {
    private static final long serialVersionUID = 1L;
    protected Node from;
    protected Node to;
    protected String condition;
    transient boolean isConditionEnforced = true;
    public static final String[] supportedEventTypes = new String[]{"transition"};

    public String[] getSupportedEventTypes() {
        return supportedEventTypes;
    }

    public Transition() {
    }

    public Transition(String name) {
        super(name);
    }

    public Node getFrom() {
        return this.from;
    }

    public void setFrom(Node from) {
        this.from = from;
    }

    public void setTo(Node to) {
        this.to = to;
    }

    public Node getTo() {
        return this.to;
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String conditionExpression) {
        this.condition = conditionExpression;
    }

    public void removeConditionEnforcement() {
        this.isConditionEnforced = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void take(ExecutionContext executionContext) {
        executionContext.getToken().setNode(null);
        Token token = executionContext.getToken();
        if (this.condition != null && this.isConditionEnforced) {
            Object result = JbpmExpressionEvaluator.evaluate(this.condition, executionContext);
            if (result == null) {
                throw new JbpmException("transition condition " + this.condition + " evaluated to null");
            }
            if (!(result instanceof Boolean)) {
                throw new JbpmException("transition condition " + this.condition + " evaluated to non-boolean: " + result.getClass().getName());
            }
            if (!((Boolean)result).booleanValue()) {
                throw new JbpmException("transition condition " + this.condition + " evaluated to 'false'");
            }
        }
        TransitionLog transitionLog = new TransitionLog(this, executionContext.getTransitionSource());
        token.startCompositeLog(transitionLog);
        try {
            this.fireSuperStateLeaveEvents(executionContext);
            this.fireEvent("transition", executionContext);
            Node destination = this.fireSuperStateEnterEvents(executionContext);
            transitionLog.setDestinationNode(destination);
        }
        finally {
            token.endCompositeLog();
        }
        this.to.enter(executionContext);
    }

    Node fireSuperStateEnterEvents(ExecutionContext executionContext) {
        Node destination = this.to;
        while (destination != null && destination.isSuperStateNode()) {
            List nodes = destination.getNodes();
            destination = nodes != null && !nodes.isEmpty() ? (Node)nodes.get(0) : null;
        }
        if (destination == null) {
            String transitionName = this.name != null ? "'" + this.name + "'" : "in node '" + this.from + "'";
            throw new JbpmException("transition " + transitionName + " doesn't have destination. check your processdefinition.xml");
        }
        if (destination.getSuperState() != null) {
            List leavingSuperStates = Transition.collectAllSuperStates(destination, this.from);
            Collections.reverse(leavingSuperStates);
            this.fireSuperStateEvents(leavingSuperStates, "superstate-enter", executionContext);
        }
        return destination;
    }

    void fireSuperStateLeaveEvents(ExecutionContext executionContext) {
        if (executionContext.getTransitionSource().getSuperState() != null) {
            List leavingSuperStates = Transition.collectAllSuperStates(executionContext.getTransitionSource(), this.to);
            this.fireSuperStateEvents(leavingSuperStates, "superstate-leave", executionContext);
        }
    }

    static List collectAllSuperStates(Node a, Node b) {
        SuperState superState = a.getSuperState();
        ArrayList<SuperState> leavingSuperStates = new ArrayList<SuperState>();
        while (superState != null) {
            if (!superState.containsNode(b)) {
                leavingSuperStates.add(superState);
                superState = superState.getSuperState();
                continue;
            }
            superState = null;
        }
        return leavingSuperStates;
    }

    void fireSuperStateEvents(List superStates, String eventType, ExecutionContext executionContext) {
        Iterator iter = superStates.iterator();
        while (iter.hasNext()) {
            SuperState leavingSuperState = (SuperState)iter.next();
            leavingSuperState.fireEvent(eventType, executionContext);
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Transition)) {
            return false;
        }
        Transition other = (Transition)o;
        return this.id != 0L ? this.id == other.getId() : (this.name != null ? this.name.equals(other.getName()) : other.getName() == null) && (this.from != null ? this.from.equals(other.getFrom()) : other.getFrom() == null) && (this.to != null ? this.to.equals(other.getTo()) : other.getTo() == null);
    }

    public int hashCode() {
        if (this.id != 0L) {
            return (int)(this.id ^ this.id >>> 32);
        }
        int result = 580399073 + (this.name != null ? this.name.hashCode() : 0);
        result = 345105097 * result + (this.from != null ? this.from.hashCode() : 0);
        result = 345105097 * result + (this.to != null ? this.to.hashCode() : 0);
        return result;
    }

    public void setName(String name) {
        if (this.from != null) {
            if (this.from.hasLeavingTransition(name)) {
                throw new IllegalArgumentException("couldn't set name '" + name + "' on transition '" + this + "'cause the from-node of this transition has already another leaving transition with the same name");
            }
            Map fromLeavingTransitions = this.from.getLeavingTransitionsMap();
            fromLeavingTransitions.remove(this.name);
            fromLeavingTransitions.put(name, this);
        }
        this.name = name;
    }

    public GraphElement getParent() {
        if (this.from != null && this.to != null) {
            if (this.from.equals(this.to)) {
                return this.from.getParent();
            }
            for (GraphElement fromParent = this.from; fromParent != null; fromParent = ((GraphElement)fromParent).getParent()) {
                for (GraphElement toParent = this.to; toParent != null; toParent = ((GraphElement)toParent).getParent()) {
                    if (!fromParent.equals(toParent)) continue;
                    return fromParent;
                }
            }
        }
        return this.processDefinition;
    }
}

