/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.jpdl.xml;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.jbpm.JbpmException;
import org.jbpm.graph.action.ActionTypes;
import org.jbpm.graph.def.Action;
import org.jbpm.graph.def.Event;
import org.jbpm.graph.def.GraphElement;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.def.Transition;
import org.jbpm.graph.node.ProcessFactory;
import org.jbpm.graph.node.StartState;
import org.jbpm.jpdl.JpdlException;
import org.jbpm.util.IoUtil;

public class JpdlXmlWriter {
    static final String JPDL_NAMESPACE = "http://jbpm.org/3/jpdl";
    static final Namespace jbpmNamespace = new Namespace(null, "http://jbpm.org/3/jpdl");
    Writer writer = null;
    List problems = new ArrayList();
    boolean useNamespace = false;

    public JpdlXmlWriter(Writer writer) {
        if (writer == null) {
            throw new JbpmException("writer is null");
        }
        this.writer = writer;
    }

    public void addProblem(String msg) {
        this.problems.add(msg);
    }

    public static String toString(ProcessDefinition processDefinition) {
        StringWriter stringWriter = new StringWriter();
        JpdlXmlWriter jpdlWriter = new JpdlXmlWriter(stringWriter);
        jpdlWriter.write(processDefinition);
        return stringWriter.toString();
    }

    public void setUseNamespace(boolean useNamespace) {
        this.useNamespace = useNamespace;
    }

    public void write(ProcessDefinition processDefinition) {
        this.problems = new ArrayList();
        if (processDefinition == null) {
            throw new JbpmException("processDefinition is null");
        }
        try {
            Document document = this.createDomTree(processDefinition);
            OutputFormat outputFormat = new OutputFormat("  ", true);
            XMLWriter xmlWriter = new XMLWriter(this.writer, outputFormat);
            xmlWriter.write(document);
            xmlWriter.flush();
            this.writer.flush();
        }
        catch (IOException e) {
            this.addProblem("couldn't write process definition xml: " + e.getMessage());
        }
        if (this.problems.size() > 0) {
            throw new JpdlException(this.problems);
        }
    }

    private Document createDomTree(ProcessDefinition processDefinition) {
        Document document = DocumentHelper.createDocument();
        Element root = this.useNamespace ? document.addElement("process-definition", jbpmNamespace.getURI()) : document.addElement("process-definition");
        this.addAttribute(root, "name", processDefinition.getName());
        if (processDefinition.getStartState() != null) {
            this.writeComment(root, "START-STATE");
            this.writeStartNode(root, (StartState)processDefinition.getStartState());
        }
        if (processDefinition.getNodes() != null && processDefinition.getNodes().size() > 0) {
            this.writeComment(root, "NODES");
            this.writeNodes(root, processDefinition.getNodes());
        }
        if (processDefinition.hasEvents()) {
            this.writeComment(root, "PROCESS-EVENTS");
            this.writeEvents(root, processDefinition);
        }
        if (processDefinition.hasActions()) {
            this.writeComment(root, "ACTIONS");
            List namedProcessActions = this.getNamedProcessActions(processDefinition.getActions());
            this.writeActions(root, namedProcessActions);
        }
        root.addText(IoUtil.lineSeparator);
        return document;
    }

    private List getNamedProcessActions(Map actions) {
        ArrayList<Action> namedProcessActions = new ArrayList<Action>();
        Iterator iter = actions.values().iterator();
        while (iter.hasNext()) {
            Action action = (Action)iter.next();
            if (action.getEvent() != null || action.getName() == null) continue;
            namedProcessActions.add(action);
        }
        return namedProcessActions;
    }

    private void writeStartNode(Element element, StartState startState) {
        if (startState != null) {
            this.writeNode(this.addElement(element, this.getTypeName(startState)), startState);
        }
    }

    private void writeNodes(Element parentElement, Collection nodes) {
        Iterator iter = nodes.iterator();
        while (iter.hasNext()) {
            Node node = (Node)iter.next();
            if (node instanceof StartState) continue;
            Element nodeElement = this.addElement(parentElement, ProcessFactory.getTypeName(node));
            node.write(nodeElement);
            this.writeNode(nodeElement, node);
        }
    }

    private void writeNode(Element element, Node node) {
        this.addAttribute(element, "name", node.getName());
        this.writeTransitions(element, node);
        this.writeEvents(element, node);
    }

    private void writeTransitions(Element element, Node node) {
        if (node.getLeavingTransitionsMap() != null) {
            Iterator iter = node.getLeavingTransitionsList().iterator();
            while (iter.hasNext()) {
                Transition transition = (Transition)iter.next();
                this.writeTransition(element.addElement("transition"), transition);
            }
        }
    }

    private void writeTransition(Element transitionElement, Transition transition) {
        Event transitionEvent;
        if (transition.getTo() != null) {
            transitionElement.addAttribute("to", transition.getTo().getName());
        }
        if (transition.getName() != null) {
            transitionElement.addAttribute("name", transition.getName());
        }
        if ((transitionEvent = transition.getEvent("transition")) != null && transitionEvent.hasActions()) {
            this.writeActions(transitionElement, transitionEvent.getActions());
        }
    }

    private void writeEvents(Element element, GraphElement graphElement) {
        if (graphElement.hasEvents()) {
            Iterator iter = graphElement.getEvents().values().iterator();
            while (iter.hasNext()) {
                Event event = (Event)iter.next();
                this.writeEvent(element.addElement("event"), event);
            }
        }
    }

    private void writeEvent(Element eventElement, Event event) {
        eventElement.addAttribute("type", event.getEventType());
        if (event.hasActions()) {
            Iterator actionIter = event.getActions().iterator();
            while (actionIter.hasNext()) {
                Action action = (Action)actionIter.next();
                this.writeAction(eventElement, action);
            }
        }
    }

    private void writeActions(Element parentElement, Collection actions) {
        Iterator actionIter = actions.iterator();
        while (actionIter.hasNext()) {
            Action action = (Action)actionIter.next();
            this.writeAction(parentElement, action);
        }
    }

    private void writeAction(Element parentElement, Action action) {
        String actionName = ActionTypes.getActionName(action.getClass());
        Element actionElement = parentElement.addElement(actionName);
        if (action.getName() != null) {
            actionElement.addAttribute("name", action.getName());
        }
        if (!action.acceptsPropagatedEvents()) {
            actionElement.addAttribute("accept-propagated-events", "false");
        }
        action.write(actionElement);
    }

    private void writeComment(Element element, String comment) {
        element.addText(IoUtil.lineSeparator);
        element.addComment(" " + comment + " ");
    }

    private Element addElement(Element element, String elementName) {
        Element newElement = element.addElement(elementName);
        return newElement;
    }

    private void addAttribute(Element e, String attributeName, String value) {
        if (value != null) {
            e.addAttribute(attributeName, value);
        }
    }

    private String getTypeName(Object o) {
        return ProcessFactory.getTypeName((Node)o);
    }
}

