/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.jdbc.listeners;

import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.GroupHandler;
import org.exoplatform.services.organization.MembershipHandler;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.MembershipTypeHandler;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.services.organization.jdbc.UserDAOImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateUserListener
extends Listener<UserDAOImpl, User> {
    private OrganizationService service_;
    protected static Log log = ExoLogger.getLogger((String)"exo.core.component.organization.jdbc.CreateUserListener");

    public CreateUserListener(OrganizationService service) {
        this.service_ = service;
    }

    public void onEvent(Event<UserDAOImpl, User> event) throws Exception {
        log.info((Object)("Create User Profile: " + ((User)event.getData()).getUserName()));
        UserProfile profile = this.service_.getUserProfileHandler().createUserProfileInstance(((User)event.getData()).getUserName());
        this.service_.getUserProfileHandler().saveUserProfile(profile, true);
        GroupHandler groupHandler = this.service_.getGroupHandler();
        Group g = groupHandler.findGroupById("/user");
        MembershipTypeHandler membershipTypeHandler = this.service_.getMembershipTypeHandler();
        MembershipType memberType = membershipTypeHandler.findMembershipType("member");
        if (g == null) {
            g = groupHandler.createGroupInstance();
            g.setGroupName("user");
            groupHandler.addChild(null, g, true);
        }
        if (memberType == null) {
            memberType = membershipTypeHandler.createMembershipTypeInstance();
            memberType.setName("member");
            membershipTypeHandler.createMembershipType(memberType, true);
        }
        MembershipHandler membershipHandler = this.service_.getMembershipHandler();
        membershipHandler.linkMembership((User)event.getData(), g, memberType, true);
    }
}

