/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow.persistent;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.InvalidItemStateException;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.dataflow.ChangesLogIterator;
import org.exoplatform.services.jcr.dataflow.CompositeChangesLog;
import org.exoplatform.services.jcr.dataflow.DataManager;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.dataflow.PlainChangesLog;
import org.exoplatform.services.jcr.dataflow.PlainChangesLogImpl;
import org.exoplatform.services.jcr.dataflow.TransactionChangesLog;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.ItemType;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.NullItemData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.dataflow.persistent.ACLInheritanceSupportedWorkspaceDataManager;
import org.exoplatform.services.jcr.impl.dataflow.persistent.CacheableWorkspaceDataManager;
import org.exoplatform.services.jcr.util.IdGenerator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionableWorkspaceDataManager
extends ACLInheritanceSupportedWorkspaceDataManager {
    private static Log log = ExoLogger.getLogger((String)"exo.jcr.component.core.VersionableWorkspaceDataManager");
    private ACLInheritanceSupportedWorkspaceDataManager versionDataManager;

    public VersionableWorkspaceDataManager(CacheableWorkspaceDataManager persistentManager) {
        super(persistentManager);
    }

    public void setSystemDataManager(DataManager systemDataManager) {
        this.versionDataManager = (ACLInheritanceSupportedWorkspaceDataManager)systemDataManager;
    }

    @Override
    public List<NodeData> getChildNodesData(NodeData nodeData) throws RepositoryException {
        if (this.isSystemDescendant(nodeData.getQPath()) && !this.equals(this.versionDataManager)) {
            return this.versionDataManager.getChildNodesData(nodeData);
        }
        return super.getChildNodesData(nodeData);
    }

    @Override
    public int getChildNodesCount(NodeData parent) throws RepositoryException {
        if (this.isSystemDescendant(parent.getQPath()) && !this.equals(this.versionDataManager)) {
            return this.versionDataManager.getChildNodesCount(parent);
        }
        return super.getChildNodesCount(parent);
    }

    @Override
    public List<PropertyData> getChildPropertiesData(NodeData nodeData) throws RepositoryException {
        if (this.isSystemDescendant(nodeData.getQPath()) && !this.equals(this.versionDataManager)) {
            return this.versionDataManager.getChildPropertiesData(nodeData);
        }
        return super.getChildPropertiesData(nodeData);
    }

    @Override
    public List<PropertyData> listChildPropertiesData(NodeData nodeData) throws RepositoryException {
        if (this.isSystemDescendant(nodeData.getQPath()) && !this.equals(this.versionDataManager)) {
            return this.versionDataManager.listChildPropertiesData(nodeData);
        }
        return super.listChildPropertiesData(nodeData);
    }

    @Override
    public ItemData getItemData(NodeData parentData, QPathEntry name) throws RepositoryException {
        return this.getItemData(parentData, name, ItemType.UNKNOWN);
    }

    @Override
    public ItemData getItemData(NodeData parentData, QPathEntry name, ItemType itemType) throws RepositoryException {
        return this.getItemData(parentData, name, itemType, true);
    }

    @Override
    public ItemData getItemData(NodeData parentData, QPathEntry name, ItemType itemType, boolean createNullItemData) throws RepositoryException {
        QPath ipath;
        if (parentData != null && this.isSystemDescendant(ipath = QPath.makeChildPath(parentData.getQPath(), name)) && !this.equals(this.versionDataManager)) {
            return this.versionDataManager.getItemData(parentData, name, itemType, createNullItemData);
        }
        return super.getItemData(parentData, name, itemType, createNullItemData);
    }

    @Override
    public ItemData getItemData(String identifier) throws RepositoryException {
        ItemData cdata = this.persistentManager.getCachedItemData(identifier);
        if (cdata != null && !(cdata instanceof NullItemData)) {
            return super.getItemData(identifier);
        }
        if (!(this.equals(this.versionDataManager) || identifier.equals("00exo0jcr0root0uuid0000000000000") || (cdata = this.versionDataManager.persistentManager.getCachedItemData(identifier)) == null || cdata instanceof NullItemData)) {
            if (this.isSystemDescendant(cdata.getQPath())) {
                return this.versionDataManager.getItemData(identifier);
            }
            return null;
        }
        ItemData data = super.getItemData(identifier);
        if (data != null) {
            return data;
        }
        if (!this.equals(this.versionDataManager) && (data = this.versionDataManager.getItemData(identifier)) != null && this.isSystemDescendant(data.getQPath())) {
            return data;
        }
        return null;
    }

    public void save(CompositeChangesLog changesLog) throws RepositoryException, InvalidItemStateException {
        ChangesLogIterator logIterator = changesLog.getLogIterator();
        TransactionChangesLog versionLogs = new TransactionChangesLog();
        TransactionChangesLog nonVersionLogs = new TransactionChangesLog();
        while (logIterator.hasNextLog()) {
            ArrayList<ItemState> vstates = new ArrayList<ItemState>();
            ArrayList<ItemState> nvstates = new ArrayList<ItemState>();
            PlainChangesLog changes = logIterator.nextLog();
            for (ItemState change : changes.getAllStates()) {
                if (this.isSystemDescendant(change.getData().getQPath()) && !this.equals(this.versionDataManager)) {
                    vstates.add(change);
                    continue;
                }
                nvstates.add(change);
            }
            if (vstates.size() > 0) {
                if (nvstates.size() > 0) {
                    String pairId = IdGenerator.generate();
                    versionLogs.addLog(PlainChangesLogImpl.createCopy(vstates, pairId, changes));
                    nonVersionLogs.addLog(PlainChangesLogImpl.createCopy(nvstates, pairId, changes));
                    continue;
                }
                versionLogs.addLog(PlainChangesLogImpl.createCopy(vstates, changes));
                nonVersionLogs.addLog(PlainChangesLogImpl.createCopy(nvstates, changes));
                continue;
            }
            if (nvstates.size() <= 0) continue;
            nonVersionLogs.addLog(PlainChangesLogImpl.createCopy(nvstates, changes));
        }
        if (versionLogs.getSize() > 0) {
            this.versionDataManager.save(versionLogs);
        }
        if (nonVersionLogs.getSize() > 0) {
            super.save(nonVersionLogs);
        }
    }

    private boolean isSystemDescendant(QPath path) {
        return path.isDescendantOf(Constants.JCR_SYSTEM_PATH) || path.equals(Constants.JCR_SYSTEM_PATH);
    }
}

