/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.publication.listener.post;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import org.exoplatform.services.cms.CmsService;
import org.exoplatform.services.cms.actions.ActionServiceContainer;
import org.exoplatform.services.cms.taxonomy.TaxonomyService;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.wcm.publication.WCMComposer;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PostCreateNodeTypeEventListener
extends Listener<CmsService, String> {
    private WCMComposer composer;
    private TaxonomyService taxonomyService;
    private ActionServiceContainer actionServiceContainer;
    private static final String NT_TAXONOMY_ACTION = "exo:taxonomyAction";

    public PostCreateNodeTypeEventListener(WCMComposer composer) {
        this.composer = composer;
    }

    public void onEvent(Event<CmsService, String> event) throws Exception {
        this.composer.cleanTemplates();
        this.taxonomyService = (TaxonomyService)WCMCoreUtils.getService(TaxonomyService.class);
        this.actionServiceContainer = (ActionServiceContainer)WCMCoreUtils.getService(ActionServiceContainer.class);
        String nodetypeName = (String)event.getData();
        String repository = WCMCoreUtils.getRepository(null).getConfiguration().getName();
        List taxonomyTrees = this.taxonomyService.getAllTaxonomyTrees(repository);
        for (Node taxonomyTree : taxonomyTrees) {
            Node taxonomyAction = null;
            List actions = this.actionServiceContainer.getActions(taxonomyTree);
            for (Node action : actions) {
                if (!action.isNodeType(NT_TAXONOMY_ACTION)) continue;
                taxonomyAction = action;
                break;
            }
            Session session = taxonomyAction.getSession();
            ValueFactory valueFactory = session.getValueFactory();
            Value[] values = taxonomyAction.getProperty("exo:affectedNodeTypeNames").getValues();
            ArrayList<Value> tmpValues = new ArrayList<Value>();
            for (Value value : values) {
                tmpValues.add(value);
            }
            tmpValues.add(valueFactory.createValue(nodetypeName));
            taxonomyAction.setProperty("exo:affectedNodeTypeNames", tmpValues.toArray(new Value[tmpValues.size()]));
            session.save();
            session.logout();
        }
    }
}

