/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.versions;

import javax.jcr.Node;
import javax.jcr.ReferentialIntegrityException;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import org.exoplatform.ecm.jcr.model.VersionNode;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.versions.UIDiff;
import org.exoplatform.ecm.webui.component.explorer.versions.UILabelForm;
import org.exoplatform.ecm.webui.component.explorer.versions.UIRemoveLabelForm;
import org.exoplatform.ecm.webui.component.explorer.versions.UIViewVersion;
import org.exoplatform.services.jcr.impl.storage.JCRInvalidItemStateException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(template="app:/groovy/webui/component/explorer/versions/UIVersionInfo.gtmpl", events={@EventConfig(listeners={SelectActionListener.class}), @EventConfig(listeners={RestoreVersionActionListener.class}), @EventConfig(listeners={ViewVersionActionListener.class}), @EventConfig(listeners={AddLabelActionListener.class}), @EventConfig(listeners={CompareVersionActionListener.class}), @EventConfig(listeners={DeleteVersionActionListener.class}, confirm="UIVersionInfo.msg.confirm-delete"), @EventConfig(listeners={RemoveLabelActionListener.class}), @EventConfig(listeners={CloseActionListener.class}), @EventConfig(listeners={CloseViewActionListener.class})})
public class UIVersionInfo
extends UIContainer
implements UIPopupComponent {
    protected VersionNode rootVersion_;
    protected VersionNode curentVersion_;
    protected Node node_;
    private static final Log LOG = ExoLogger.getLogger((String)"explorer.UIVersionInfo");

    public UIVersionInfo() throws Exception {
        ((UILabelForm)this.addChild(UILabelForm.class, null, null)).setRendered(false);
        ((UIRemoveLabelForm)this.addChild(UIRemoveLabelForm.class, null, null)).setRendered(false);
        ((UIViewVersion)this.addChild(UIViewVersion.class, null, null)).setRendered(false);
        ((UIDiff)this.addChild(UIDiff.class, null, null)).setRendered(false);
    }

    public String[] getVersionLabels(VersionNode version) throws Exception {
        VersionHistory vH = this.node_.getVersionHistory();
        return vH.getVersionLabels(version.getVersion());
    }

    public boolean isBaseVersion(VersionNode versionNode) throws Exception {
        return this.node_.getBaseVersion().getName().equals(versionNode.getVersion().getName());
    }

    public VersionNode getRootVersionNode() throws Exception {
        return this.rootVersion_;
    }

    public void activate() throws Exception {
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        this.node_ = uiExplorer.getCurrentNode();
        this.curentVersion_ = this.rootVersion_ = new VersionNode(this.node_.getVersionHistory().getRootVersion(), uiExplorer.getSession());
        ((UIViewVersion)this.getChild(UIViewVersion.class)).update();
    }

    public void deActivate() throws Exception {
    }

    public VersionNode getCurrentVersionNode() {
        return this.curentVersion_;
    }

    public Node getCurrentNode() {
        return this.node_;
    }

    public boolean isViewVersion() {
        UIViewVersion uiViewVersion = (UIViewVersion)this.getChild(UIViewVersion.class);
        return uiViewVersion.isRendered();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CloseViewActionListener
    extends EventListener<UIVersionInfo> {
        public void execute(Event<UIVersionInfo> event) throws Exception {
            UIVersionInfo uiVersionInfo = (UIVersionInfo)((Object)event.getSource());
            UIViewVersion uiViewVersion = (UIViewVersion)uiVersionInfo.getChild(UIViewVersion.class);
            if (uiViewVersion.isRendered()) {
                uiViewVersion.setRendered(false);
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiVersionInfo);
                return;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CloseActionListener
    extends EventListener<UIVersionInfo> {
        public void execute(Event<UIVersionInfo> event) throws Exception {
            UIVersionInfo uiVersionInfo = (UIVersionInfo)((Object)event.getSource());
            for (UIComponent uiChild : uiVersionInfo.getChildren()) {
                if (!uiChild.isRendered()) continue;
                uiChild.setRendered(false);
                return;
            }
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uiVersionInfo.getAncestorOfType(UIJCRExplorer.class);
            uiExplorer.cancelAction();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SelectActionListener
    extends EventListener<UIVersionInfo> {
        public void execute(Event<UIVersionInfo> event) throws Exception {
            VersionNode selectedVersion;
            UIVersionInfo uiVersionInfo = (UIVersionInfo)((Object)event.getSource());
            String path = event.getRequestContext().getRequestParameter("objectId");
            VersionNode root = uiVersionInfo.getRootVersionNode();
            selectedVersion.setExpanded(!(selectedVersion = root.findVersionNode(path)).isExpanded());
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiVersionInfo);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CompareVersionActionListener
    extends EventListener<UIVersionInfo> {
        public void execute(Event<UIVersionInfo> event) throws Exception {
            UIVersionInfo uiVersionInfo = (UIVersionInfo)((Object)event.getSource());
            for (UIComponent uiChild : uiVersionInfo.getChildren()) {
                uiChild.setRendered(false);
            }
            String objectId = event.getRequestContext().getRequestParameter("objectId");
            VersionNode node = uiVersionInfo.rootVersion_.findVersionNode(objectId);
            UIDiff uiDiff = (UIDiff)uiVersionInfo.getChild(UIDiff.class);
            uiDiff.setVersions(uiVersionInfo.getCurrentNode().getBaseVersion(), node.getVersion());
            uiDiff.setRendered(true);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiVersionInfo);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DeleteVersionActionListener
    extends EventListener<UIVersionInfo> {
        public void execute(Event<UIVersionInfo> event) throws Exception {
            UIVersionInfo uiVersionInfo = (UIVersionInfo)((Object)event.getSource());
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uiVersionInfo.getAncestorOfType(UIJCRExplorer.class);
            for (UIComponent uiChild : uiVersionInfo.getChildren()) {
                uiChild.setRendered(false);
            }
            String objectId = event.getRequestContext().getRequestParameter("objectId");
            uiVersionInfo.curentVersion_ = uiVersionInfo.rootVersion_.findVersionNode(objectId);
            Node node = uiVersionInfo.getCurrentNode();
            VersionHistory versionHistory = node.getVersionHistory();
            UIApplication app = (UIApplication)uiVersionInfo.getAncestorOfType(UIApplication.class);
            try {
                versionHistory.removeVersion(uiVersionInfo.curentVersion_.getName());
                uiVersionInfo.rootVersion_.removeVersionInChild(uiVersionInfo.rootVersion_, uiVersionInfo.curentVersion_);
                uiVersionInfo.curentVersion_ = uiVersionInfo.rootVersion_ = new VersionNode(node.getVersionHistory().getRootVersion(), uiExplorer.getSession());
                if (!node.isCheckedOut()) {
                    node.checkout();
                }
                uiExplorer.getSession().save();
                event.getRequestContext().addUIComponentToUpdateByAjax(uiVersionInfo.getAncestorOfType(UIPopupContainer.class));
            }
            catch (ReferentialIntegrityException rie) {
                LOG.error((Object)"Unexpected error", (Throwable)rie);
                app.addMessage(new ApplicationMessage("UIVersionInfo.msg.cannot-remove-version", null));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)app.getUIPopupMessages());
                return;
            }
            catch (Exception e) {
                LOG.error((Object)"Unexpected error", (Throwable)e);
                app.addMessage(new ApplicationMessage("UIVersionInfo.msg.cannot-remove-version", null));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)app.getUIPopupMessages());
                return;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RestoreVersionActionListener
    extends EventListener<UIVersionInfo> {
        public void execute(Event<UIVersionInfo> event) throws Exception {
            UIVersionInfo uiVersionInfo = (UIVersionInfo)((Object)event.getSource());
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uiVersionInfo.getAncestorOfType(UIJCRExplorer.class);
            for (UIComponent uiChild : uiVersionInfo.getChildren()) {
                uiChild.setRendered(false);
            }
            String objectId = event.getRequestContext().getRequestParameter("objectId");
            uiVersionInfo.curentVersion_ = uiVersionInfo.rootVersion_.findVersionNode(objectId);
            UIApplication uiApp = (UIApplication)uiVersionInfo.getAncestorOfType(UIApplication.class);
            uiExplorer.addLockToken(uiVersionInfo.node_);
            try {
                uiVersionInfo.node_.restore(uiVersionInfo.curentVersion_.getVersion(), true);
            }
            catch (JCRInvalidItemStateException invalid) {
                uiApp.addMessage(new ApplicationMessage("UIVersionInfo.msg.invalid-item-state", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            catch (NullPointerException nuException) {
                uiApp.addMessage(new ApplicationMessage("UIVersionInfo.msg.invalid-item-state", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            catch (Exception e) {
                uiApp.addMessage(new ApplicationMessage("UIVersionInfo.msg.invalid-item-state", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            Node node = uiVersionInfo.getCurrentNode();
            if (!node.isCheckedOut()) {
                node.checkout();
            }
            uiExplorer.getSession().save();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiVersionInfo);
            uiExplorer.setIsHidePopup(true);
            uiExplorer.updateAjax(event);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RemoveLabelActionListener
    extends EventListener<UIVersionInfo> {
        public void execute(Event<UIVersionInfo> event) throws Exception {
            UIVersionInfo uiVersionInfo = (UIVersionInfo)((Object)event.getSource());
            for (UIComponent uiChild : uiVersionInfo.getChildren()) {
                uiChild.setRendered(false);
            }
            String objectId = event.getRequestContext().getRequestParameter("objectId");
            uiVersionInfo.curentVersion_ = uiVersionInfo.rootVersion_.findVersionNode(objectId);
            ((UIRemoveLabelForm)uiVersionInfo.getChild(UIRemoveLabelForm.class)).update();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiVersionInfo);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddLabelActionListener
    extends EventListener<UIVersionInfo> {
        public void execute(Event<UIVersionInfo> event) throws Exception {
            UIVersionInfo uiVersionInfo = (UIVersionInfo)((Object)event.getSource());
            for (UIComponent uiChild : uiVersionInfo.getChildren()) {
                uiChild.setRendered(false);
            }
            String objectId = event.getRequestContext().getRequestParameter("objectId");
            uiVersionInfo.curentVersion_ = uiVersionInfo.rootVersion_.findVersionNode(objectId);
            ((UILabelForm)uiVersionInfo.getChild(UILabelForm.class)).setRendered(true);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiVersionInfo);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ViewVersionActionListener
    extends EventListener<UIVersionInfo> {
        public void execute(Event<UIVersionInfo> event) throws Exception {
            UIVersionInfo uiVersionInfo = (UIVersionInfo)((Object)event.getSource());
            for (UIComponent uiChild : uiVersionInfo.getChildren()) {
                uiChild.setRendered(false);
            }
            String objectId = event.getRequestContext().getRequestParameter("objectId");
            uiVersionInfo.curentVersion_ = uiVersionInfo.rootVersion_.findVersionNode(objectId);
            UIViewVersion uiViewVersion = (UIViewVersion)uiVersionInfo.getChild(UIViewVersion.class);
            Version version_ = uiVersionInfo.curentVersion_.getVersion();
            Node frozenNode = version_.getNode("jcr:frozenNode");
            uiViewVersion.setNode(frozenNode);
            if (uiViewVersion.getTemplate() == null || uiViewVersion.getTemplate().trim().length() == 0) {
                UIApplication uiApp = (UIApplication)uiVersionInfo.getAncestorOfType(UIApplication.class);
                uiApp.addMessage(new ApplicationMessage("UIVersionInfo.msg.have-no-view-template", null));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            uiViewVersion.setRendered(true);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiVersionInfo);
        }
    }
}

