/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.commands.tx;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.commands.ReplicableCommand;
import org.jboss.cache.commands.Visitor;
import org.jboss.cache.commands.WriteCommand;
import org.jboss.cache.commands.tx.AbstractTransactionCommand;
import org.jboss.cache.transaction.GlobalTransaction;
import org.jgroups.Address;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrepareCommand
extends AbstractTransactionCommand {
    public static final int METHOD_ID = 10;
    protected List<WriteCommand> modifications;
    protected Address localAddress;
    protected boolean onePhaseCommit;

    public PrepareCommand(GlobalTransaction gtx, List<WriteCommand> modifications, Address localAddress, boolean onePhaseCommit) {
        this.globalTransaction = gtx;
        this.modifications = modifications;
        this.localAddress = localAddress;
        this.onePhaseCommit = onePhaseCommit;
    }

    public void removeModifications(Collection<WriteCommand> modificationsToRemove) {
        if (this.modifications != null) {
            this.modifications.removeAll(modificationsToRemove);
        }
    }

    public PrepareCommand() {
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitPrepareCommand(ctx, this);
    }

    public List<WriteCommand> getModifications() {
        return this.modifications;
    }

    public Address getLocalAddress() {
        return this.localAddress;
    }

    public boolean isOnePhaseCommit() {
        return this.onePhaseCommit;
    }

    public boolean existModifications() {
        return this.modifications != null && this.modifications.size() > 0;
    }

    public int getModificationsCount() {
        return this.modifications != null ? this.modifications.size() : 0;
    }

    @Override
    public int getCommandId() {
        return 10;
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{this.globalTransaction, this.modifications, this.localAddress, this.onePhaseCommit};
    }

    @Override
    public void setParameters(int commandId, Object[] args) {
        this.globalTransaction = (GlobalTransaction)args[0];
        this.modifications = (List)args[1];
        this.localAddress = (Address)args[2];
        this.onePhaseCommit = (Boolean)args[3];
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PrepareCommand that = (PrepareCommand)o;
        if (this.onePhaseCommit != that.onePhaseCommit) {
            return false;
        }
        if (this.localAddress != null ? !this.localAddress.equals(that.localAddress) : that.localAddress != null) {
            return false;
        }
        return !(this.modifications != null ? !((Object)this.modifications).equals(that.modifications) : that.modifications != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.modifications != null ? ((Object)this.modifications).hashCode() : 0);
        result = 31 * result + (this.localAddress != null ? this.localAddress.hashCode() : 0);
        result = 31 * result + (this.onePhaseCommit ? 1 : 0);
        return result;
    }

    public PrepareCommand copy() {
        PrepareCommand copy = new PrepareCommand();
        copy.globalTransaction = this.globalTransaction;
        copy.localAddress = this.localAddress;
        copy.modifications = this.modifications == null ? null : new ArrayList<WriteCommand>(this.modifications);
        copy.onePhaseCommit = this.onePhaseCommit;
        return copy;
    }

    @Override
    public String toString() {
        return "PrepareCommand{globalTransaction=" + this.globalTransaction + ", modifications=" + this.modifications + ", localAddress=" + this.localAddress + ", onePhaseCommit=" + this.onePhaseCommit + '}';
    }

    public boolean containsModificationType(Class<? extends ReplicableCommand> replicableCommandClass) {
        for (WriteCommand mod : this.getModifications()) {
            if (!mod.getClass().equals(replicableCommandClass)) continue;
            return true;
        }
        return false;
    }
}

