/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.WebRequestHandler;
import org.exoplatform.web.application.Application;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebAppController {
    protected static Log log = ExoLogger.getLogger((String)"portal:WebAppController");
    private HashMap<String, Object> attributes_;
    private volatile HashMap<String, Application> applications_ = new HashMap();
    private HashMap<String, WebRequestHandler> handlers_;

    public WebAppController() throws Exception {
        this.attributes_ = new HashMap();
        this.handlers_ = new HashMap();
    }

    public Object getAttribute(String name, Object value) {
        return this.attributes_.get(name);
    }

    public <T extends Application> T getApplication(String appId) {
        return (T)((Object)this.applications_.get(appId));
    }

    public List<Application> getApplicationByType(String type) {
        ArrayList<Application> applications = new ArrayList<Application>();
        for (Application app : this.applications_.values()) {
            if (!app.getApplicationType().equals(type)) continue;
            applications.add(app);
        }
        return applications;
    }

    public synchronized void removeApplication(String appId) {
        this.applications_.remove(appId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Application> T addApplication(T app) {
        T result = this.getApplication(app.getApplicationId());
        if (result == null) {
            WebAppController webAppController = this;
            synchronized (webAppController) {
                result = this.getApplication(app.getApplicationId());
                if (result == null) {
                    HashMap<String, Application> applications = new HashMap<String, Application>(this.applications_);
                    applications.put(app.getApplicationId(), app);
                    this.applications_ = applications;
                    result = app;
                }
            }
        }
        return result;
    }

    public void register(WebRequestHandler handler) throws Exception {
        for (String path : handler.getPath()) {
            this.handlers_.put(path, handler);
        }
    }

    public void unregister(String[] paths) {
        for (String path : paths) {
            this.handlers_.remove(path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(HttpServletRequest req, HttpServletResponse res) throws Exception {
        WebRequestHandler handler = this.handlers_.get(req.getServletPath());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Servlet Path: " + req.getServletPath()));
            log.debug((Object)("Handler used for this path: " + (Object)((Object)handler)));
        }
        if (handler != null) {
            ExoContainer portalContainer = ExoContainerContext.getCurrentContainer();
            RequestLifeCycle.begin((ExoContainer)portalContainer);
            try {
                handler.execute(this, req, res);
            }
            finally {
                RequestLifeCycle.end();
            }
        }
    }
}

