/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.form.validator;

import java.text.SimpleDateFormat;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.exception.MessageException;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormDateTimeInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.validator.Validator;

public class DateTimeValidator
implements Validator {
    private static final String SPLIT_REGEX = "/|\\s+|:";
    private static final String DATETIME_REGEX = "^(\\d{1,2}\\/\\d{1,2}\\/\\d{1,4})\\s*(\\s+\\d{1,2}:\\d{1,2}:\\d{1,2})?$";

    public void validate(UIFormInput uiInput) throws Exception {
        String label;
        if (uiInput.getValue() == null || ((String)uiInput.getValue()).trim().length() == 0) {
            return;
        }
        String s = (String)uiInput.getValue();
        SimpleDateFormat stFormat = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
        UIFormDateTimeInput uiDateInput = (UIFormDateTimeInput)uiInput;
        SimpleDateFormat sdf = new SimpleDateFormat(uiDateInput.getDatePattern_().trim());
        UIForm uiForm = (UIForm)((UIComponent)uiInput).getAncestorOfType(UIForm.class);
        try {
            label = uiForm.getId() + ".label." + uiInput.getName();
        }
        catch (Exception e) {
            label = uiInput.getName();
        }
        Object[] args = new Object[]{label, s};
        try {
            sdf.setLenient(false);
            sdf.parse(s);
        }
        catch (Exception e) {
            throw new MessageException(new ApplicationMessage("DateTimeValidator.msg.Invalid-input", args, 1));
        }
        if (s.matches(DATETIME_REGEX)) {
            return;
        }
        throw new MessageException(new ApplicationMessage("DateTimeValidator.msg.Invalid-input", args, 1));
    }
}

