/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite;

import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.shindig.gadgets.spec.Feature;
import org.apache.shindig.gadgets.spec.GadgetSpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentRewriterFeature {
    private static final String INCLUDE_URLS = "include-urls";
    private static final String EXCLUDE_URLS = "exclude-urls";
    private static final String INCLUDE_TAGS = "include-tags";
    private static final String EXPIRES = "expires";
    public static final String EXPIRES_DEFAULT = "HTTP";
    private Set<String> includeTags;
    private boolean includeAll;
    private boolean includeNone;
    private Pattern include;
    private Pattern exclude;
    private Integer expires;
    private Integer fingerprint;

    public ContentRewriterFeature(GadgetSpec spec, String defaultInclude, String defaultExclude, String defaultExpires, Set<String> defaultTags) {
        Feature f = null;
        if (spec != null) {
            f = spec.getModulePrefs().getFeatures().get("content-rewrite");
        }
        String includeRegex = this.normalizeParam(defaultInclude, null);
        String excludeRegex = this.normalizeParam(defaultExclude, null);
        this.includeTags = ImmutableSortedSet.copyOf(defaultTags);
        ArrayList expiresOptions = Lists.newArrayListWithCapacity((int)3);
        if (f != null) {
            String includeTagList;
            if (f.getParams().containsKey((Object)INCLUDE_URLS)) {
                includeRegex = this.normalizeParam(f.getParam(INCLUDE_URLS), includeRegex);
            }
            if (f.getParams().containsKey((Object)EXCLUDE_URLS)) {
                excludeRegex = this.normalizeParam(f.getParam(EXCLUDE_URLS), null);
            }
            if ((includeTagList = f.getParam(INCLUDE_TAGS)) != null) {
                TreeSet tags = Sets.newTreeSet();
                for (String tag : includeTagList.split(",")) {
                    if (tag == null) continue;
                    tags.add(tag.trim().toLowerCase());
                }
                this.includeTags = tags;
            }
            if (f.getParams().containsKey((Object)EXPIRES)) {
                expiresOptions.add(this.normalizeParam(f.getParam(EXPIRES), null));
            }
        }
        expiresOptions.add(defaultExpires);
        expiresOptions.add(EXPIRES_DEFAULT);
        for (String expiryOption : expiresOptions) {
            try {
                this.expires = new Integer(expiryOption);
            }
            catch (NumberFormatException nfe) {
                if (!EXPIRES_DEFAULT.equalsIgnoreCase(expiryOption)) continue;
            }
            break;
        }
        if (".*".equals(includeRegex) && excludeRegex == null) {
            this.includeAll = true;
        }
        if (".*".equals(excludeRegex) || includeRegex == null) {
            this.includeNone = true;
        }
        if (includeRegex != null) {
            this.include = Pattern.compile(includeRegex);
        }
        if (excludeRegex != null) {
            this.exclude = Pattern.compile(excludeRegex);
        }
    }

    private String normalizeParam(String paramValue, String defaultVal) {
        if (paramValue == null) {
            return defaultVal;
        }
        if ((paramValue = paramValue.trim()).length() == 0) {
            return defaultVal;
        }
        return paramValue;
    }

    public boolean isRewriteEnabled() {
        return !this.includeNone;
    }

    public boolean shouldRewriteURL(String url) {
        if (this.includeNone) {
            return false;
        }
        if (this.includeAll) {
            return true;
        }
        if (this.include.matcher(url).find()) {
            return this.exclude == null || !this.exclude.matcher(url).find();
        }
        return false;
    }

    public boolean shouldRewriteTag(String tag) {
        if (tag != null) {
            return this.includeTags.contains(tag.toLowerCase());
        }
        return false;
    }

    public Set<String> getIncludedTags() {
        return this.includeTags;
    }

    public Integer getExpires() {
        return this.expires;
    }

    public int getFingerprint() {
        if (this.fingerprint == null) {
            int result = this.include != null ? this.include.pattern().hashCode() : 0;
            result = 31 * result + (this.exclude != null ? this.exclude.pattern().hashCode() : 0);
            for (String s : this.includeTags) {
                result = 31 * result + s.hashCode();
            }
            this.fingerprint = result;
        }
        return this.fingerprint;
    }
}

