/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.chain.generic;

import org.apache.commons.chain.Catalog;
import org.apache.commons.chain.CatalogFactory;
import org.apache.commons.chain.Command;
import org.apache.commons.chain.Context;
import org.apache.commons.chain.Filter;

public class LookupCommand
implements Filter {
    private String catalogName = null;
    private String name = null;
    private String nameKey = null;
    private boolean optional = false;

    public String getCatalogName() {
        return this.catalogName;
    }

    public void setCatalogName(String catalogName) {
        this.catalogName = catalogName;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNameKey() {
        return this.nameKey;
    }

    public void setNameKey(String nameKey) {
        this.nameKey = nameKey;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public void setOptional(boolean optional) {
        this.optional = optional;
    }

    public boolean execute(Context context) throws Exception {
        Command command = this.getCommand(context);
        if (command != null) {
            return command.execute(context);
        }
        return false;
    }

    public boolean postprocess(Context context, Exception exception) {
        Command command = this.getCommand(context);
        if (command != null && command instanceof Filter) {
            return ((Filter)command).postprocess(context, exception);
        }
        return false;
    }

    private Command getCommand(Context context) {
        CatalogFactory catalogFactory = CatalogFactory.getInstance();
        String catalogName = this.getCatalogName();
        Catalog catalog = null;
        catalog = catalogName == null ? catalogFactory.getCatalog() : catalogFactory.getCatalog(catalogName);
        if (catalog == null) {
            if (catalogName == null) {
                throw new IllegalArgumentException("Cannot find default catalog");
            }
            throw new IllegalArgumentException("Cannot find catalog '" + catalogName + "'");
        }
        Command command = null;
        String name = this.getName();
        if (name == null) {
            name = (String)context.get(this.getNameKey());
        }
        if (name != null) {
            command = catalog.getCommand(name);
            if (command == null && !this.isOptional()) {
                if (catalogName == null) {
                    throw new IllegalArgumentException("Cannot find command '" + name + "' in default catalog");
                }
                throw new IllegalArgumentException("Cannot find command '" + name + "' in catalog '" + catalogName + "'");
            }
            return command;
        }
        throw new IllegalArgumentException("No command name");
    }
}

