/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.ldap;

import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.database.HibernateService;
import org.exoplatform.services.ldap.LDAPService;
import org.exoplatform.services.organization.BaseOrganizationService;
import org.exoplatform.services.organization.hibernate.UserProfileDAOImpl;
import org.exoplatform.services.organization.ldap.ADGroupDAOImpl;
import org.exoplatform.services.organization.ldap.ADMembershipDAOImpl;
import org.exoplatform.services.organization.ldap.ADSearchBySID;
import org.exoplatform.services.organization.ldap.ADUserDAOImpl;
import org.exoplatform.services.organization.ldap.CacheHandler;
import org.exoplatform.services.organization.ldap.GroupDAOImpl;
import org.exoplatform.services.organization.ldap.LDAPAttributeMapping;
import org.exoplatform.services.organization.ldap.MembershipDAOImpl;
import org.exoplatform.services.organization.ldap.MembershipTypeDAOImpl;
import org.exoplatform.services.organization.ldap.UserDAOImpl;

public class OrganizationServiceImpl
extends BaseOrganizationService {
    public OrganizationServiceImpl(InitParams params, LDAPService ldapService, HibernateService hservice, CacheService cservice) throws Exception {
        LDAPAttributeMapping ldapAttrMapping = (LDAPAttributeMapping)params.getObjectParam("ldap.attribute.mapping").getObject();
        CacheHandler cacheHandler = new CacheHandler(cservice);
        if (ldapService.getServerType() == 1) {
            this.userDAO_ = new ADUserDAOImpl(ldapAttrMapping, ldapService, cacheHandler);
            ADSearchBySID adSearch = new ADSearchBySID(ldapAttrMapping);
            this.groupDAO_ = new ADGroupDAOImpl(ldapAttrMapping, ldapService, adSearch, cacheHandler);
            this.membershipDAO_ = new ADMembershipDAOImpl(ldapAttrMapping, ldapService, adSearch, cacheHandler);
        } else {
            this.userDAO_ = new UserDAOImpl(ldapAttrMapping, ldapService, cacheHandler);
            this.groupDAO_ = new GroupDAOImpl(ldapAttrMapping, ldapService, cacheHandler);
            this.membershipDAO_ = new MembershipDAOImpl(ldapAttrMapping, ldapService, cacheHandler);
        }
        this.userProfileDAO_ = new UserProfileDAOImpl(hservice, cservice);
        this.membershipTypeDAO_ = new MembershipTypeDAOImpl(ldapAttrMapping, ldapService, cacheHandler);
        ValueParam param = params.getValueParam("ldap.userDN.key");
        if (param != null) {
            ldapAttrMapping.userDNKey = param.getValue();
        }
        if ((param = params.getValueParam("ldap.groupDN.key")) != null) {
            ldapAttrMapping.groupDNKey = param.getValue();
        }
    }
}

