/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.Date;
import org.jgroups.Address;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.ReceiverAdapter;
import org.jgroups.View;
import org.jgroups.protocols.TP;
import org.jgroups.stack.IpAddress;
import org.jgroups.util.Util;

public class UnicastChannelTest {
    boolean server = false;
    String host = "localhost";
    int port = 0;
    String props = null;
    JChannel ch;

    public void start(String[] args) throws Exception {
        for (int i = 0; i < args.length; ++i) {
            String tmp = args[i];
            if ("-server".equals(tmp)) {
                this.server = true;
                continue;
            }
            if ("-props".equals(tmp)) {
                this.props = args[++i];
                continue;
            }
            if ("-host".equals(tmp)) {
                this.host = args[++i];
                continue;
            }
            if ("-port".equals(tmp)) {
                this.port = Integer.parseInt(args[++i]);
                continue;
            }
            UnicastChannelTest.help();
            return;
        }
        this.ch = new JChannel(this.props);
        if (this.server) {
            this.ch.setReceiver(new ReceiverAdapter(){

                public void receive(Message msg) {
                    System.out.println("-- " + msg.getObject());
                    Address sender = msg.getSrc();
                    Message rsp = new Message(sender, null, (Serializable)((Object)("ack for " + msg.getObject())));
                    try {
                        UnicastChannelTest.this.ch.send(rsp);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
            this.runServer();
        } else {
            this.ch.setReceiver(new ReceiverAdapter(){

                public void receive(Message msg) {
                    System.out.println("<-- " + msg.getObject());
                }

                public void viewAccepted(View new_view) {
                    System.out.println("new_view = " + new_view);
                }

                public void suspect(Address suspected_mbr) {
                    System.out.println("suspected_mbr = " + suspected_mbr);
                }
            });
            this.runClient();
        }
    }

    void runClient() throws Exception {
        this.ch.connect(null);
        IpAddress addr = new IpAddress(this.host, this.port);
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        while (true) {
            System.out.print("> ");
            String line = reader.readLine();
            if (line.startsWith("quit") || line.startsWith("exit")) {
                this.ch.close();
                return;
            }
            Message msg = new Message((Address)addr, null, (Serializable)((Object)line));
            this.ch.send(msg);
        }
    }

    void runServer() throws Exception {
        TP transport;
        System.setProperty("jgroups.bind_addr", this.host);
        if (this.port > 0 && (transport = this.ch.getProtocolStack().getTransport()) instanceof TP) {
            transport.setBindPort(this.port);
        }
        this.ch.connect(null);
        System.out.println("server started at " + new Date() + ", listening on " + this.ch.getLocalAddress());
        while (this.ch.isOpen()) {
            Util.sleep(10000L);
        }
    }

    static void help() {
        System.out.println("UnicastChannelTest [-help] [-server] [-props <props>][-host <host>] [-port <port>]");
    }

    public static void main(String[] args) {
        try {
            new UnicastChannelTest().start(args);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

