/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.consumer.migration;

import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.gatein.common.util.ParameterValidation;
import org.gatein.wsrp.api.context.ConsumerStructureProvider;
import org.gatein.wsrp.consumer.migration.ExportInfo;
import org.gatein.wsrp.consumer.migration.MigrationService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InMemoryMigrationService
implements MigrationService {
    private SortedMap<Long, ExportInfo> exportInfos;
    private ConsumerStructureProvider structureProvider;

    @Override
    public ConsumerStructureProvider getStructureProvider() {
        return this.structureProvider;
    }

    @Override
    public void setStructureProvider(ConsumerStructureProvider structureProvider) {
        this.structureProvider = structureProvider;
    }

    @Override
    public List<ExportInfo> getAvailableExportInfos() {
        return new ArrayList<ExportInfo>(this.getExportInfos().values());
    }

    @Override
    public ExportInfo getExportInfo(long exportTime) {
        return (ExportInfo)this.exportInfos.get(exportTime);
    }

    @Override
    public void add(ExportInfo info) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)info, (String)"ExportInfo");
        this.getExportInfos().put(info.getExportTime(), info);
    }

    @Override
    public ExportInfo remove(ExportInfo info) {
        return info == null ? null : (ExportInfo)this.getExportInfos().remove(info.getExportTime());
    }

    private SortedMap<Long, ExportInfo> getExportInfos() {
        if (this.exportInfos == null) {
            this.exportInfos = new TreeMap<Long, ExportInfo>();
        }
        return this.exportInfos;
    }

    @Override
    public boolean isAvailableExportInfosEmpty() {
        return this.exportInfos == null || this.exportInfos.isEmpty();
    }
}

