/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.producer.config.impl.xml;

import java.util.Locale;
import javax.xml.namespace.QName;
import org.gatein.common.util.ParameterValidation;
import org.gatein.wsrp.WSRPConstants;
import org.gatein.wsrp.WSRPUtils;
import org.gatein.wsrp.producer.config.impl.ProducerConfigurationImpl;
import org.gatein.wsrp.producer.config.impl.ProducerRegistrationRequirementsImpl;
import org.gatein.wsrp.registration.LocalizedString;
import org.gatein.wsrp.registration.RegistrationPropertyDescription;
import org.jboss.util.StringPropertyReplacer;
import org.jboss.xb.binding.ObjectModelFactory;
import org.jboss.xb.binding.UnmarshallingContext;
import org.xml.sax.Attributes;

public class ProducerConfigurationFactory
implements ObjectModelFactory {
    private static final String REGISTRATION_CONFIG = "registration-configuration";
    private static final boolean DEBUG = false;
    private boolean registrationDone = false;
    private static final String LEGACY_XSD_STRING = "xsd:string";

    public Object newRoot(Object root, UnmarshallingContext nav, String nsURI, String localName, Attributes attrs) {
        if ("producer-configuration".equals(localName)) {
            ProducerConfigurationImpl producerConfiguration = new ProducerConfigurationImpl();
            producerConfiguration.setUsingStrictMode(this.getBooleanAttributeValue(attrs, "useStrictMode", true));
            return producerConfiguration;
        }
        throw new IllegalArgumentException("The processed file doesn't seem to have the proper format, was expecting producer-configuration, instead got " + localName);
    }

    public Object newChild(ProducerConfigurationImpl producerConfiguration, UnmarshallingContext nav, String nsURI, String localName, Attributes attrs) {
        if (REGISTRATION_CONFIG.equals(localName)) {
            if (this.registrationDone) {
                throw new IllegalArgumentException("Only one registration-configuration element can be defined!");
            }
            ProducerRegistrationRequirementsImpl registrationRequirements = new ProducerRegistrationRequirementsImpl();
            registrationRequirements.setRegistrationRequired(true);
            registrationRequirements.setRegistrationRequiredForFullDescription(this.getBooleanAttributeValue(attrs, "fullServiceDescriptionRequiresRegistration", false));
            this.registrationDone = true;
            return registrationRequirements;
        }
        return null;
    }

    public Object completeRoot(Object root, UnmarshallingContext nav, String nsURI, String localName) {
        return root;
    }

    public Object newChild(ProducerRegistrationRequirementsImpl regReq, UnmarshallingContext nav, String nsURI, String localName, Attributes attrs) {
        if ("registration-property-description".equals(localName)) {
            return new RegistrationPropertyDescription();
        }
        return null;
    }

    public void setValue(ProducerRegistrationRequirementsImpl regReq, UnmarshallingContext nav, String nsURI, String localName, String value) {
        if ("registration-policy".equals(localName)) {
            value = StringPropertyReplacer.replaceProperties((String)value);
            regReq.setPolicyClassName(value);
        } else if ("registration-property-validator".equals(localName)) {
            value = StringPropertyReplacer.replaceProperties((String)value);
            regReq.setValidatorClassName(value);
        }
    }

    public void setValue(RegistrationPropertyDescription desc, UnmarshallingContext nav, String nsURI, String localName, String value) {
        if ("name".equals(localName)) {
            value = StringPropertyReplacer.replaceProperties((String)value);
            desc.setName(new QName(value));
        } else if ("type".equals(localName)) {
            QName type;
            if (!LEGACY_XSD_STRING.equals(value = StringPropertyReplacer.replaceProperties((String)value)) && !WSRPConstants.XSD_STRING.equals(type = nav.resolveQName(value))) {
                throw new IllegalArgumentException("'" + value + "' is not a supported type. Currently, only 'xsd:string' is supported.");
            }
            desc.setType(WSRPConstants.XSD_STRING);
        }
    }

    public Object newChild(RegistrationPropertyDescription desc, UnmarshallingContext nav, String nsURI, String localName, Attributes attrs) {
        if ("hint".equals(localName) || "label".equals(localName) || "description".equals(localName)) {
            String lang = attrs.getValue("xml:lang");
            ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)lang, (String)"xml:lang", (String)localName);
            Locale locale = WSRPUtils.getLocale((String)lang);
            String resourceName = attrs.getValue("resourceName");
            LocalizedString string = new LocalizedString();
            string.setLocale(locale);
            if (resourceName != null && resourceName.length() > 0) {
                string.setResourceName(resourceName);
            }
            return string;
        }
        return null;
    }

    public void setValue(LocalizedString string, UnmarshallingContext nav, String nsURI, String localName, String value) {
        value = StringPropertyReplacer.replaceProperties((String)value);
        string.setValue(value);
    }

    public void addChild(ProducerConfigurationImpl conf, ProducerRegistrationRequirementsImpl regReq, UnmarshallingContext nav, String nsURI, String localName) {
        if (!"org.gatein.registration.policies.DefaultRegistrationPolicy".equals(regReq.getPolicyClassName()) && regReq.getValidatorClassName() != null) {
            throw new IllegalStateException("Doesn't make sense to define a property validator without using DefaultRegistrationPolicy!");
        }
        conf.setRegistrationRequirements(regReq);
    }

    public void addChild(ProducerRegistrationRequirementsImpl regReq, RegistrationPropertyDescription desc, UnmarshallingContext nav, String nsURI, String localName) {
        regReq.addRegistrationProperty(desc);
    }

    public void addChild(RegistrationPropertyDescription desc, LocalizedString string, UnmarshallingContext nav, String nsURI, String localName) {
        if ("hint".equals(localName)) {
            desc.setHint(string);
        } else if ("label".equals(localName)) {
            desc.setLabel(string);
        } else if ("description".equals(localName)) {
            desc.setDescription(string);
        }
    }

    private boolean getBooleanAttributeValue(Attributes attrs, String attributeName, boolean defaultValue) {
        String value = attrs.getValue(attributeName);
        String defaultString = "false";
        String other = "true";
        if (defaultValue) {
            defaultString = "true";
            other = "false";
        }
        if (other.equals(value)) {
            return !defaultValue;
        }
        if (value == null || defaultString.equals(value)) {
            return defaultValue;
        }
        throw new IllegalArgumentException("Invalid value for " + attributeName + " attribute. Acceptable values are: true, false.");
    }
}

