/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.management.jmx.impl;

import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;
import javax.management.modelmbean.InvalidTargetObjectTypeException;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.RequiredModelMBean;
import org.exoplatform.management.ManagementAware;
import org.exoplatform.management.jmx.annotations.NamingContext;
import org.exoplatform.management.jmx.impl.MBeanScopingData;
import org.exoplatform.management.jmx.impl.PropertiesInfo;
import org.exoplatform.management.spi.ManagedResource;

public class ExoModelMBean
extends RequiredModelMBean {
    private Object mr;
    private final ManagedResource context;

    public ExoModelMBean(ManagedResource context, Object mr, ModelMBeanInfo mbi) throws MBeanException, RuntimeOperationsException, InstanceNotFoundException, InvalidTargetObjectTypeException {
        super(mbi);
        this.context = context;
        this.mr = mr;
        this.setManagedResource(mr, "ObjectReference");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(String opName, Object[] opArgs, String[] sig) throws MBeanException, ReflectionException {
        this.context.beforeInvoke(this.mr);
        try {
            Object object = super.invoke(opName, opArgs, sig);
            return object;
        }
        finally {
            this.context.afterInvoke(this.mr);
        }
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        name = super.preRegister(server, name);
        if (this.mr instanceof MBeanRegistration) {
            ((MBeanRegistration)this.mr).preRegister(server, name);
        }
        return name;
    }

    public void postRegister(Boolean registrationDone) {
        super.postRegister(registrationDone);
        PropertiesInfo info = PropertiesInfo.resolve(this.mr.getClass(), NamingContext.class);
        MBeanScopingData scopingData = info != null ? info.resolve(this.mr) : new MBeanScopingData();
        this.context.setScopingData(MBeanScopingData.class, scopingData);
        if (this.mr instanceof MBeanRegistration) {
            ((MBeanRegistration)this.mr).postRegister(registrationDone);
        }
    }

    public void preDeregister() throws Exception {
        if (this.mr instanceof MBeanRegistration) {
            ((MBeanRegistration)this.mr).preDeregister();
        }
        if (this.mr instanceof ManagementAware) {
            ((ManagementAware)this.mr).setContext(null);
        }
        super.preDeregister();
    }

    public void postDeregister() {
        if (this.mr instanceof MBeanRegistration) {
            ((MBeanRegistration)this.mr).postDeregister();
        }
        super.postDeregister();
    }
}

