/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.payload;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Marshaller;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import org.gatein.common.util.ParameterValidation;
import org.gatein.wsrp.WSRPTypeFactory;
import org.gatein.wsrp.payload.SerializableNamedStringArray;
import org.gatein.wsrp.payload.SerializablePayload;
import org.gatein.wsrp.payload.SerializableSimplePayload;
import org.gatein.wsrp.payload.XSDTypeConverter;
import org.oasis.wsrp.v2.Event;
import org.oasis.wsrp.v2.EventPayload;
import org.oasis.wsrp.v2.NamedStringArray;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PayloadUtils {
    private static final Map<String, XSDTypeConverter> typeToConverters;
    private static final Map<Class, XSDTypeConverter> classToConverters;

    public static Serializable getPayloadAsSerializable(Event event) {
        EventPayload payload = event.getPayload();
        if (payload == null) {
            return null;
        }
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)event, (String)"Payload expected type");
        Object any = payload.getAny();
        if (any == null) {
            NamedStringArray namedStringArray = payload.getNamedStringArray();
            if (namedStringArray != null) {
                return new SerializableNamedStringArray(namedStringArray);
            }
            return null;
        }
        Element element = (Element)any;
        QName type = event.getType();
        if (type != null) {
            String typeName = type.getLocalPart();
            if ("http://www.w3.org/2001/XMLSchema".equals(type.getNamespaceURI())) {
                XSDTypeConverter converter = typeToConverters.get(typeName);
                if (converter == null) {
                    throw new IllegalArgumentException("Don't know how to deal with standard type: " + type);
                }
                return new SerializableSimplePayload(element, converter.parseFromXML(element.getTextContent()), converter);
            }
        }
        return new SerializablePayload(element);
    }

    public static EventPayload getPayloadAsEventPayload(Event eventNeedingType, Serializable payload) {
        if (payload instanceof SerializableNamedStringArray) {
            SerializableNamedStringArray stringArray = (SerializableNamedStringArray)payload;
            return WSRPTypeFactory.createEventPayloadAsNamedString(stringArray.toNamedStringArray());
        }
        if (payload instanceof SerializablePayload) {
            if (payload instanceof SerializableSimplePayload) {
                eventNeedingType.setType(((SerializableSimplePayload)payload).getConverter().getXSDType());
            }
            return WSRPTypeFactory.createEventPayloadAsAny(((SerializablePayload)payload).getElement());
        }
        Class<?> payloadClass = payload.getClass();
        XSDTypeConverter converter = classToConverters.get(payloadClass);
        if (converter != null) {
            eventNeedingType.setType(converter.getXSDType());
        }
        QName name = eventNeedingType.getName();
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{payloadClass});
            Marshaller marshaller = context.createMarshaller();
            JAXBElement element = new JAXBElement(name, payloadClass, (Object)payload);
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            builderFactory.setNamespaceAware(true);
            Document document = builderFactory.newDocumentBuilder().newDocument();
            marshaller.marshal((Object)element, (Node)document);
            return WSRPTypeFactory.createEventPayloadAsAny(document.getDocumentElement());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Couldn't marshall payload " + payload, e);
        }
    }

    static {
        XSDTypeConverter[] converterArray;
        typeToConverters = new HashMap<String, XSDTypeConverter>(19);
        classToConverters = new HashMap<Class, XSDTypeConverter>(19);
        for (XSDTypeConverter converter : converterArray = XSDTypeConverter.values()) {
            typeToConverters.put(converter.typeName(), converter);
            Class javaType = converter.getJavaType();
            if (javaType == null) continue;
            classToConverters.put(javaType, converter);
        }
    }
}

