/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast.tree;

import antlr.SemanticException;
import antlr.collections.AST;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.TypeMismatchException;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.hql.ast.tree.BinaryOperatorNode;
import org.hibernate.hql.ast.tree.ExpectedTypeAwareNode;
import org.hibernate.hql.ast.tree.HqlSqlWalkerNode;
import org.hibernate.hql.ast.tree.Node;
import org.hibernate.hql.ast.tree.ParameterNode;
import org.hibernate.hql.ast.tree.SqlFragment;
import org.hibernate.hql.ast.tree.SqlNode;
import org.hibernate.param.ParameterSpecification;
import org.hibernate.type.Type;
import org.hibernate.util.StringHelper;

public class BinaryLogicOperatorNode
extends HqlSqlWalkerNode
implements BinaryOperatorNode {
    public void initialize() throws SemanticException {
        Node lhs = this.getLeftHandOperand();
        if (lhs == null) {
            throw new SemanticException("left-hand operand of a binary operator was null");
        }
        Node rhs = this.getRightHandOperand();
        if (rhs == null) {
            throw new SemanticException("right-hand operand of a binary operator was null");
        }
        Type lhsType = this.extractDataType(lhs);
        Type rhsType = this.extractDataType(rhs);
        if (lhsType == null) {
            lhsType = rhsType;
        }
        if (rhsType == null) {
            rhsType = lhsType;
        }
        if (ExpectedTypeAwareNode.class.isAssignableFrom(((Object)((Object)lhs)).getClass())) {
            ((ExpectedTypeAwareNode)((Object)lhs)).setExpectedType(rhsType);
        }
        if (ExpectedTypeAwareNode.class.isAssignableFrom(((Object)((Object)rhs)).getClass())) {
            ((ExpectedTypeAwareNode)((Object)rhs)).setExpectedType(lhsType);
        }
        this.mutateRowValueConstructorSyntaxesIfNecessary(lhsType, rhsType);
    }

    protected final void mutateRowValueConstructorSyntaxesIfNecessary(Type lhsType, Type rhsType) {
        SessionFactoryImplementor sessionFactory = this.getSessionFactoryHelper().getFactory();
        if (lhsType != null && rhsType != null) {
            int lhsColumnSpan = lhsType.getColumnSpan(sessionFactory);
            if (lhsColumnSpan != rhsType.getColumnSpan(sessionFactory)) {
                throw new TypeMismatchException("left and right hand sides of a binary logic operator were incompatibile [" + lhsType.getName() + " : " + rhsType.getName() + "]");
            }
            if (lhsColumnSpan > 1 && !sessionFactory.getDialect().supportsRowValueConstructorSyntax()) {
                this.mutateRowValueConstructorSyntax(lhsColumnSpan);
            }
        }
    }

    private void mutateRowValueConstructorSyntax(int valueElements) {
        ParameterSpecification lhsEmbeddedCompositeParameterSpecification;
        int comparisonType = this.getType();
        String comparisonText = this.getText();
        this.setType(6);
        this.setText("AND");
        String[] lhsElementTexts = BinaryLogicOperatorNode.extractMutationTexts(this.getLeftHandOperand(), valueElements);
        String[] rhsElementTexts = BinaryLogicOperatorNode.extractMutationTexts(this.getRightHandOperand(), valueElements);
        ParameterSpecification parameterSpecification = this.getLeftHandOperand() == null || !ParameterNode.class.isInstance((Object)this.getLeftHandOperand()) ? null : (lhsEmbeddedCompositeParameterSpecification = ((ParameterNode)this.getLeftHandOperand()).getHqlParameterSpecification());
        ParameterSpecification rhsEmbeddedCompositeParameterSpecification = this.getRightHandOperand() == null || !ParameterNode.class.isInstance((Object)this.getRightHandOperand()) ? null : ((ParameterNode)this.getRightHandOperand()).getHqlParameterSpecification();
        BinaryLogicOperatorNode container = this;
        for (int i = valueElements - 1; i > 0; --i) {
            if (i == 1) {
                AST op1 = this.getASTFactory().create(comparisonType, comparisonText);
                AST lhs1 = this.getASTFactory().create(136, lhsElementTexts[0]);
                AST rhs1 = this.getASTFactory().create(136, rhsElementTexts[0]);
                op1.setFirstChild(lhs1);
                lhs1.setNextSibling(rhs1);
                container.setFirstChild(op1);
                AST op2 = this.getASTFactory().create(comparisonType, comparisonText);
                AST lhs2 = this.getASTFactory().create(136, lhsElementTexts[1]);
                AST rhs2 = this.getASTFactory().create(136, rhsElementTexts[1]);
                op2.setFirstChild(lhs2);
                lhs2.setNextSibling(rhs2);
                op1.setNextSibling(op2);
                SqlFragment fragment = (SqlFragment)lhs1;
                if (lhsEmbeddedCompositeParameterSpecification != null) {
                    fragment.addEmbeddedParameter(lhsEmbeddedCompositeParameterSpecification);
                }
                if (rhsEmbeddedCompositeParameterSpecification == null) continue;
                fragment.addEmbeddedParameter(rhsEmbeddedCompositeParameterSpecification);
                continue;
            }
            AST op = this.getASTFactory().create(comparisonType, comparisonText);
            AST lhs = this.getASTFactory().create(136, lhsElementTexts[i]);
            AST rhs = this.getASTFactory().create(136, rhsElementTexts[i]);
            op.setFirstChild(lhs);
            lhs.setNextSibling(rhs);
            AST newContainer = this.getASTFactory().create(6, "AND");
            container.setFirstChild(newContainer);
            newContainer.setNextSibling(op);
            container = newContainer;
        }
    }

    private static String[] extractMutationTexts(Node operand, int count) {
        if (operand instanceof ParameterNode) {
            String[] rtn = new String[count];
            for (int i = 0; i < count; ++i) {
                rtn[i] = "?";
            }
            return rtn;
        }
        if (operand.getType() == 89) {
            String[] rtn = new String[operand.getNumberOfChildren()];
            int x = 0;
            for (AST node = operand.getFirstChild(); node != null; node = node.getNextSibling()) {
                rtn[x++] = node.getText();
            }
            return rtn;
        }
        if (operand instanceof SqlNode) {
            String[] splits;
            String nodeText = operand.getText();
            if (nodeText.startsWith("(")) {
                nodeText = nodeText.substring(1);
            }
            if (nodeText.endsWith(")")) {
                nodeText = nodeText.substring(0, nodeText.length() - 1);
            }
            if (count != (splits = StringHelper.split(", ", nodeText)).length) {
                throw new HibernateException("SqlNode's text did not reference expected number of columns");
            }
            return splits;
        }
        throw new HibernateException("dont know how to extract row value elements from node : " + (Object)((Object)operand));
    }

    protected Type extractDataType(Node operand) {
        Type type = null;
        if (operand instanceof SqlNode) {
            type = ((SqlNode)operand).getDataType();
        }
        if (type == null && operand instanceof ExpectedTypeAwareNode) {
            type = ((ExpectedTypeAwareNode)((Object)operand)).getExpectedType();
        }
        return type;
    }

    public Type getDataType() {
        return Hibernate.BOOLEAN;
    }

    public Node getLeftHandOperand() {
        return (Node)this.getFirstChild();
    }

    public Node getRightHandOperand() {
        return (Node)this.getFirstChild().getNextSibling();
    }
}

