/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jgroups.Address;
import org.jgroups.stack.IpAddress;
import org.jgroups.util.FIFOMessageQueue;
import org.jgroups.util.Util;

public class FIFOMessageQueueTest
extends TestCase {
    FIFOMessageQueue<String, Integer> queue;
    String s1 = "s1";
    String s2 = "s2";
    String s3 = "s3";
    private static final Address a1 = new IpAddress(5000);
    private static final Address a2 = new IpAddress(6000);

    public void setUp() throws Exception {
        super.setUp();
        this.queue = new FIFOMessageQueue();
    }

    public void tearDown() throws Exception {
        super.tearDown();
    }

    public void testPollFromEmptyQueue() throws InterruptedException {
        FIFOMessageQueueTest.assertEquals((int)0, (int)this.queue.size());
        Integer ret = this.queue.poll(5L);
        FIFOMessageQueueTest.assertNull((Object)ret);
        FIFOMessageQueueTest.assertEquals((String)("queue.size() should be 0, but is " + this.queue.size()), (int)0, (int)this.queue.size());
    }

    public void testPutTwoTakeTwo() throws InterruptedException {
        this.queue.put(a1, this.s1, 1);
        this.queue.put(a1, this.s1, 2);
        Integer ret = this.queue.poll(5L);
        FIFOMessageQueueTest.assertNotNull((Object)ret);
        this.queue.done(a1, this.s1);
        this.queue.done(a1, this.s1);
        ret = this.queue.poll(5L);
        FIFOMessageQueueTest.assertNotNull((Object)ret);
        FIFOMessageQueueTest.assertEquals((int)0, (int)this.queue.size());
        this.queue.put(a1, this.s1, 3);
        FIFOMessageQueueTest.assertEquals((int)1, (int)this.queue.size());
        ret = this.queue.poll(5L);
        FIFOMessageQueueTest.assertNotNull((Object)ret);
    }

    public void testTakeFollowedByPut() throws InterruptedException {
        FIFOMessageQueueTest.assertEquals((int)0, (int)this.queue.size());
        new Thread(){

            @Override
            public void run() {
                Util.sleep(1000L);
                try {
                    FIFOMessageQueueTest.this.queue.put(a1, FIFOMessageQueueTest.this.s1, 1);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }.start();
        Integer ret = this.queue.take();
        FIFOMessageQueueTest.assertNotNull((Object)ret);
        FIFOMessageQueueTest.assertEquals((int)1, (int)ret);
        FIFOMessageQueueTest.assertEquals((String)("queue.size() should be 0, but is " + this.queue.size()), (int)0, (int)this.queue.size());
    }

    public void testMultipleTakersOnePutter() throws Exception {
        int i;
        final CyclicBarrier barrier = new CyclicBarrier(11);
        for (i = 0; i < 10; ++i) {
            new Thread(){

                @Override
                public void run() {
                    try {
                        barrier.await();
                        FIFOMessageQueueTest.this.queue.take();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }.start();
        }
        barrier.await();
        for (i = 0; i < 10; ++i) {
            this.queue.put(a1, this.s1, i);
            this.queue.done(a1, this.s1);
        }
        Util.sleep(100L);
        FIFOMessageQueueTest.assertEquals((int)0, (int)this.queue.size());
    }

    public void testConcurrentPutsAndTakes() throws InterruptedException {
        int NUM = 10000;
        int print = 1000;
        Thread putter = new Thread(){

            @Override
            public void run() {
                this.setName("Putter");
                int cnt = 0;
                for (int i = 0; i < 10000; ++i) {
                    try {
                        FIFOMessageQueueTest.this.queue.put(a1, FIFOMessageQueueTest.this.s1, i);
                        if (++cnt % 1000 == 0) {
                            System.out.println("Putter: " + cnt);
                        }
                        FIFOMessageQueueTest.this.queue.done(a1, FIFOMessageQueueTest.this.s1);
                        continue;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        };
        Thread taker = new Thread(){

            @Override
            public void run() {
                this.setName("Taker");
                int cnt = 0;
                for (int i = 0; i < 10000; ++i) {
                    try {
                        FIFOMessageQueueTest.this.queue.take();
                        if (++cnt % 1000 != 0) continue;
                        System.out.println("Taker: " + cnt);
                        continue;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        };
        System.out.println("starting threads");
        taker.start();
        putter.start();
        new Thread(){

            @Override
            public void run() {
                Util.sleep(3000L);
                System.out.println("queue:\n" + FIFOMessageQueueTest.this.queue);
            }
        }.start();
        putter.join();
        taker.join();
        FIFOMessageQueueTest.assertEquals((int)0, (int)this.queue.size());
    }

    public void testNullAddress() throws InterruptedException {
        this.queue.put(null, this.s1, 1);
        this.queue.put(a1, this.s1, 2);
        this.queue.put(a1, this.s1, 3);
        this.queue.put(null, this.s1, 4);
        System.out.println("queue:\n" + this.queue);
        Integer ret = this.queue.poll(5L);
        FIFOMessageQueueTest.assertNotNull((Object)ret);
        FIFOMessageQueueTest.assertEquals((int)1, (int)ret);
        ret = this.queue.poll(5L);
        FIFOMessageQueueTest.assertNotNull((Object)ret);
        FIFOMessageQueueTest.assertEquals((int)2, (int)ret);
        ret = this.queue.poll(5L);
        FIFOMessageQueueTest.assertNotNull((Object)ret);
        FIFOMessageQueueTest.assertEquals((int)4, (int)ret);
        ret = this.queue.poll(5L);
        FIFOMessageQueueTest.assertNull((Object)ret);
        this.queue.done(a1, this.s1);
        ret = this.queue.poll(5L);
        FIFOMessageQueueTest.assertNotNull((Object)ret);
        FIFOMessageQueueTest.assertEquals((int)3, (int)ret);
        ret = this.queue.poll(5L);
        FIFOMessageQueueTest.assertNull((Object)ret);
        FIFOMessageQueueTest.assertEquals((int)0, (int)this.queue.size());
    }

    public void testSimplePutAndTake() throws InterruptedException {
        this.queue.put(a1, this.s1, 1);
        FIFOMessageQueueTest.assertEquals((int)1, (int)this.queue.size());
        int ret = this.queue.take();
        FIFOMessageQueueTest.assertEquals((int)1, (int)ret);
        FIFOMessageQueueTest.assertEquals((int)0, (int)this.queue.size());
    }

    public void testSimplePutAndTakeMultipleSenders() throws InterruptedException {
        this.queue.put(a1, this.s1, 1);
        this.queue.put(a2, this.s1, 2);
        System.out.println("queue is:\n" + this.queue);
        FIFOMessageQueueTest.assertEquals((int)2, (int)this.queue.size());
        int ret = this.queue.take();
        FIFOMessageQueueTest.assertEquals((int)1, (int)ret);
        FIFOMessageQueueTest.assertEquals((int)1, (int)this.queue.size());
        ret = this.queue.take();
        FIFOMessageQueueTest.assertEquals((int)2, (int)ret);
        FIFOMessageQueueTest.assertEquals((int)0, (int)this.queue.size());
    }

    public void testMultiplePutsAndTakes() throws InterruptedException {
        int i;
        for (i = 1; i <= 5; ++i) {
            this.queue.put(a1, this.s1, i);
        }
        System.out.println("queue is " + this.queue);
        FIFOMessageQueueTest.assertEquals((int)5, (int)this.queue.size());
        for (i = 1; i <= 5; ++i) {
            int ret = this.queue.take();
            FIFOMessageQueueTest.assertEquals((int)i, (int)ret);
            FIFOMessageQueueTest.assertEquals((int)(5 - i), (int)this.queue.size());
            this.queue.done(a1, this.s1);
        }
        FIFOMessageQueueTest.assertEquals((int)0, (int)this.queue.size());
    }

    public void testSameSenderSameDestination() throws InterruptedException {
        this.queue.put(a1, this.s1, 1);
        this.queue.put(a1, this.s1, 2);
        this.queue.put(a1, this.s1, 3);
        System.out.println("queue:\n" + this.queue);
        FIFOMessageQueueTest.assertEquals((int)3, (int)this.queue.size());
        int ret = this.queue.take();
        FIFOMessageQueueTest.assertEquals((int)1, (int)ret);
        Integer retval = this.queue.poll(100L);
        FIFOMessageQueueTest.assertNull((Object)retval);
        this.queue.done(a1, this.s1);
        System.out.println("queue:\n" + this.queue);
        ret = this.queue.take();
        FIFOMessageQueueTest.assertEquals((int)2, (int)ret);
        this.queue.done(a1, this.s1);
        System.out.println("queue:\n" + this.queue);
        ret = this.queue.take();
        System.out.println("queue:\n" + this.queue);
        FIFOMessageQueueTest.assertEquals((int)3, (int)ret);
    }

    public void testSameSenderMultipleDestinations() throws InterruptedException {
        this.queue.put(a1, this.s1, 10);
        this.queue.put(a1, this.s1, 11);
        this.queue.put(a1, this.s1, 12);
        this.queue.put(a1, this.s2, 20);
        this.queue.put(a1, this.s2, 21);
        this.queue.put(a1, this.s2, 22);
        this.queue.put(a1, this.s3, 30);
        this.queue.put(a1, this.s3, 31);
        this.queue.put(a1, this.s3, 32);
        System.out.println("queue:\n" + this.queue);
        Integer ret = this.queue.poll(5L);
        FIFOMessageQueueTest.assertNotNull((Object)ret);
        FIFOMessageQueueTest.assertEquals((int)10, (int)ret);
        ret = this.queue.poll(5L);
        FIFOMessageQueueTest.assertNotNull((Object)ret);
        FIFOMessageQueueTest.assertEquals((int)20, (int)ret);
        ret = this.queue.poll(5L);
        FIFOMessageQueueTest.assertNotNull((Object)ret);
        FIFOMessageQueueTest.assertEquals((int)30, (int)ret);
        ret = this.queue.poll(5L);
        FIFOMessageQueueTest.assertNull((Object)ret);
        this.queue.done(a1, this.s3);
        this.queue.done(a1, this.s1);
        this.queue.done(a1, this.s2);
        ret = this.queue.poll(5L);
        FIFOMessageQueueTest.assertNotNull((Object)ret);
        FIFOMessageQueueTest.assertEquals((int)31, (int)ret);
        ret = this.queue.poll(5L);
        FIFOMessageQueueTest.assertNotNull((Object)ret);
        FIFOMessageQueueTest.assertEquals((int)11, (int)ret);
        ret = this.queue.poll(5L);
        FIFOMessageQueueTest.assertNotNull((Object)ret);
        FIFOMessageQueueTest.assertEquals((int)21, (int)ret);
        ret = this.queue.poll(5L);
        FIFOMessageQueueTest.assertNull((Object)ret);
        FIFOMessageQueueTest.assertEquals((int)3, (int)this.queue.size());
        ret = this.queue.poll(5L);
        FIFOMessageQueueTest.assertNull((Object)ret);
        this.queue.done(a1, this.s1);
        this.queue.done(a1, this.s3);
        this.queue.done(a1, this.s2);
        ret = this.queue.poll(5L);
        FIFOMessageQueueTest.assertNotNull((Object)ret);
        FIFOMessageQueueTest.assertEquals((int)12, (int)ret);
        ret = this.queue.poll(5L);
        FIFOMessageQueueTest.assertNotNull((Object)ret);
        FIFOMessageQueueTest.assertEquals((int)32, (int)ret);
        ret = this.queue.poll(5L);
        FIFOMessageQueueTest.assertNotNull((Object)ret);
        FIFOMessageQueueTest.assertEquals((int)22, (int)ret);
        ret = this.queue.poll(5L);
        FIFOMessageQueueTest.assertNull((Object)ret);
        FIFOMessageQueueTest.assertEquals((int)0, (int)this.queue.size());
    }

    public void testDifferentSendersSameDestination() throws InterruptedException {
        this.queue.put(a1, this.s1, 10);
        this.queue.put(a2, this.s1, 20);
        this.queue.put(a1, this.s1, 11);
        this.queue.put(a2, this.s1, 21);
        System.out.println("queue:\n" + this.queue);
        FIFOMessageQueueTest.assertEquals((int)4, (int)this.queue.size());
        Integer ret = this.queue.poll(5L);
        FIFOMessageQueueTest.assertNotNull((Object)ret);
        FIFOMessageQueueTest.assertEquals((int)10, (int)ret);
        ret = this.queue.poll(5L);
        FIFOMessageQueueTest.assertNotNull((Object)ret);
        FIFOMessageQueueTest.assertEquals((int)20, (int)ret);
        this.queue.done(a1, this.s1);
        ret = this.queue.poll(5L);
        FIFOMessageQueueTest.assertNotNull((Object)ret);
        FIFOMessageQueueTest.assertEquals((int)11, (int)ret);
        this.queue.done(a2, this.s1);
        ret = this.queue.poll(5L);
        FIFOMessageQueueTest.assertNotNull((Object)ret);
        FIFOMessageQueueTest.assertEquals((int)21, (int)ret);
        ret = this.queue.poll(5L);
        FIFOMessageQueueTest.assertNull((Object)ret);
        FIFOMessageQueueTest.assertEquals((int)0, (int)this.queue.size());
    }

    public void testDifferentSendersDifferentDestinations() throws Exception {
        this.queue.put(a1, this.s1, 1);
        this.queue.put(a2, this.s2, 2);
        this.queue.put(a1, this.s2, 3);
        this.queue.put(a2, this.s1, 4);
        System.out.println("queue:\n" + this.queue);
        FIFOMessageQueueTest.assertEquals((int)4, (int)this.queue.size());
        Integer ret = this.queue.poll(5L);
        FIFOMessageQueueTest.assertNotNull((Object)ret);
        FIFOMessageQueueTest.assertEquals((int)1, (int)ret);
        ret = this.queue.poll(5L);
        FIFOMessageQueueTest.assertNotNull((Object)ret);
        FIFOMessageQueueTest.assertEquals((int)2, (int)ret);
        ret = this.queue.poll(5L);
        FIFOMessageQueueTest.assertNotNull((Object)ret);
        FIFOMessageQueueTest.assertEquals((int)3, (int)ret);
        ret = this.queue.poll(5L);
        FIFOMessageQueueTest.assertNotNull((Object)ret);
        FIFOMessageQueueTest.assertEquals((int)4, (int)ret);
        ret = this.queue.poll(5L);
        FIFOMessageQueueTest.assertNull((Object)ret);
        FIFOMessageQueueTest.assertEquals((int)0, (int)this.queue.size());
    }

    public void testDifferentSendersDifferentDestinationsMultipleMessages() throws Exception {
        this.queue.put(a1, this.s1, 1);
        this.queue.put(a2, this.s2, 2);
        this.queue.put(a1, this.s2, 3);
        this.queue.put(a2, this.s1, 4);
        this.queue.put(a1, this.s1, 5);
        this.queue.put(a2, this.s2, 6);
        this.queue.put(a1, this.s2, 7);
        this.queue.put(a2, this.s1, 8);
        System.out.println("queue:\n" + this.queue);
        FIFOMessageQueueTest.assertEquals((int)8, (int)this.queue.size());
        Integer ret = this.queue.poll(5L);
        FIFOMessageQueueTest.assertNotNull((Object)ret);
        FIFOMessageQueueTest.assertEquals((int)1, (int)ret);
        ret = this.queue.poll(5L);
        FIFOMessageQueueTest.assertNotNull((Object)ret);
        FIFOMessageQueueTest.assertEquals((int)2, (int)ret);
        ret = this.queue.poll(5L);
        FIFOMessageQueueTest.assertNotNull((Object)ret);
        FIFOMessageQueueTest.assertEquals((int)3, (int)ret);
        ret = this.queue.poll(5L);
        FIFOMessageQueueTest.assertNotNull((Object)ret);
        FIFOMessageQueueTest.assertEquals((int)4, (int)ret);
        this.queue.done(a1, this.s1);
        ret = this.queue.poll(5L);
        FIFOMessageQueueTest.assertNotNull((Object)ret);
        FIFOMessageQueueTest.assertEquals((int)5, (int)ret);
        this.queue.done(a2, this.s2);
        ret = this.queue.poll(5L);
        FIFOMessageQueueTest.assertNotNull((Object)ret);
        FIFOMessageQueueTest.assertEquals((int)6, (int)ret);
        this.queue.done(a1, this.s2);
        ret = this.queue.poll(5L);
        FIFOMessageQueueTest.assertNotNull((Object)ret);
        FIFOMessageQueueTest.assertEquals((int)7, (int)ret);
        this.queue.done(a2, this.s1);
        ret = this.queue.poll(5L);
        FIFOMessageQueueTest.assertNotNull((Object)ret);
        FIFOMessageQueueTest.assertEquals((int)8, (int)ret);
    }

    public void testOrdering() throws InterruptedException {
        for (int i = 1; i <= 3; ++i) {
            this.queue.put(a1, this.s1, i);
        }
        FIFOMessageQueueTest.assertEquals((int)3, (int)this.queue.size());
        int ret = this.queue.take();
        FIFOMessageQueueTest.assertEquals((int)1, (int)ret);
        FIFOMessageQueueTest.assertEquals((int)2, (int)this.queue.size());
        this.queue.done(a1, this.s1);
        this.queue.put(a1, this.s1, 4);
        this.queue.put(a1, this.s1, 5);
        System.out.println("queue: " + this.queue);
        for (int i = 2; i <= 5; ++i) {
            ret = this.queue.take();
            FIFOMessageQueueTest.assertEquals((int)i, (int)ret);
            FIFOMessageQueueTest.assertEquals((int)(5 - i), (int)this.queue.size());
            this.queue.done(a1, this.s1);
        }
        FIFOMessageQueueTest.assertEquals((int)0, (int)this.queue.size());
    }

    public void testOrderingMultipleThreads() throws BrokenBarrierException, InterruptedException {
        CyclicBarrier barrier = new CyclicBarrier(4);
        int NUM = 500;
        Producer p1 = new Producer(this.queue, "s1", 1, NUM, barrier);
        Producer p2 = new Producer(this.queue, "s2", 1001, NUM, barrier);
        Producer p3 = new Producer(this.queue, "s3", 2001, NUM, barrier);
        p1.start();
        p2.start();
        p3.start();
        Util.sleep(100L);
        barrier.await();
        p1.join();
        p2.join();
        p3.join();
        System.out.println("queue: " + this.queue.size() + " elements");
        FIFOMessageQueueTest.assertEquals((int)(NUM * 3), (int)this.queue.size());
    }

    public void testOrderingMultipleThreadsWithTakes() throws BrokenBarrierException, InterruptedException {
        this.testOrderingMultipleThreads();
        LinkedList<Integer> list = new LinkedList<Integer>();
        int size = this.queue.size();
        for (int i = 0; i < size; ++i) {
            int ret = this.queue.take();
            list.add(ret);
            this.queue.done(a1, "s1");
            this.queue.done(a1, "s2");
            this.queue.done(a1, "s3");
        }
        System.out.println("analyzing returned values for correct ordering");
        LinkedList<Integer> one = new LinkedList<Integer>();
        LinkedList<Integer> two = new LinkedList<Integer>();
        LinkedList<Integer> three = new LinkedList<Integer>();
        Iterator i$ = list.iterator();
        while (i$.hasNext()) {
            int val = (Integer)i$.next();
            if (val < 1000) {
                one.add(val);
                continue;
            }
            if (val > 1000 && val <= 2000) {
                two.add(val);
                continue;
            }
            if (val <= 2000) continue;
            three.add(val);
        }
        int len = one.size();
        FIFOMessageQueueTest.assertEquals((int)len, (int)two.size());
        FIFOMessageQueueTest.assertEquals((int)len, (int)three.size());
        LinkedList sorted_one = new LinkedList(one);
        Collections.sort(sorted_one);
        FIFOMessageQueueTest.assertEquals((String)("one: " + one + ", sorted: " + sorted_one), one, sorted_one);
        LinkedList sorted_two = new LinkedList(two);
        Collections.sort(sorted_two);
        FIFOMessageQueueTest.assertEquals((String)("two: " + two + ", sorted: " + sorted_two), two, sorted_two);
        LinkedList sorted_three = new LinkedList(three);
        Collections.sort(sorted_three);
        FIFOMessageQueueTest.assertEquals((String)("three: " + three + ", sorted: " + sorted_three), three, sorted_three);
        System.out.println("OK - all 3 collections are ordered");
    }

    public static Test suite() {
        return new TestSuite(FIFOMessageQueueTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)FIFOMessageQueueTest.suite());
    }

    private static class Producer
    extends Thread {
        private FIFOMessageQueue<String, Integer> queue;
        private String key;
        private int num_msgs;
        private CyclicBarrier barrier;
        private int start_num;

        private Producer(FIFOMessageQueue<String, Integer> queue, String key, int start_num, int num_msgs, CyclicBarrier barrier) {
            this.queue = queue;
            this.key = key;
            this.start_num = start_num;
            this.num_msgs = num_msgs;
            this.barrier = barrier;
        }

        @Override
        public void run() {
            try {
                this.barrier.await();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            for (int i = this.start_num; i <= this.num_msgs + this.start_num - 1; ++i) {
                try {
                    this.queue.put(a1, this.key, i);
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

