/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.ancillary.opt;

import com.google.caja.ancillary.opt.Symbol;
import com.google.caja.parser.AncestorChain;
import com.google.caja.parser.js.scope.AbstractScope;
import com.google.caja.parser.js.scope.ScopeType;
import com.google.caja.util.Maps;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class OptScope
implements AbstractScope {
    final OptScope containing;
    final ScopeType t;
    final Map<String, Symbol> symbols = Maps.newLinkedHashMap();
    final AncestorChain<?> root;
    int earliestNonLocalXfer = Integer.MAX_VALUE;

    OptScope(OptScope containing, ScopeType t, AncestorChain<?> root) {
        this.containing = containing;
        this.t = t;
        this.root = root;
    }

    @Override
    public AbstractScope getContainingScope() {
        return this.containing;
    }

    @Override
    public ScopeType getType() {
        return this.t;
    }

    @Override
    public boolean isSymbolDeclared(String name) {
        return this.symbols.containsKey(name);
    }

    public Symbol getSymbol(String name) {
        OptScope os = this;
        do {
            Symbol s;
            if ((s = this.symbols.get(name)) == null) continue;
            return s;
        } while ((os = os.containing) != null);
        return null;
    }

    public Symbol requireSymbol(String name) {
        Symbol s = this.symbols.get(name);
        if (s == null) {
            s = new Symbol();
            this.symbols.put(name, s);
        }
        return s;
    }
}

