/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import org.gatein.common.util.ParameterValidation;
import org.gatein.wsrp.spec.v1.WSRP1ExceptionFactory;
import org.gatein.wsrp.spec.v2.WSRP2ExceptionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WSRPExceptionFactory {
    protected static final Logger log = LoggerFactory.getLogger(WSRPExceptionFactory.class);
    protected static final Map<Class<? extends Exception>, ExceptionFactory<? extends Exception>> exceptionClassToFactory = new HashMap<Class<? extends Exception>, ExceptionFactory<? extends Exception>>(33);

    protected abstract void loadExceptionFactories();

    protected WSRPExceptionFactory() {
    }

    public static <E extends Exception> E throwWSException(Class<E> exceptionClass, String message, Throwable cause) throws E {
        throw WSRPExceptionFactory.createWSException(exceptionClass, message, cause);
    }

    public static <E extends Exception> E createWSException(Class<E> exceptionClass, String message, Throwable cause) {
        ExceptionFactory<? extends Exception> exceptionFactory = exceptionClassToFactory.get(exceptionClass);
        if (exceptionFactory == null) {
            throw new IllegalArgumentException("Unknown exception class: " + exceptionClass);
        }
        return (E)exceptionFactory.newInstance(message, cause);
    }

    static {
        WSRP1ExceptionFactory.getInstance().loadExceptionFactories();
        WSRP2ExceptionFactory.getInstance().loadExceptionFactories();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static abstract class ExceptionFactory<E extends Exception> {
        private static final String CAUSE = " Cause: ";
        private final Constructor<E> exceptionConstructor;
        protected Object fault;
        private static final String FAULT = "Fault";

        public ExceptionFactory(Class<E> exceptionClass) throws NoSuchMethodException, IllegalAccessException, InstantiationException, ClassNotFoundException {
            String faultClassName = exceptionClass.getName() + FAULT;
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(faultClassName);
            this.exceptionConstructor = exceptionClass.getConstructor(String.class, this.initFaultAndGetClass(clazz), Throwable.class);
        }

        protected abstract Class initFaultAndGetClass(Class var1) throws IllegalAccessException, InstantiationException;

        public E newInstance(String message, Throwable cause) {
            try {
                String causeMsg;
                if (cause != null && !ParameterValidation.isNullOrEmpty((String)(causeMsg = cause.getLocalizedMessage())) && !message.contains(CAUSE)) {
                    message = message + CAUSE + causeMsg;
                }
                return (E)((Exception)this.exceptionConstructor.newInstance(message, this.fault, cause));
            }
            catch (Exception e) {
                log.debug("Couldn't instantiate Exception associated with " + this.fault.getClass().getSimpleName() + ", message: " + message + ", cause: " + cause);
                return null;
            }
        }
    }
}

