/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.registration.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.gatein.common.util.ParameterValidation;
import org.gatein.registration.Registration;
import org.gatein.registration.RegistrationStatus;
import org.gatein.registration.spi.ConsumerSPI;
import org.gatein.registration.spi.RegistrationSPI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegistrationImpl
implements RegistrationSPI {
    private final String key;
    private ConsumerSPI consumer;
    private RegistrationStatus status;
    private Map<QName, Object> properties;
    private String registrationHandle;
    private List<String> portletHandles;

    RegistrationImpl(String key, ConsumerSPI consumer, RegistrationStatus status, Map<QName, Object> properties) {
        this.key = key;
        this.consumer = consumer;
        this.status = status;
        this.properties = new HashMap<QName, Object>(properties);
        this.portletHandles = new ArrayList<String>();
    }

    @Override
    public String getPersistentKey() {
        return this.key;
    }

    @Override
    public void setRegistrationHandle(String handle) {
        this.registrationHandle = handle;
    }

    @Override
    public String getRegistrationHandle() {
        return this.registrationHandle;
    }

    @Override
    public ConsumerSPI getConsumer() {
        return this.consumer;
    }

    @Override
    public Map<QName, Object> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    @Override
    public void setPropertyValueFor(QName propertyName, Object value) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)propertyName, (String)"Property name");
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)value, (String)"Property value");
        Object oldValue = this.properties.get(propertyName);
        if (!value.equals(oldValue)) {
            this.properties.put(propertyName, value);
        }
    }

    @Override
    public void setPropertyValueFor(String propertyName, Object value) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)propertyName, (String)"Property name");
        this.setPropertyValueFor(new QName(propertyName), value);
    }

    @Override
    public Object getPropertyValueFor(QName propertyName) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)propertyName, (String)"Property name");
        return this.properties.get(propertyName);
    }

    @Override
    public Object getPropertyValueFor(String propertyName) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)propertyName, (String)"Property name");
        return this.getPropertyValueFor(new QName(propertyName));
    }

    @Override
    public void removeProperty(QName propertyName) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)propertyName, (String)"Property name");
        this.properties.remove(propertyName);
    }

    @Override
    public void removeProperty(String propertyName) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)propertyName, (String)"Property name");
        this.removeProperty(new QName(propertyName));
    }

    @Override
    public boolean hasEqualProperties(Registration registration) {
        if (registration == null) {
            return false;
        }
        Map<QName, Object> other = registration.getProperties();
        return this.hasEqualProperties(other);
    }

    @Override
    public boolean hasEqualProperties(Map registrationProperties) {
        if (registrationProperties == null) {
            return false;
        }
        if (this.properties.size() != registrationProperties.size()) {
            return false;
        }
        for (Map.Entry<QName, Object> entry : this.properties.entrySet()) {
            QName name = entry.getKey();
            if (entry.getValue().equals(registrationProperties.get(name))) continue;
            return false;
        }
        return true;
    }

    public void setRegistrationPropertyValueFor(String propertyName, Object value) {
        this.setPropertyValueFor(new QName(propertyName), value);
    }

    @Override
    public RegistrationStatus getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(RegistrationStatus status) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)status, (String)"RegistrationStatus");
        this.status = status;
    }

    @Override
    public void clearAssociatedState() {
    }

    @Override
    public void updateProperties(Map registrationProperties) {
        this.properties = new HashMap<QName, Object>(registrationProperties);
    }

    @Override
    public List<String> getPortletHandles() {
        return this.portletHandles;
    }
}

