/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.utils;

import eu.medsea.mimeutil.MimeUtil;
import java.io.IOException;
import java.io.InputStream;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class MimeTypeResolver {
    protected static Log log = ExoLogger.getLogger("org.exoplatform.commons.utils.MimeTypeResolver");
    private Map<String, List<String>> mimeTypes = new HashMap<String, List<String>>();
    private Map<String, List<String>> extentions = new HashMap<String, List<String>>();
    private String defaultMimeType = "application/octet-stream";

    public MimeTypeResolver() {
        try {
            SecurityHelper.doPrivilegedIOExceptionAction(new PrivilegedExceptionAction<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void run() throws Exception {
                    InputStream stream;
                    Scanner scanner = null;
                    String mimeTypeProperties = System.getProperty("org.exoplatform.mimetypes");
                    if (mimeTypeProperties != null && (stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(mimeTypeProperties)) != null) {
                        scanner = new Scanner(stream, "ISO-8859-1");
                    }
                    if (scanner == null) {
                        scanner = new Scanner(this.getClass().getResourceAsStream("mimetypes.properties"), "ISO-8859-1");
                    }
                    try {
                        while (scanner.hasNextLine()) {
                            MimeTypeResolver.this.processLine(scanner.nextLine());
                        }
                    }
                    finally {
                        scanner.close();
                    }
                    return null;
                }
            });
        }
        catch (IOException e) {
            throw new InternalError("Unable to load mimetypes: " + e.toString());
        }
    }

    public String getDefaultMimeType() {
        return this.defaultMimeType;
    }

    public void setDefaultMimeType(String defaultMimeType) {
        this.defaultMimeType = defaultMimeType;
    }

    public String getMimeType(String filename) {
        List<String> values;
        String ext = filename.substring(filename.lastIndexOf(".") + 1);
        if (ext.isEmpty()) {
            ext = filename;
        }
        return (values = this.mimeTypes.get(ext)) == null ? this.defaultMimeType : values.get(0);
    }

    public String getMimeType(String fileName, InputStream is) {
        Collection mimeTypes;
        String mimeType = this.getMimeType(fileName);
        if (mimeType == this.defaultMimeType && !(mimeTypes = MimeUtil.getMimeTypes((InputStream)is)).isEmpty()) {
            mimeType = mimeTypes.toArray()[0].toString();
        }
        return mimeType;
    }

    public String getExtension(String mimeType) {
        if (mimeType.isEmpty() || mimeType.equals(this.defaultMimeType)) {
            return "";
        }
        List<String> values = this.extentions.get(mimeType);
        if (values == null) {
            return "";
        }
        String resultExt = "";
        for (String ext : values) {
            if (mimeType.endsWith(ext)) {
                return ext;
            }
            if (!resultExt.isEmpty()) continue;
            resultExt = ext;
        }
        return resultExt;
    }

    protected void processLine(String aLine) {
        int p = aLine.indexOf("=");
        String ext = aLine.substring(0, p);
        String mimetype = aLine.substring(p + 1);
        List<String> values = this.mimeTypes.get(ext);
        if (values == null) {
            values = new ArrayList<String>();
            this.mimeTypes.put(ext, values);
        }
        values.add(mimetype);
        values = this.extentions.get(mimetype);
        if (values == null) {
            values = new ArrayList<String>();
            this.extentions.put(mimetype, values);
        }
        values.add(ext);
    }

    static {
        SecurityHelper.doPrivilegedAction(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                MimeUtil.registerMimeDetector((String)"eu.medsea.mimeutil.detector.MagicMimeMimeDetector");
                return null;
            }
        });
    }
}

