/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.jdbc;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.services.database.DAO;
import org.exoplatform.services.database.DBObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDBCListAccess<E>
implements ListAccess<E> {
    protected DAO dao;
    protected String findQuery;
    protected String countQuery;

    public JDBCListAccess(DAO dao, String findQuery, String countQuery) {
        this.dao = dao;
        this.findQuery = findQuery;
        this.countQuery = countQuery;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSize() throws Exception {
        Connection connection = null;
        try {
            connection = this.dao.getExoDatasource().getConnection();
            Object retObj = this.dao.loadDBField(this.countQuery);
            if (retObj instanceof Integer) {
                int n = (Integer)retObj;
                return n;
            }
            if (retObj instanceof BigDecimal) {
                int n = ((BigDecimal)retObj).intValue();
                return n;
            }
            int n = ((Long)retObj).intValue();
            return n;
        }
        finally {
            this.dao.getExoDatasource().closeConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E[] load(int index, int length) throws Exception, IllegalArgumentException {
        Statement statement = null;
        ResultSet resultSet = null;
        Connection connection = this.dao.getExoDatasource().getConnection();
        try {
            if (index < 0) {
                throw new IllegalArgumentException("Illegal index: index must be a positive number");
            }
            if (length < 0) {
                throw new IllegalArgumentException("Illegal length: length must be a positive number");
            }
            ArrayList<DBObject> entities = new ArrayList<DBObject>(length);
            statement = connection.createStatement(1004, 1007);
            resultSet = statement.executeQuery(this.findQuery);
            int p = 0;
            int counter = 0;
            while (counter < length) {
                if (!resultSet.next()) {
                    throw new IllegalArgumentException("Illegal index or length: sum of the index and the length cannot be greater than the list size");
                }
                resultSet.next();
                DBObject bean = this.dao.createInstance();
                this.dao.getDBObjectMapper().mapResultSet(resultSet, bean);
                if (p >= index) {
                    entities.add(bean);
                    ++counter;
                }
                ++p;
            }
            Object[] objectArray = entities.toArray();
            return objectArray;
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (statement != null) {
                statement.close();
            }
            this.dao.getExoDatasource().closeConnection(connection);
        }
    }
}

