/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.lexer.escaping;

import com.google.caja.SomethingWidgyHappenedError;
import com.google.caja.lexer.escaping.Encoder;
import com.google.caja.lexer.escaping.Escape;
import com.google.caja.lexer.escaping.EscapeMap;
import com.google.caja.lexer.escaping.Escaper;
import com.google.caja.util.Lists;
import com.google.caja.util.SparseBitSet;
import java.io.IOException;
import java.util.List;

public class Escaping {
    private static final EscapeMap JSON_ESCAPES;
    private static final EscapeMap STRING_MINIMAL_ESCAPES;
    private static final EscapeMap STRING_EMBEDDABLE_ESCAPES;
    private static final EscapeMap REGEX_MINIMAL_ESCAPES;
    private static final EscapeMap REGEX_EMBEDDABLE_ESCAPES;
    private static final EscapeMap EMPTY_ESCAPES;
    private static final EscapeMap REGEX_LITERAL_ESCAPES;
    private static final EscapeMap REGEX_LITERAL_EMBEDDABLE_ESCAPES;
    private static final EscapeMap XML_ESCAPES;
    private static final SparseBitSet CSS_IDENT_ESCAPES;
    private static final SparseBitSet CSS_STR_ESCAPES;
    private static final SparseBitSet ALLOW_NON_ASCII;
    private static final SparseBitSet NO_NON_ASCII;
    private static final SparseBitSet PROBLEMATIC_XML;
    static final EscapeMap URI_ESCAPES;
    static final Encoder JS_ENCODER;
    static final Encoder HEX4_ENCODER;
    static final Encoder XML_ENCODER;
    static final Encoder CSS_ENCODER;

    public static void escapeJsString(CharSequence s, boolean asciiOnly, boolean embeddable, Appendable out) throws IOException {
        new Escaper(s, embeddable ? STRING_EMBEDDABLE_ESCAPES : STRING_MINIMAL_ESCAPES, asciiOnly ? NO_NON_ASCII : ALLOW_NON_ASCII, JS_ENCODER, out).escape();
    }

    public static void escapeJsString(CharSequence s, boolean asciiOnly, boolean embeddable, StringBuilder out) {
        try {
            Escaping.escapeJsString(s, asciiOnly, embeddable, (Appendable)out);
        }
        catch (IOException ex) {
            throw new SomethingWidgyHappenedError("StringBuilders don't throw IOException", (Throwable)ex);
        }
    }

    public static void escapeJsonString(CharSequence s, boolean asciiOnly, Appendable out) throws IOException {
        new Escaper(s, JSON_ESCAPES, asciiOnly ? NO_NON_ASCII : ALLOW_NON_ASCII, JS_ENCODER, out).escape();
    }

    public static void escapeJsonString(CharSequence s, boolean asciiOnly, StringBuilder out) {
        try {
            Escaping.escapeJsonString(s, asciiOnly, (Appendable)out);
        }
        catch (IOException ex) {
            throw new SomethingWidgyHappenedError("StringBuilders don't throw IOException", (Throwable)ex);
        }
    }

    public static void escapeJsIdentifier(CharSequence s, boolean asciiOnly, Appendable out) throws IOException {
        new Escaper(s, STRING_MINIMAL_ESCAPES, asciiOnly ? NO_NON_ASCII : ALLOW_NON_ASCII, HEX4_ENCODER, out).escape();
    }

    public static void escapeJsIdentifier(CharSequence s, boolean asciiOnly, StringBuilder out) {
        try {
            Escaping.escapeJsIdentifier(s, asciiOnly, (Appendable)out);
        }
        catch (IOException ex) {
            throw new SomethingWidgyHappenedError("StringBuilders don't throw IOException", (Throwable)ex);
        }
    }

    public static void escapeRegex(CharSequence s, boolean asciiOnly, boolean embeddable, Appendable out) throws IOException {
        new Escaper(s, embeddable ? REGEX_LITERAL_EMBEDDABLE_ESCAPES : REGEX_LITERAL_ESCAPES, asciiOnly ? NO_NON_ASCII : ALLOW_NON_ASCII, JS_ENCODER, out).escape();
    }

    public static void escapeRegex(CharSequence s, boolean asciiOnly, boolean embeddable, StringBuilder out) {
        try {
            Escaping.escapeRegex(s, asciiOnly, embeddable, (Appendable)out);
        }
        catch (IOException ex) {
            throw new SomethingWidgyHappenedError("StringBuilders don't throw IOException", (Throwable)ex);
        }
    }

    public static void normalizeRegex(CharSequence s, boolean asciiOnly, boolean embeddable, Appendable out) throws IOException {
        new Escaper(Escaping.requireEndUnescaped(Escaping.rebalance(s, '[', ']')), embeddable ? REGEX_EMBEDDABLE_ESCAPES : REGEX_MINIMAL_ESCAPES, asciiOnly ? NO_NON_ASCII : ALLOW_NON_ASCII, JS_ENCODER, out).normalize();
    }

    public static void normalizeRegex(CharSequence s, boolean asciiOnly, boolean embeddable, StringBuilder out) {
        try {
            Escaping.normalizeRegex(s, asciiOnly, embeddable, (Appendable)out);
        }
        catch (IOException ex) {
            throw new SomethingWidgyHappenedError("StringBuilders don't throw IOException", (Throwable)ex);
        }
    }

    public static void escapeXml(CharSequence s, boolean asciiOnly, Appendable out) throws IOException {
        new Escaper(s, XML_ESCAPES, asciiOnly ? NO_NON_ASCII : PROBLEMATIC_XML, XML_ENCODER, out).escape();
    }

    public static void escapeXml(CharSequence s, boolean asciiOnly, StringBuilder out) {
        try {
            Escaping.escapeXml(s, asciiOnly, (Appendable)out);
        }
        catch (IOException ex) {
            throw new SomethingWidgyHappenedError("StringBuilders don't throw IOException", (Throwable)ex);
        }
    }

    public static void escapeCssString(CharSequence s, Appendable out) throws IOException {
        new Escaper(s, EMPTY_ESCAPES, CSS_STR_ESCAPES, CSS_ENCODER, out).escape();
    }

    public static void escapeCssString(CharSequence s, StringBuilder out) {
        try {
            Escaping.escapeCssString(s, (Appendable)out);
        }
        catch (IOException ex) {
            throw new SomethingWidgyHappenedError("StringBuilders don't throw IOException", (Throwable)ex);
        }
    }

    public static void escapeCssIdent(CharSequence s, Appendable out) throws IOException {
        if (s.length() == 0) {
            return;
        }
        char ch0 = s.charAt(0);
        if (ch0 >= '0' && ch0 <= '9') {
            CSS_ENCODER.encode(ch0, s.length() > 1 ? Character.codePointAt(s, 1) : -1, out);
            s = s.subSequence(1, s.length());
        }
        new Escaper(s, EMPTY_ESCAPES, CSS_IDENT_ESCAPES, CSS_ENCODER, out).escape();
    }

    public static void escapeCssIdent(CharSequence s, StringBuilder out) {
        try {
            Escaping.escapeCssIdent(s, (Appendable)out);
        }
        catch (IOException ex) {
            throw new SomethingWidgyHappenedError("StringBuilders don't throw IOException", (Throwable)ex);
        }
    }

    public static void escapeUri(CharSequence s, StringBuilder out) {
        Escaping.escapeUri(s, 0, out);
    }

    static void escapeUri(CharSequence s, int i, StringBuilder out) {
        try {
            Escaping.escapeUri(s, i, (Appendable)out);
        }
        catch (IOException ex) {
            throw new SomethingWidgyHappenedError("StringBuilders don't throw IOException", (Throwable)ex);
        }
    }

    public static void escapeUri(CharSequence s, Appendable out) throws IOException {
        Escaping.escapeUri(s, 0, out);
    }

    private static void escapeUri(CharSequence s, int i, Appendable out) throws IOException {
        int pos = 0;
        int n = s.length();
        while (i < n) {
            char ch = s.charAt(i);
            if (ch >= '\u0080' || URI_ESCAPES.getEscape(ch) != null) {
                out.append(s, pos, i);
                Escaping.pctEncode(ch, out);
                pos = i + 1;
            }
            ++i;
        }
        out.append(s, pos, n);
    }

    static void hex2Escape(char ch, Appendable out) throws IOException {
        out.append("\\x").append("0123456789abcdef".charAt(ch >> 4 & 0xF)).append("0123456789abcdef".charAt(ch & 0xF));
    }

    static void unicodeEscape(char ch, Appendable out) throws IOException {
        out.append("\\u").append("0123456789abcdef".charAt(ch >> 12 & 0xF)).append("0123456789abcdef".charAt(ch >> 8 & 0xF)).append("0123456789abcdef".charAt(ch >> 4 & 0xF)).append("0123456789abcdef".charAt(ch & 0xF));
    }

    static void hexEscape(char ch, Appendable out) throws IOException {
        out.append("\\");
        if (ch < '\u0100') {
            if (ch >= '\u0010') {
                out.append("0123456789ABCDEF".charAt(ch >> 4 & 0xF));
            }
            out.append("0123456789ABCDEF".charAt(ch & 0xF));
        } else {
            if (ch >= '\u1000') {
                out.append("0123456789ABCDEF".charAt(ch >> 12 & 0xF));
            }
            out.append("0123456789ABCDEF".charAt(ch >> 8 & 0xF)).append("0123456789ABCDEF".charAt(ch >> 4 & 0xF)).append("0123456789ABCDEF".charAt(ch & 0xF));
        }
    }

    static void pctEncode(char ch, Appendable out) throws IOException {
        if (ch < '\u0080') {
            Escaping.pctEncode((byte)ch, out);
        } else {
            if (ch < '\u0800') {
                Escaping.pctEncode((byte)(0xC0 | ch >>> 6 & 0x1F), out);
            } else {
                Escaping.pctEncode((byte)(0xE0 | ch >>> 12 & 0xF), out);
                Escaping.pctEncode((byte)(0x80 | ch >>> 6 & 0x3F), out);
            }
            Escaping.pctEncode((byte)(0x80 | ch & 0x3F), out);
        }
    }

    static void pctEncode(byte b, Appendable out) throws IOException {
        out.append('%').append("0123456789abcdef".charAt(b >> 4 & 0xF)).append("0123456789abcdef".charAt(b & 0xF));
    }

    private static Escape[] hex2Escapes(char min, char max) {
        Escape[] out = new Escape[max - min + 1];
        for (int i = 0; i < out.length; ++i) {
            StringBuilder sb = new StringBuilder(4);
            char ch = (char)(min + i);
            try {
                Escaping.hex2Escape(ch, sb);
            }
            catch (IOException ex) {
                throw new SomethingWidgyHappenedError("StringBuilders don't throw IOException", (Throwable)ex);
            }
            out[i] = new Escape(ch, sb.toString());
        }
        return out;
    }

    private static Escape[] simpleEscapes(char[] chars) {
        Escape[] out = new Escape[chars.length];
        for (int i = 0; i < out.length; ++i) {
            out[i] = new Escape(chars[i], "\\" + chars[i]);
        }
        return out;
    }

    private static CharSequence rebalance(CharSequence s, char open, char close) {
        int n = s.length();
        if (n == 0) {
            return s;
        }
        StringBuilder sb = null;
        int pos = 0;
        int lOpen = -1;
        int lOpenInSb = -1;
        if (s.charAt(0) == '*' || s.charAt(0) == '/') {
            sb = new StringBuilder();
            sb.append('\\');
        }
        for (int i = 0; i < n; ++i) {
            char ch = s.charAt(i);
            if (ch == '\\') {
                ++i;
                continue;
            }
            if (ch == open) {
                if (lOpen == -1) {
                    lOpen = i;
                    lOpenInSb = -1;
                    continue;
                }
                if (sb == null) {
                    sb = new StringBuilder();
                }
                if (lOpenInSb == -1) {
                    lOpenInSb = lOpen + sb.length() - pos;
                }
                sb.append(s, pos, i).append('\\');
                pos = i;
                continue;
            }
            if (ch != close) continue;
            lOpen = -1;
        }
        if (lOpen != -1) {
            if (sb == null) {
                sb = new StringBuilder();
            }
            if (lOpenInSb != -1) {
                sb.insert(lOpenInSb, '\\');
            } else {
                sb.append(s, pos, lOpen);
                sb.append('\\');
                pos = lOpen;
            }
        } else if (sb == null) {
            return s;
        }
        sb.append(s, pos, n);
        return sb.toString();
    }

    private static CharSequence requireEndUnescaped(CharSequence s) {
        int nBackslashes;
        int n = s.length();
        for (nBackslashes = 0; nBackslashes < n && '\\' == s.charAt(n - nBackslashes - 1); ++nBackslashes) {
        }
        if ((nBackslashes & 1) == 1) {
            return s + "\\";
        }
        return s;
    }

    private Escaping() {
    }

    static {
        int i;
        JSON_ESCAPES = new EscapeMap(new Escape('\u0000', "\\u0000"), new Escape('\b', "\\b"), new Escape('\r', "\\r"), new Escape('\f', "\\f"), new Escape('\n', "\\n"), new Escape('\t', "\\t"), new Escape('\\', "\\\\"), new Escape('\'', "\\u0027"), new Escape('\"', "\\\""));
        STRING_MINIMAL_ESCAPES = new EscapeMap(new Escape('\u0000', "\\x00"), new Escape('\b', "\\b"), new Escape('\r', "\\r"), new Escape('\n', "\\n"), new Escape('\\', "\\\\"), new Escape('\'', "\\'"), new Escape('\"', "\\\""));
        STRING_EMBEDDABLE_ESCAPES = new EscapeMap(new Escape('\b', "\\b"), new Escape('\t', "\\t"), new Escape('\n', "\\n"), new Escape('\f', "\\f"), new Escape('\r', "\\r"), new Escape('\\', "\\\\"), new Escape('\'', "\\'"), new Escape('\"', "\\\""), new Escape('&', "\\x26"), new Escape('<', "\\x3c"), new Escape('>', "\\x3e")).plus(Escaping.hex2Escapes('\u0000', '\u001f'));
        REGEX_MINIMAL_ESCAPES = new EscapeMap(new Escape('\u0000', "\\x00"), new Escape('\b', "\\b"), new Escape('\r', "\\r"), new Escape('\n', "\\n"), new Escape('/', "\\/"));
        REGEX_EMBEDDABLE_ESCAPES = new EscapeMap(new Escape('\b', "\\b"), new Escape('\t', "\\t"), new Escape('\n', "\\n"), new Escape('\f', "\\f"), new Escape('\r', "\\r"), new Escape('&', "\\x26"), new Escape('/', "\\/"), new Escape('<', "\\x3c"), new Escape('>', "\\x3e")).plus(Escaping.hex2Escapes('\u0000', '\u001f'));
        EMPTY_ESCAPES = new EscapeMap(new Escape[0]);
        REGEX_LITERAL_ESCAPES = REGEX_MINIMAL_ESCAPES.plus(Escaping.simpleEscapes("()[]{}*+?.^$|\\".toCharArray()));
        REGEX_LITERAL_EMBEDDABLE_ESCAPES = REGEX_EMBEDDABLE_ESCAPES.plus(Escaping.simpleEscapes("()[]{}*+?.^$|\\".toCharArray()));
        List<Escape> escapes = Lists.newArrayList();
        block5: for (i = 0; i < 32; ++i) {
            switch (i) {
                case 9: 
                case 10: 
                case 13: {
                    continue block5;
                }
                default: {
                    escapes.add(new Escape((char)i, "&#" + i + ";"));
                }
            }
        }
        escapes.add(new Escape('&', "&amp;"));
        escapes.add(new Escape('<', "&lt;"));
        escapes.add(new Escape('>', "&gt;"));
        escapes.add(new Escape('\"', "&#34;"));
        escapes.add(new Escape('\'', "&#39;"));
        escapes.add(new Escape('`', "&#96;"));
        escapes.add(new Escape('\u007f', "&#x7f;"));
        XML_ESCAPES = new EscapeMap(escapes.toArray(new Escape[escapes.size()]));
        CSS_IDENT_ESCAPES = SparseBitSet.withRanges(0, 45, 46, 48, 58, 65, 91, 95, 96, 97, 123, 0x110000);
        CSS_STR_ESCAPES = SparseBitSet.withRanges(0, 32, 34, 35, 39, 45, 59, 61, 62, 63, 64, 65, 91, 94, 123, 126, 127, 0x110000);
        ALLOW_NON_ASCII = SparseBitSet.withRanges(173, 174, 1536, 1540, 1757, 1758, 1807, 1808, 6068, 6070, 8203, 8208, 8232, 8239, 8288, 8304, 64976, 65008, 65279, 65280, 65520, 65532, 65534, 65536, 119155, 119163, 917505, 917506, 917536, 917632);
        NO_NON_ASCII = SparseBitSet.withRanges(127, 0x110000);
        PROBLEMATIC_XML = SparseBitSet.withRanges(127, 133, 134, 160, 55296, 57344, 64976, 64992, 65534, 65535, 131070, 131072, 196606, 196608, 262142, 262144, 327678, 327680, 393214, 393216, 458750, 458752, 524286, 524288, 589822, 589824, 655358, 655360, 720894, 720896, 786430, 786432, 851966, 851968, 917502, 917504, 983038, 983040, 1048574, 0x100000, 1114110, 0x110000);
        escapes = Lists.newArrayList();
        for (i = 0; i < 128; ++i) {
            if (i == 45 || i == 46 || i == 95 || i == 126 || i >= 48 && i <= 57 || i >= 65 && i <= 90 || i >= 97 && i <= 122) continue;
            StringBuilder sb = new StringBuilder(3);
            try {
                Escaping.pctEncode((byte)i, (Appendable)sb);
            }
            catch (IOException ex) {
                throw new SomethingWidgyHappenedError("StringBuilders shouldn't throw IOException", (Throwable)ex);
            }
            escapes.add(new Escape((char)i, sb.toString()));
        }
        URI_ESCAPES = new EscapeMap(escapes.toArray(new Escape[escapes.size()]));
        JS_ENCODER = new Encoder(){

            public void encode(int codepoint, int nextCodepoint, Appendable out) throws IOException {
                if (!Character.isSupplementaryCodePoint(codepoint)) {
                    if (codepoint < 256) {
                        Escaping.hex2Escape((char)codepoint, out);
                    } else {
                        Escaping.unicodeEscape((char)codepoint, out);
                    }
                } else {
                    for (char surrogate : Character.toChars(codepoint)) {
                        Escaping.unicodeEscape(surrogate, out);
                    }
                }
            }
        };
        HEX4_ENCODER = new Encoder(){

            public void encode(int codepoint, int nextCodepoint, Appendable out) throws IOException {
                if (!Character.isSupplementaryCodePoint(codepoint)) {
                    Escaping.unicodeEscape((char)codepoint, out);
                } else {
                    for (char surrogate : Character.toChars(codepoint)) {
                        Escaping.unicodeEscape(surrogate, out);
                    }
                }
            }
        };
        XML_ENCODER = new Encoder(){

            public void encode(int codepoint, int nextCodepoint, Appendable out) throws IOException {
                out.append("&#").append(Integer.toString(codepoint)).append(";");
            }
        };
        CSS_ENCODER = new Encoder(){

            public void encode(int codepoint, int nextCodepoint, Appendable out) throws IOException {
                if (!Character.isSupplementaryCodePoint(codepoint)) {
                    Escaping.hexEscape((char)codepoint, out);
                } else {
                    for (char surrogate : Character.toChars(codepoint)) {
                        Escaping.hexEscape(surrogate, out);
                    }
                }
                if (nextCodepoint >= 48 && nextCodepoint <= 57 || nextCodepoint >= 97 && nextCodepoint <= 102 || nextCodepoint >= 65 && nextCodepoint <= 70 || nextCodepoint == 9 || nextCodepoint == 10 || nextCodepoint == 12 || nextCodepoint == 13 || nextCodepoint == 32 || nextCodepoint == -1) {
                    out.append(' ');
                }
            }
        };
    }
}

