/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.util;

import com.google.caja.util.Maps;
import com.google.caja.util.Multimap;
import com.google.caja.util.Multimaps;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import junit.framework.TestCase;

public class CollectionsTest
extends TestCase {
    public final void testListMultimaps() {
        Multimap<String, String> m = Multimaps.newListHashMultimap();
        CollectionsTest.assertTrue((boolean)m.isEmpty());
        CollectionsTest.assertEquals((String)"[]", (String)m.keySet().toString());
        CollectionsTest.assertEquals((String)"[]", (String)m.get("foo").toString());
        m.put("foo", "bar");
        CollectionsTest.assertEquals((String)"[foo]", (String)m.keySet().toString());
        CollectionsTest.assertEquals((String)"[bar]", (String)m.get("foo").toString());
        CollectionsTest.assertFalse((boolean)m.isEmpty());
        m.put("foo", "bar");
        CollectionsTest.assertEquals((String)"[foo]", (String)m.keySet().toString());
        CollectionsTest.assertEquals((String)"[bar, bar]", (String)m.get("foo").toString());
        CollectionsTest.assertFalse((boolean)m.isEmpty());
        m.remove("foo", "bar");
        CollectionsTest.assertEquals((String)"[foo]", (String)m.keySet().toString());
        CollectionsTest.assertEquals((String)"[bar]", (String)m.get("foo").toString());
        CollectionsTest.assertFalse((boolean)m.isEmpty());
        m.remove("foo", "bar");
        CollectionsTest.assertEquals((String)"[]", (String)m.keySet().toString());
        CollectionsTest.assertEquals((String)"[]", (String)m.get("foo").toString());
        CollectionsTest.assertTrue((boolean)m.isEmpty());
        m.putAll("baz", Arrays.asList("boo", "far", "boo", "bob"));
        CollectionsTest.assertEquals((String)"[baz]", (String)m.keySet().toString());
        CollectionsTest.assertEquals((String)"[boo, far, boo, bob]", (String)m.get("baz").toString());
        CollectionsTest.assertFalse((boolean)m.isEmpty());
        m.removeAll("baz", Arrays.asList("bar", "boo", "far"));
        CollectionsTest.assertEquals((String)"[baz]", (String)m.keySet().toString());
        CollectionsTest.assertEquals((String)"[bob]", (String)m.get("baz").toString());
        CollectionsTest.assertFalse((boolean)m.isEmpty());
        m.removeAll("baz", Arrays.asList("bar", "bob"));
        CollectionsTest.assertEquals((String)"[]", (String)m.keySet().toString());
        CollectionsTest.assertEquals((String)"[]", (String)m.get("baz").toString());
        CollectionsTest.assertTrue((boolean)m.isEmpty());
    }

    public final void testSetMultimaps() {
        Multimap<String, String> m = Multimaps.newSetHashMultimap();
        CollectionsTest.assertTrue((boolean)m.isEmpty());
        CollectionsTest.assertEquals((String)"[]", (String)m.keySet().toString());
        CollectionsTest.assertEquals((String)"[]", (String)m.get("foo").toString());
        m.put("foo", "bar");
        CollectionsTest.assertEquals((String)"[foo]", (String)m.keySet().toString());
        CollectionsTest.assertEquals((String)"[bar]", (String)m.get("foo").toString());
        CollectionsTest.assertFalse((boolean)m.isEmpty());
        m.put("foo", "bar");
        CollectionsTest.assertEquals((String)"[foo]", (String)m.keySet().toString());
        CollectionsTest.assertEquals((String)"[bar]", (String)m.get("foo").toString());
        CollectionsTest.assertFalse((boolean)m.isEmpty());
        m.remove("foo", "bar");
        CollectionsTest.assertEquals((String)"[]", (String)m.keySet().toString());
        CollectionsTest.assertEquals((String)"[]", (String)m.get("foo").toString());
        CollectionsTest.assertTrue((boolean)m.isEmpty());
        m.putAll("baz", Arrays.asList("boo", "far", "boo", "bob"));
        CollectionsTest.assertEquals((String)"[baz]", (String)m.keySet().toString());
        CollectionsTest.assertEquals((String)"[boo, far, bob]", (String)m.get("baz").toString());
        CollectionsTest.assertFalse((boolean)m.isEmpty());
        m.removeAll("baz", Arrays.asList("bar", "boo", "far"));
        CollectionsTest.assertEquals((String)"[baz]", (String)m.keySet().toString());
        CollectionsTest.assertEquals((String)"[bob]", (String)m.get("baz").toString());
        CollectionsTest.assertFalse((boolean)m.isEmpty());
        m.removeAll("baz", Arrays.asList("bar", "bob"));
        CollectionsTest.assertEquals((String)"[]", (String)m.keySet().toString());
        CollectionsTest.assertEquals((String)"[]", (String)m.get("baz").toString());
        CollectionsTest.assertTrue((boolean)m.isEmpty());
    }

    public final void testPetulantCollection() {
        Multimaps.MultimapImpl<String, String, Collection<String>> m = new Multimaps.MultimapImpl<String, String, Collection<String>>(new Multimaps.Maker<Map<String, Collection<String>>>(){

            @Override
            public Map<String, Collection<String>> newInstance() {
                return Maps.newHashMap();
            }
        }, new Multimaps.Maker<Collection<String>>(){

            @Override
            public Collection<String> newInstance() {
                return new PetulantCollection();
            }
        });
        CollectionsTest.assertTrue((boolean)m.isEmpty());
        CollectionsTest.assertEquals((String)"[]", (String)m.keySet().toString());
        CollectionsTest.assertEquals((String)"[]", (String)m.get("foo").toString());
        m.put("foo", "bar");
        CollectionsTest.assertEquals((String)"[]", (String)m.keySet().toString());
        CollectionsTest.assertEquals((String)"[]", (String)m.get("foo").toString());
        CollectionsTest.assertTrue((boolean)m.isEmpty());
        m.put("foo", "bar");
        CollectionsTest.assertEquals((String)"[]", (String)m.keySet().toString());
        CollectionsTest.assertEquals((String)"[]", (String)m.get("foo").toString());
        CollectionsTest.assertTrue((boolean)m.isEmpty());
        m.remove("foo", "bar");
        CollectionsTest.assertEquals((String)"[]", (String)m.keySet().toString());
        CollectionsTest.assertEquals((String)"[]", (String)m.get("foo").toString());
        CollectionsTest.assertTrue((boolean)m.isEmpty());
        m.remove("foo", "bar");
        CollectionsTest.assertEquals((String)"[]", (String)m.keySet().toString());
        CollectionsTest.assertEquals((String)"[]", (String)m.get("foo").toString());
        CollectionsTest.assertTrue((boolean)m.isEmpty());
        m.putAll("baz", Arrays.asList("boo", "far"));
        CollectionsTest.assertEquals((String)"[]", (String)m.keySet().toString());
        CollectionsTest.assertEquals((String)"[]", (String)m.get("foo").toString());
        CollectionsTest.assertTrue((boolean)m.isEmpty());
        m.removeAll("baz", Arrays.asList("bar", "boo", "far"));
        CollectionsTest.assertEquals((String)"[]", (String)m.keySet().toString());
        CollectionsTest.assertEquals((String)"[]", (String)m.get("foo").toString());
        CollectionsTest.assertTrue((boolean)m.isEmpty());
    }

    public final void testClone() {
        Multimap<String, String> m = Multimaps.newListLinkedHashMultimap();
        m.put("a", "A");
        m.put("b", "B");
        m.put("b", "BEE");
        m.put("d", "D");
        Multimap<String, String> m2 = m.clone();
        m2.put("a", "AYE");
        m2.put("c", "C");
        m2.remove("b", "BEE");
        CollectionsTest.assertEquals((String)"[A]", (String)m.get("a").toString());
        CollectionsTest.assertEquals((String)"[B, BEE]", (String)m.get("b").toString());
        CollectionsTest.assertEquals((String)"[]", (String)m.get("c").toString());
        CollectionsTest.assertEquals((String)"[D]", (String)m.get("d").toString());
        CollectionsTest.assertEquals((String)"[A, AYE]", (String)m2.get("a").toString());
        CollectionsTest.assertEquals((String)"[B]", (String)m2.get("b").toString());
        CollectionsTest.assertEquals((String)"[C]", (String)m2.get("c").toString());
        CollectionsTest.assertEquals((String)"[D]", (String)m2.get("d").toString());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PetulantCollection
    implements Collection<String> {
        private PetulantCollection() {
        }

        @Override
        public boolean add(String e) {
            return false;
        }

        @Override
        public boolean addAll(Collection<? extends String> c) {
            return false;
        }

        @Override
        public void clear() {
        }

        @Override
        public boolean contains(Object o) {
            return false;
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return false;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public Iterator<String> iterator() {
            return Collections.emptyList().iterator();
        }

        @Override
        public boolean remove(Object o) {
            return false;
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return false;
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return false;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public Object[] toArray() {
            return new Object[0];
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return a;
        }
    }
}

