/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.application;

import java.io.Closeable;
import java.util.List;
import java.util.Locale;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exoplatform.commons.utils.I18N;
import org.exoplatform.commons.utils.Safe;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.application.PortalApplication;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.StaleModelException;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.ControllerContext;
import org.exoplatform.web.WebAppController;
import org.exoplatform.web.WebRequestHandler;
import org.exoplatform.web.application.Application;
import org.exoplatform.web.application.ApplicationLifecycle;
import org.exoplatform.web.application.ApplicationRequestPhaseLifecycle;
import org.exoplatform.web.application.Phase;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.web.application.RequestFailure;
import org.exoplatform.web.controller.QualifiedName;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.core.UIApplication;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortalRequestHandler
extends WebRequestHandler {
    protected static Log log = ExoLogger.getLogger((String)"portal:PortalRequestHandler");
    public static final QualifiedName REQUEST_PATH = QualifiedName.create((String)"gtn", (String)"path");
    public static final QualifiedName REQUEST_SITE_TYPE = QualifiedName.create((String)"gtn", (String)"sitetype");
    public static final QualifiedName REQUEST_SITE_NAME = QualifiedName.create((String)"gtn", (String)"sitename");
    public static final QualifiedName LANG = QualifiedName.create((String)"gtn", (String)"lang");

    public String getHandlerName() {
        return "portal";
    }

    public void onInit(WebAppController controller, ServletConfig sConfig) throws Exception {
        PortalApplication application = new PortalApplication(sConfig);
        application.onInit();
        controller.addApplication((Application)application);
    }

    public boolean execute(ControllerContext controllerContext) throws Exception {
        HttpServletRequest req = controllerContext.getRequest();
        HttpServletResponse res = controllerContext.getResponse();
        log.debug((Object)("Session ID = " + req.getSession().getId()));
        res.setHeader("Cache-Control", "no-cache");
        String requestPath = controllerContext.getParameter(REQUEST_PATH);
        String requestSiteType = controllerContext.getParameter(REQUEST_SITE_TYPE);
        String requestSiteName = controllerContext.getParameter(REQUEST_SITE_NAME);
        String lang = controllerContext.getParameter(LANG);
        Locale requestLocale = lang == null || lang.length() == 0 ? null : I18N.parseTagIdentifier((String)lang);
        if (requestSiteName == null) {
            res.sendRedirect(req.getContextPath());
            return true;
        }
        PortalApplication app = (PortalApplication)controllerContext.getController().getApplication("PortalApplication");
        PortalRequestContext context = new PortalRequestContext(app, controllerContext, requestSiteType, requestSiteName, requestPath, requestLocale);
        if (context.getUserPortalConfig() == null) {
            DataStorage storage = (DataStorage)PortalContainer.getComponent(DataStorage.class);
            PortalConfig persistentPortalConfig = storage.getPortalConfig(requestSiteType, requestSiteName);
            if (persistentPortalConfig == null) {
                return false;
            }
            if (req.getRemoteUser() == null) {
                context.requestAuthenticationLogin();
            } else {
                context.sendError(403);
            }
        } else {
            this.processRequest(context, app);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processRequest(PortalRequestContext context, PortalApplication app) throws Exception {
        WebuiRequestContext.setCurrentInstance((RequestContext)context);
        UIApplication uiApp = app.getStateManager().restoreUIRootComponent((WebuiRequestContext)context);
        List lifecycles = app.getApplicationLifecycle();
        try {
            for (ApplicationLifecycle lifecycle : lifecycles) {
                lifecycle.onStartRequest((Application)app, (RequestContext)context);
            }
            if (context.getUIApplication() != uiApp) {
                context.setUIApplication(uiApp);
            }
            if (uiApp != null) {
                uiApp.processDecode((WebuiRequestContext)context);
            }
            if (!context.isResponseComplete() && !context.getProcessRender()) {
                this.startRequestPhaseLifecycle(app, context, lifecycles, Phase.ACTION);
                uiApp.processAction((WebuiRequestContext)context);
                this.endRequestPhaseLifecycle(app, context, lifecycles, Phase.ACTION);
            }
            if (!context.isResponseComplete()) {
                this.startRequestPhaseLifecycle(app, context, lifecycles, Phase.RENDER);
                uiApp.processRender((WebuiRequestContext)context);
                this.endRequestPhaseLifecycle(app, context, lifecycles, Phase.RENDER);
            }
            if (uiApp != null) {
                uiApp.setLastAccessApplication(System.currentTimeMillis());
            }
            app.getStateManager().storeUIRootComponent((WebuiRequestContext)context);
        }
        catch (StaleModelException staleModelEx) {
            for (ApplicationLifecycle lifecycle : lifecycles) {
                lifecycle.onFailRequest((Application)app, (RequestContext)context, RequestFailure.CONCURRENCY_FAILURE);
            }
        }
        catch (Exception NonStaleModelEx) {
            log.error((Object)"Error while handling request", (Throwable)NonStaleModelEx);
        }
        finally {
            Safe.close((Closeable)context.getWriter());
            try {
                for (ApplicationLifecycle lifecycle : lifecycles) {
                    lifecycle.onEndRequest((Application)app, (RequestContext)context);
                }
            }
            catch (Exception exception) {
                log.error((Object)"Error while ending request on all ApplicationLifecycle", (Throwable)exception);
            }
            WebuiRequestContext.setCurrentInstance(null);
        }
    }

    private void startRequestPhaseLifecycle(PortalApplication app, PortalRequestContext context, List<ApplicationLifecycle> lifecycles, Phase phase) {
        for (ApplicationLifecycle lifecycle : lifecycles) {
            if (!(lifecycle instanceof ApplicationRequestPhaseLifecycle)) continue;
            ((ApplicationRequestPhaseLifecycle)lifecycle).onStartRequestPhase((Application)app, (RequestContext)context, phase);
        }
    }

    private void endRequestPhaseLifecycle(PortalApplication app, PortalRequestContext context, List<ApplicationLifecycle> lifecycles, Phase phase) {
        for (ApplicationLifecycle lifecycle : lifecycles) {
            if (!(lifecycle instanceof ApplicationRequestPhaseLifecycle)) continue;
            ((ApplicationRequestPhaseLifecycle)lifecycle).onEndRequestPhase((Application)app, (RequestContext)context, phase);
        }
    }
}

