/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.exif;

import com.drew.lang.Rational;
import com.drew.metadata.Directory;
import com.drew.metadata.MetadataException;
import com.drew.metadata.TagDescriptor;
import com.drew.metadata.exif.ExifDescriptor;
import com.drew.metadata.exif.NikonType2MakernoteDirectory;
import java.text.DecimalFormat;

public class NikonType2MakernoteDescriptor
extends TagDescriptor {
    public NikonType2MakernoteDescriptor(Directory directory) {
        super(directory);
    }

    private NikonType2MakernoteDirectory getMakernoteDirectory() {
        return (NikonType2MakernoteDirectory)this._directory;
    }

    public String getDescription(int n) throws MetadataException {
        switch (n) {
            case 132: {
                return this.getLensDescription();
            }
            case 146: {
                return this.getHueAdjustmentDescription();
            }
            case 141: {
                return this.getColorModeDescription();
            }
            case 18: {
                return this.getAutoFlashCompensationDescription();
            }
            case 2: {
                return this.getIsoSettingDescription();
            }
            case 134: {
                return this.getDigitalZoomDescription();
            }
            case 136: {
                return this.getAutoFocusPositionDescription();
            }
            case 1: {
                return this.getAutoFirmwareVersionDescription();
            }
        }
        return this._directory.getString(n);
    }

    public String getAutoFocusPositionDescription() throws MetadataException {
        if (!this._directory.containsTag(136)) {
            return null;
        }
        int[] nArray = this._directory.getIntArray(136);
        if (nArray.length != 4 || nArray[0] != 0 || nArray[2] != 0 || nArray[3] != 0) {
            return "Unknown (" + this._directory.getString(136) + ")";
        }
        switch (nArray[1]) {
            case 0: {
                return "Centre";
            }
            case 1: {
                return "Top";
            }
            case 2: {
                return "Bottom";
            }
            case 3: {
                return "Left";
            }
            case 4: {
                return "Right";
            }
        }
        return "Unknown (" + nArray[1] + ")";
    }

    public String getDigitalZoomDescription() throws MetadataException {
        if (!this._directory.containsTag(134)) {
            return null;
        }
        Rational rational = this._directory.getRational(134);
        if (rational.intValue() == 1) {
            return "No digital zoom";
        }
        return rational.toSimpleString(true) + "x digital zoom";
    }

    public String getIsoSettingDescription() throws MetadataException {
        if (!this._directory.containsTag(2)) {
            return null;
        }
        int[] nArray = this._directory.getIntArray(2);
        if (nArray[0] != 0 || nArray[1] == 0) {
            return "Unknown (" + this._directory.getString(2) + ")";
        }
        return "ISO " + nArray[1];
    }

    public String getAutoFlashCompensationDescription() throws MetadataException {
        Rational rational = this.getMakernoteDirectory().getAutoFlashCompensation();
        if (rational == null) {
            return "Unknown";
        }
        DecimalFormat decimalFormat = new DecimalFormat("0.##");
        return decimalFormat.format(rational.floatValue()) + " EV";
    }

    public String getLensDescription() throws MetadataException {
        if (!this._directory.containsTag(132)) {
            return null;
        }
        Rational[] rationalArray = this._directory.getRationalArray(132);
        if (rationalArray.length != 4) {
            return this._directory.getString(132);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(rationalArray[0].intValue());
        stringBuffer.append('-');
        stringBuffer.append(rationalArray[1].intValue());
        stringBuffer.append("mm f/");
        stringBuffer.append(rationalArray[2].floatValue());
        stringBuffer.append('-');
        stringBuffer.append(rationalArray[3].floatValue());
        return stringBuffer.toString();
    }

    public String getHueAdjustmentDescription() {
        if (!this._directory.containsTag(146)) {
            return null;
        }
        return this._directory.getString(146) + " degrees";
    }

    public String getColorModeDescription() {
        if (!this._directory.containsTag(141)) {
            return null;
        }
        String string = this._directory.getString(141);
        if (string.startsWith("MODE1")) {
            return "Mode I (sRGB)";
        }
        return string;
    }

    public String getAutoFirmwareVersionDescription() throws MetadataException {
        if (!this._directory.containsTag(1)) {
            return null;
        }
        int[] nArray = this._directory.getIntArray(1);
        return ExifDescriptor.convertBytesToVersionString(nArray);
    }
}

