/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.controller.router;

import java.io.IOException;
import java.util.BitSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.exoplatform.web.controller.QualifiedName;
import org.exoplatform.web.controller.metadata.ControllerDescriptor;
import org.exoplatform.web.controller.metadata.RouteDescriptor;
import org.exoplatform.web.controller.router.Regex;
import org.exoplatform.web.controller.router.RegexFactory;
import org.exoplatform.web.controller.router.RenderContext;
import org.exoplatform.web.controller.router.Route;
import org.exoplatform.web.controller.router.RouterConfigException;
import org.exoplatform.web.controller.router.URIWriter;
import org.exoplatform.web.url.MimeType;
import org.gatein.common.io.UndeclaredIOException;
import org.gatein.common.util.Tools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Router {
    private static final BitSet escapeSet;
    private final RegexFactory regexFactory;
    final Route root;
    final char separatorEscape;
    final char separatorEscapeNible1;
    final char separatorEscapeNible2;
    private Regex[] regexes;

    public Router(ControllerDescriptor metaData) throws RouterConfigException {
        this(metaData, RegexFactory.JAVA);
    }

    public Router(ControllerDescriptor metaData, RegexFactory regexFactory) throws RouterConfigException {
        char separtorEscape = metaData.getSeparatorEscape();
        int i = separtorEscape & 0xFFFFFF80;
        if (i > 0 || !escapeSet.get(separtorEscape)) {
            throw new RouterConfigException("Char " + separtorEscape + " cannot be used a separator escape");
        }
        String s = Integer.toString(separtorEscape, 16).toUpperCase();
        this.separatorEscapeNible1 = s.charAt(0);
        this.separatorEscapeNible2 = s.charAt(1);
        this.regexFactory = regexFactory;
        this.root = new Route(this);
        this.separatorEscape = separtorEscape;
        this.regexes = new Regex[0];
        for (RouteDescriptor routeMetaData : metaData.getRoutes()) {
            this.root.append(routeMetaData);
        }
    }

    Regex compile(String pattern) {
        for (Regex regex : this.regexes) {
            if (!regex.getPattern().equals(pattern)) continue;
            return regex;
        }
        Regex regex = this.regexFactory.compile(pattern);
        regex.index = this.regexes.length;
        this.regexes = (Regex[])Tools.appendTo((Object[])this.regexes, (Object)regex);
        return regex;
    }

    public void render(Map<QualifiedName, String> parameters, URIWriter writer) throws IOException {
        this.render(new RenderContext(parameters), writer);
    }

    public String render(Map<QualifiedName, String> parameters) {
        return this.render(new RenderContext(parameters));
    }

    public void render(RenderContext context, URIWriter writer) throws IOException {
        if (context.matchers == null) {
            context.matchers = new Regex.Matcher[this.regexes.length];
        }
        this.root.render(context, writer);
    }

    public String render(RenderContext context) {
        try {
            StringBuilder sb = new StringBuilder();
            URIWriter renderContext = new URIWriter(sb, MimeType.PLAIN);
            this.render(context, renderContext);
            return sb.toString();
        }
        catch (IOException e) {
            throw new UndeclaredIOException(e);
        }
    }

    public Map<QualifiedName, String> route(String path) throws IOException {
        return this.route(path, Collections.<String, String[]>emptyMap());
    }

    public Map<QualifiedName, String> route(String path, Map<String, String[]> queryParams) {
        Iterator<Map<QualifiedName, String>> matcher = this.matcher(path, queryParams);
        if (matcher.hasNext()) {
            return matcher.next();
        }
        return null;
    }

    public Iterator<Map<QualifiedName, String>> matcher(String path, Map<String, String[]> queryParams) {
        return this.root.route(path, queryParams);
    }

    public String toString() {
        return "Router[" + this.root.toString() + "]";
    }

    static {
        BitSet bs = new BitSet();
        bs.set(95);
        bs.set(46);
        bs.set(45);
        bs.set(126);
        bs.set(33);
        bs.set(36);
        bs.set(38);
        bs.set(43);
        bs.set(58);
        bs.set(64);
        escapeSet = bs;
    }
}

