/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.form;

import java.io.Writer;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputBase;
import org.exoplatform.webui.form.UIFormInputContainer;
import org.exoplatform.webui.form.validator.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(events={@EventConfig(listeners={AddActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={RemoveActionListener.class}, phase=Event.Phase.DECODE)})
public class UIFormMultiValueInputSet
extends UIFormInputContainer<List> {
    protected List<Validator> validators;
    private Class<? extends UIFormInputBase> clazz_;
    private Constructor constructor_ = null;
    private Object[] constructorParams_;
    protected boolean enable_ = true;
    protected boolean readonly_ = false;

    public UIFormMultiValueInputSet() throws Exception {
        super(null, null);
    }

    public UIFormMultiValueInputSet(String name, String bindingField) throws Exception {
        super(name, bindingField);
        this.setComponentConfig(this.getClass(), null);
    }

    @Override
    public Class<List> getTypeValue() {
        return List.class;
    }

    public void setType(Class<? extends UIFormInputBase> clazz) {
        this.clazz_ = clazz;
        Constructor<?>[] constructors = this.clazz_.getConstructors();
        if (constructors.length > 0) {
            this.constructor_ = constructors[0];
        }
    }

    public void setConstructorParameterTypes(Class<?> ... constructorParameterTypes) throws SecurityException, NoSuchMethodException {
        Constructor<? extends UIFormInputBase> constructor = this.clazz_.getConstructor(constructorParameterTypes);
        if (constructor != null) {
            this.constructor_ = constructor;
        }
    }

    public void setConstructorParameterValues(Object[] values) throws SecurityException, NoSuchMethodException {
        this.constructorParams_ = values;
    }

    public Class<? extends UIFormInputBase> getUIFormInputBase() {
        return this.clazz_;
    }

    @Override
    public List<?> getValue() {
        ArrayList values = new ArrayList();
        for (UIComponent child : this.getChildren()) {
            UIFormInputBase uiInput = (UIFormInputBase)child;
            if (uiInput.getValue() == null) continue;
            values.add(uiInput.getValue());
        }
        return values;
    }

    @Override
    public UIFormInput setValue(List<?> values) throws Exception {
        this.getChildren().clear();
        for (int i = 0; i < values.size(); ++i) {
            UIFormInputBase uiInput = this.createUIFormInput(i);
            uiInput.setValue(values.get(i));
        }
        return this;
    }

    public boolean isEnable() {
        return this.enable_;
    }

    public UIFormMultiValueInputSet setEnable(boolean enable) {
        this.enable_ = enable;
        return this;
    }

    public boolean isEditable() {
        return !this.readonly_;
    }

    public UIFormMultiValueInputSet setEditable(boolean editable) {
        this.readonly_ = !editable;
        return this;
    }

    public void processDecode(WebuiRequestContext context) throws Exception {
        super.processDecode(context);
        UIForm uiForm = (UIForm)this.getAncestorOfType(UIForm.class);
        String action = uiForm.getSubmitAction();
        Event event = this.createEvent(action, Event.Phase.DECODE, context);
        if (event == null) {
            return;
        }
        event.broadcast();
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        if (this.getChildren() == null || this.getChildren().size() < 1) {
            this.createUIFormInput(0);
        }
        Writer writer = context.getWriter();
        UIForm uiForm = (UIForm)this.getAncestorOfType(UIForm.class);
        int size = this.getChildren().size();
        ResourceBundle res = context.getApplicationResourceBundle();
        String addItem = res.getString("UIFormMultiValueInputSet.label.add");
        String removeItem = res.getString("UIFormMultiValueInputSet.label.remove");
        for (int i = 0; i < size; ++i) {
            UIFormInputBase uiInput = (UIFormInputBase)this.getChild(i);
            writer.append("<div class=\"MultiValueContainer\">");
            uiInput.setEditable(!this.readonly_);
            uiInput.setEnable(this.enable_);
            uiInput.processRender(context);
            if (size >= 2 || size == 1 && uiInput.getValue() != null) {
                writer.append("<img onclick=\"");
                writer.append(uiForm.event("Remove", uiInput.getId())).append("\" title=\"" + removeItem + "\" alt=\"\"");
                writer.append(" class=\"MultiFieldAction Remove16x16Icon\" src=\"/eXoResources/skin/sharedImages/Blank.gif\" />");
            }
            if (i == size - 1) {
                writer.append("<img onclick=\"");
                writer.append(uiForm.event("Add", this.getId())).append("\" title=\"" + addItem + "\" alt=\"\"");
                writer.append(" class=\"MultiFieldAction AddNewNodeIcon\" src=\"/eXoResources/skin/sharedImages/Blank.gif\" />");
            }
            writer.append("</div>");
        }
    }

    public UIFormInputBase createUIFormInput(int idx) throws Exception {
        UIFormInputBase inputBase;
        if (this.constructor_ == null) {
            return null;
        }
        Class<?>[] classes = this.constructor_.getParameterTypes();
        String compName = this.getId() + String.valueOf(idx);
        if (classes.length > 0) {
            if (this.constructorParams_ == null) {
                Object[] params = new Object[classes.length];
                for (int i = 0; i < classes.length; ++i) {
                    if (!classes[i].isPrimitive()) continue;
                    params[i] = classes[i] == Boolean.TYPE ? (Comparable<Boolean>)Boolean.valueOf(false) : (Comparable<Boolean>)Integer.valueOf(0);
                }
                params[0] = compName;
                inputBase = (UIFormInputBase)this.constructor_.newInstance(params);
            } else {
                inputBase = (UIFormInputBase)this.constructor_.newInstance(this.constructorParams_);
            }
        } else {
            inputBase = (UIFormInputBase)this.constructor_.newInstance(new Object[0]);
        }
        inputBase.setName(compName);
        inputBase.setId(compName);
        List<Validator> validators = this.getValidators();
        if (validators != null) {
            for (Validator validator : validators) {
                inputBase.addValidator(validator.getClass(), new Object[0]);
            }
        }
        this.addChild((UIComponent)inputBase);
        return inputBase;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RemoveActionListener
    extends EventListener<UIFormMultiValueInputSet> {
        public void execute(Event<UIFormMultiValueInputSet> event) throws Exception {
            UIFormMultiValueInputSet uiSet = (UIFormMultiValueInputSet)event.getSource();
            String id = event.getRequestContext().getRequestParameter("objectId");
            uiSet.removeChildById(id);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddActionListener
    extends EventListener<UIFormMultiValueInputSet> {
        public void execute(Event<UIFormMultiValueInputSet> event) throws Exception {
            List children;
            UIFormMultiValueInputSet uiSet = (UIFormMultiValueInputSet)event.getSource();
            String id = event.getRequestContext().getRequestParameter("objectId");
            if (uiSet.getId().equals(id) && (children = uiSet.getChildren()).size() > 0) {
                UIFormInputBase uiInput = (UIFormInputBase)children.get(children.size() - 1);
                String index = uiInput.getId();
                int maxIndex = Integer.parseInt(index.replaceAll(id, ""));
                uiSet.createUIFormInput(maxIndex + 1);
            }
        }
    }
}

