/*
 * Decompiled with CFR 0.152.
 */
package org.jsecurity.authc;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jsecurity.authc.AuthenticationException;
import org.jsecurity.authc.AuthenticationInfo;
import org.jsecurity.authc.AuthenticationListener;
import org.jsecurity.authc.AuthenticationListenerRegistrar;
import org.jsecurity.authc.AuthenticationToken;
import org.jsecurity.authc.Authenticator;
import org.jsecurity.authc.LogoutAware;
import org.jsecurity.subject.PrincipalCollection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAuthenticator
implements Authenticator,
LogoutAware,
AuthenticationListenerRegistrar {
    private static final Log log = LogFactory.getLog(AbstractAuthenticator.class);
    private Collection<AuthenticationListener> listeners = new ArrayList<AuthenticationListener>();

    @Override
    public void setAuthenticationListeners(Collection<AuthenticationListener> listeners) {
        this.listeners = listeners == null ? new ArrayList<AuthenticationListener>() : listeners;
    }

    @Override
    public void add(AuthenticationListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public boolean remove(AuthenticationListener listener) {
        return this.listeners.remove(listener);
    }

    protected void notifySuccess(AuthenticationToken token, AuthenticationInfo info) {
        for (AuthenticationListener listener : this.listeners) {
            listener.onSuccess(token, info);
        }
    }

    protected void notifyFailure(AuthenticationToken token, AuthenticationException ae) {
        for (AuthenticationListener listener : this.listeners) {
            listener.onFailure(token, ae);
        }
    }

    protected void notifyLogout(PrincipalCollection principals) {
        for (AuthenticationListener listener : this.listeners) {
            listener.onLogout(principals);
        }
    }

    @Override
    public void onLogout(PrincipalCollection principals) {
        this.notifyLogout(principals);
    }

    @Override
    public final AuthenticationInfo authenticate(AuthenticationToken token) throws AuthenticationException {
        AuthenticationInfo info;
        if (token == null) {
            throw new IllegalArgumentException("Method argumet (authentication token) cannot be null.");
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Authentication attempt received for token [" + token + "]"));
        }
        try {
            info = this.doAuthenticate(token);
            if (info == null) {
                String msg = "No account information found for authentication token [" + token + "] by this " + "Authenticator instance.  Please check that it is configured correctly.";
                throw new AuthenticationException(msg);
            }
        }
        catch (Throwable t) {
            AuthenticationException ae;
            block11: {
                ae = null;
                if (t instanceof AuthenticationException) {
                    ae = (AuthenticationException)t;
                }
                if (ae == null) {
                    String msg = "Authentication failed for token submission [" + token + "].  Possible unexpected " + "error? (Typical or expected login exceptions should extend from AuthenticationException).";
                    ae = new AuthenticationException(msg, t);
                    if (log.isWarnEnabled()) {
                        log.warn((Object)msg, t);
                    }
                }
                try {
                    this.notifyFailure(token, ae);
                }
                catch (Throwable t2) {
                    String msg = "Unable to send notification for failed authentication attempt - listener error?.  Please check your AuthenticationListener implementation(s).  Logging sending exception and propagating original AuthenticationException instead...";
                    if (!log.isWarnEnabled()) break block11;
                    log.warn((Object)msg, t2);
                }
            }
            throw ae;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Authentication successful for token [" + token + "].  Returned account: [" + info + "]"));
        }
        this.notifySuccess(token, info);
        return info;
    }

    protected abstract AuthenticationInfo doAuthenticate(AuthenticationToken var1) throws AuthenticationException;
}

