/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.common.http.client;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import org.exoplatform.common.http.client.AuthSchemeNotImplException;
import org.exoplatform.common.http.client.AuthorizationInfo;
import org.exoplatform.common.http.client.NVPair;
import org.exoplatform.common.http.client.SocksException;
import org.exoplatform.commons.utils.PrivilegedSystemHelper;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

class SocksClient {
    private String socks_host;
    private int socks_port;
    private int socks_version;
    private static final byte CONNECT = 1;
    private static final byte BIND = 2;
    private static final byte UDP_ASS = 3;
    private static final byte NO_AUTH = 0;
    private static final byte GSSAPI = 1;
    private static final byte USERPWD = 2;
    private static final byte NO_ACC = -1;
    private static final byte IP_V4 = 1;
    private static final byte DMNAME = 3;
    private static final byte IP_V6 = 4;
    private static final Log log = ExoLogger.getLogger((String)"exo.ws.commons.SocksClient");
    private boolean v4A = false;
    private byte[] user = null;

    SocksClient(String host, int port) {
        this.socks_host = host;
        this.socks_port = port;
        this.socks_version = -1;
    }

    SocksClient(String host, int port, int version) throws SocksException {
        this.socks_host = host;
        this.socks_port = port;
        if (version != 4 && version != 5) {
            throw new SocksException("SOCKS Version not supported: " + version);
        }
        this.socks_version = version;
    }

    Socket getSocket(String host, int port) throws IOException {
        return this.getSocket(host, port, null, -1);
    }

    Socket getSocket(String host, int port, InetAddress localAddr, int localPort) throws IOException {
        Socket sock = null;
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Contacting server on " + this.socks_host + ":" + this.socks_port));
            }
            sock = SocksClient.connect(this.socks_host, this.socks_port, localAddr, localPort);
            InputStream inp = sock.getInputStream();
            OutputStream out = sock.getOutputStream();
            switch (this.socks_version) {
                case 4: {
                    this.v4ProtExchg(inp, out, host, port);
                    break;
                }
                case 5: {
                    this.v5ProtExchg(inp, out, host, port);
                    break;
                }
                case -1: {
                    try {
                        this.v4ProtExchg(inp, out, host, port);
                        this.socks_version = 4;
                    }
                    catch (SocksException se) {
                        log.error((Object)("Socks: V4 request failed: " + se.getMessage()));
                        sock.close();
                        sock = SocksClient.connect(this.socks_host, this.socks_port, localAddr, localPort);
                        inp = sock.getInputStream();
                        out = sock.getOutputStream();
                        this.v5ProtExchg(inp, out, host, port);
                        this.socks_version = 5;
                    }
                    break;
                }
                default: {
                    throw new Error("SocksClient internal error: unknown version " + this.socks_version);
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Connection established.");
            }
            return sock;
        }
        catch (IOException ioe) {
            if (sock != null) {
                try {
                    sock.close();
                }
                catch (IOException ee) {
                    // empty catch block
                }
            }
            throw ioe;
        }
    }

    private static final Socket connect(String host, int port, InetAddress localAddr, int localPort) throws IOException {
        InetAddress[] addr_list = InetAddress.getAllByName(host);
        for (int idx = 0; idx < addr_list.length; ++idx) {
            try {
                if (localAddr == null) {
                    return new Socket(addr_list[idx], port);
                }
                return new Socket(addr_list[idx], port, localAddr, localPort);
            }
            catch (SocketException se) {
                if (idx < addr_list.length - 1) continue;
                throw se;
            }
        }
        return null;
    }

    private void v4ProtExchg(InputStream inp, OutputStream out, String host, int port) throws SocksException, IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(100);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Beginning V4 Protocol Exchange for host " + host + ":" + port));
        }
        byte[] addr = new byte[]{0, 0, 0, 42};
        if (!this.v4A) {
            try {
                addr = InetAddress.getByName(host).getAddress();
            }
            catch (UnknownHostException uhe) {
                this.v4A = true;
            }
            catch (SecurityException se) {
                this.v4A = true;
            }
            if (this.v4A && log.isDebugEnabled()) {
                log.debug((Object)"Switching to version 4A");
            }
        }
        if (this.user == null) {
            String user_str;
            try {
                user_str = PrivilegedSystemHelper.getProperty((String)"user.name", (String)"");
            }
            catch (SecurityException se) {
                user_str = "";
            }
            byte[] tmp = user_str.getBytes();
            this.user = new byte[tmp.length + 1];
            System.arraycopy(tmp, 0, this.user, 0, tmp.length);
            this.user[user_str.length()] = 0;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Sending connect request for user " + new String(this.user, 0, this.user.length - 1)));
        }
        buffer.reset();
        buffer.write(4);
        buffer.write(1);
        buffer.write(port >> 8 & 0xFF);
        buffer.write(port & 0xFF);
        buffer.write(addr);
        buffer.write(this.user);
        if (this.v4A) {
            buffer.write(host.getBytes("8859_1"));
            buffer.write(0);
        }
        buffer.writeTo(out);
        int version = inp.read();
        if (version == -1) {
            throw new SocksException("Connection refused by server");
        }
        if (version == 4) {
            log.warn((Object)"Received version 4 instead of 0");
        } else if (version != 0) {
            throw new SocksException("Received invalid version: " + version + "; expected: 0");
        }
        int sts = inp.read();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Received response; version: " + version + "; status: " + sts));
        }
        switch (sts) {
            case 90: {
                break;
            }
            case 91: {
                throw new SocksException("Connection request rejected");
            }
            case 92: {
                throw new SocksException("Connection request rejected: can't connect to identd");
            }
            case 93: {
                throw new SocksException("Connection request rejected: identd reports different user-id from " + new String(this.user, 0, this.user.length - 1));
            }
            default: {
                throw new SocksException("Connection request rejected: unknown error " + sts);
            }
        }
        byte[] skip = new byte[6];
        int rcvd = 0;
        for (int tot = 0; tot < skip.length && (rcvd = inp.read(skip, 0, skip.length - tot)) != -1; tot += rcvd) {
        }
    }

    private void v5ProtExchg(InputStream inp, OutputStream out, String host, int port) throws SocksException, IOException {
        int alen;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(100);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Beginning V5 Protocol Exchange for host " + host + ":" + port));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Sending authentication request; methods No-Authentication, Username/Password");
        }
        buffer.reset();
        buffer.write(5);
        buffer.write(2);
        buffer.write(0);
        buffer.write(2);
        buffer.writeTo(out);
        int version = inp.read();
        if (version == -1) {
            throw new SocksException("Connection refused by server");
        }
        if (version != 5) {
            throw new SocksException("Received invalid version: " + version + "; expected: 5");
        }
        int method = inp.read();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Received response; version: " + version + "; method: " + method));
        }
        switch (method) {
            case 0: {
                break;
            }
            case 1: {
                this.negotiate_gssapi(inp, out);
                break;
            }
            case 2: {
                this.negotiate_userpwd(inp, out);
                break;
            }
            case -1: {
                throw new SocksException("Server unwilling to accept any standard authentication methods");
            }
            default: {
                throw new SocksException("Cannot handle authentication method " + method);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Sending connect request");
        }
        buffer.reset();
        buffer.write(5);
        buffer.write(1);
        buffer.write(0);
        buffer.write(3);
        buffer.write(host.length() & 0xFF);
        buffer.write(host.getBytes("8859_1"));
        buffer.write(port >> 8 & 0xFF);
        buffer.write(port & 0xFF);
        buffer.writeTo(out);
        version = inp.read();
        if (version != 5) {
            throw new SocksException("Received invalid version: " + version + "; expected: 5");
        }
        int sts = inp.read();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Received response; version: " + version + "; status: " + sts));
        }
        switch (sts) {
            case 0: {
                break;
            }
            case 1: {
                throw new SocksException("General SOCKS server failure");
            }
            case 2: {
                throw new SocksException("Connection not allowed");
            }
            case 3: {
                throw new SocksException("Network unreachable");
            }
            case 4: {
                throw new SocksException("Host unreachable");
            }
            case 5: {
                throw new SocksException("Connection refused");
            }
            case 6: {
                throw new SocksException("TTL expired");
            }
            case 7: {
                throw new SocksException("Command not supported");
            }
            case 8: {
                throw new SocksException("Address type not supported");
            }
            default: {
                throw new SocksException("Unknown reply received from server: " + sts);
            }
        }
        inp.read();
        int atype = inp.read();
        switch (atype) {
            case 4: {
                alen = 16;
                break;
            }
            case 1: {
                alen = 4;
                break;
            }
            case 3: {
                alen = inp.read();
                break;
            }
            default: {
                throw new SocksException("Invalid address type received from server: " + atype);
            }
        }
        byte[] skip = new byte[alen + 2];
        int rcvd = 0;
        for (int tot = 0; tot < skip.length && (rcvd = inp.read(skip, 0, skip.length - tot)) != -1; tot += rcvd) {
        }
    }

    private void negotiate_gssapi(InputStream inp, OutputStream out) throws SocksException, IOException {
        throw new SocksException("GSSAPI authentication protocol not implemented");
    }

    private void negotiate_userpwd(InputStream inp, OutputStream out) throws SocksException, IOException {
        AuthorizationInfo auth_info;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Entering authorization subnegotiation; method: Username/Password");
        }
        try {
            auth_info = AuthorizationInfo.getAuthorization(this.socks_host, this.socks_port, "SOCKS5", "USER/PASS", null, null, true);
        }
        catch (AuthSchemeNotImplException atnie) {
            auth_info = null;
        }
        if (auth_info == null) {
            throw new SocksException("No Authorization info for SOCKS found (server requested username/password).");
        }
        NVPair[] unpw = auth_info.getParams();
        if (unpw == null || unpw.length == 0) {
            throw new SocksException("No Username/Password found in authorization info for SOCKS.");
        }
        String user_str = unpw[0].getName();
        String pass_str = unpw[0].getValue();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Sending authorization request for user " + user_str));
        }
        byte[] utmp = user_str.getBytes();
        byte[] ptmp = pass_str.getBytes();
        byte[] buffer = new byte[2 + utmp.length + 1 + ptmp.length];
        buffer[0] = 1;
        buffer[1] = (byte)utmp.length;
        System.arraycopy(utmp, 0, buffer, 2, utmp.length);
        buffer[2 + buffer[1]] = (byte)ptmp.length;
        System.arraycopy(ptmp, 0, buffer, 2 + buffer[1] + 1, ptmp.length);
        out.write(buffer);
        int version = inp.read();
        if (version != 1) {
            throw new SocksException("Wrong version received in username/password subnegotiation response: " + version + "; expected: 1");
        }
        int sts = inp.read();
        if (sts != 0) {
            throw new SocksException("Username/Password authentication failed; status: " + sts);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Received response; version: " + version + "; status: " + sts));
        }
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.socks_host + ":" + this.socks_port + "]";
    }
}

