/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.document.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValuesParam;
import org.exoplatform.services.document.DocumentReadException;
import org.exoplatform.services.document.impl.BaseDocumentReader;

public class TextPlainDocumentReader
extends BaseDocumentReader {
    public static final String DEFAULT_ENCODING = "defaultEncoding";
    private String defaultEncoding;

    public TextPlainDocumentReader(InitParams params) {
        ValuesParam encoding = (ValuesParam)params.getParameter(DEFAULT_ENCODING);
        this.defaultEncoding = encoding != null && encoding.getValue() != null && !encoding.getValue().equalsIgnoreCase("") ? encoding.getValue() : null;
    }

    public String[] getMimeTypes() {
        return new String[]{"text/plain", "script/groovy", "application/x-groovy", "application/x-javascript", "application/javascript", "text/javascript", "application/x-jaxrs+groovy"};
    }

    public String getContentAsText(InputStream is) throws IOException, DocumentReadException {
        if (this.defaultEncoding != null) {
            return this.getContentAsText(is, this.defaultEncoding);
        }
        return this.getContentAsText(is, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getContentAsText(InputStream is, String encoding) throws IOException, DocumentReadException {
        if (is == null) {
            throw new NullPointerException("InputStream is null.");
        }
        try {
            int len;
            byte[] buffer = new byte[2048];
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            while ((len = is.read(buffer)) > 0) {
                bos.write(buffer, 0, len);
            }
            bos.close();
            if (bos.size() == 0) {
                String string = "";
                return string;
            }
            if (encoding != null) {
                String string = new String(bos.toByteArray(), encoding);
                return string;
            }
            String string = new String(bos.toByteArray());
            return string;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public Properties getProperties(InputStream is) throws IOException, DocumentReadException {
        try {
            is.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new Properties();
    }
}

