/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow.serialization;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import org.exoplatform.services.jcr.dataflow.serialization.ObjectReader;

public class ObjectReaderImpl
implements ObjectReader {
    private InputStream in;
    private final FileInputStream fileIn;

    public ObjectReaderImpl(InputStream in) {
        this.in = new BufferedInputStream(in, 2048);
        this.fileIn = in instanceof FileInputStream ? (FileInputStream)in : null;
    }

    public void close() throws IOException {
        this.in.close();
    }

    public boolean readBoolean() throws IOException {
        int v = this.in.read();
        if (v < 0) {
            throw new EOFException();
        }
        return v != 0;
    }

    public byte readByte() throws IOException {
        int v = this.in.read();
        if (v < 0) {
            throw new EOFException();
        }
        return (byte)v;
    }

    public void readFully(byte[] b) throws IOException {
        int l = this.in.read(b);
        if (l < 0) {
            throw new EOFException();
        }
        if (l < b.length && l > 0) {
            throw new StreamCorruptedException("Unexpected EOF in middle of data block.");
        }
    }

    public synchronized long read(OutputStream stream, long length) throws IOException {
        throw new IOException("Not implemented");
    }

    public int readInt() throws IOException {
        byte[] readBuffer = new byte[4];
        this.readFully(readBuffer);
        return ((readBuffer[0] & 0xFF) << 24) + ((readBuffer[1] & 0xFF) << 16) + ((readBuffer[2] & 0xFF) << 8) + (readBuffer[3] & 0xFF);
    }

    public long readLong() throws IOException {
        byte[] readBuffer = new byte[8];
        this.readFully(readBuffer);
        return ((long)readBuffer[0] << 56) + ((long)(readBuffer[1] & 0xFF) << 48) + ((long)(readBuffer[2] & 0xFF) << 40) + ((long)(readBuffer[3] & 0xFF) << 32) + ((long)(readBuffer[4] & 0xFF) << 24) + (long)((readBuffer[5] & 0xFF) << 16) + (long)((readBuffer[6] & 0xFF) << 8) + (long)((readBuffer[7] & 0xFF) << 0);
    }

    public long skip(long n) throws IOException {
        long remaining;
        int nr;
        if (n <= 0L) {
            return 0L;
        }
        byte[] skipBuffer = new byte[2048];
        for (remaining = n; remaining > 0L && (nr = this.in.read(skipBuffer, 0, (int)Math.min(2048L, remaining))) >= 0; remaining -= (long)nr) {
        }
        return n - remaining;
    }

    public String readString() throws IOException {
        int length = this.readInt();
        byte[] buf = new byte[length];
        this.readFully(buf);
        return new String(buf, "UTF-8");
    }
}

