/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.controller.router;

import org.exoplatform.web.controller.regexp.GroupType;
import org.exoplatform.web.controller.regexp.RENode;
import org.exoplatform.web.controller.router.MalformedRouteException;

public class RouteEscaper {
    private final char src;
    private final char dst;

    public RouteEscaper(char src, char dst) {
        this.src = src;
        this.dst = dst;
    }

    public void visit(RENode.Disjunction disjunction) throws MalformedRouteException {
        this.visit(disjunction.getAlternative());
        RENode.Disjunction next = disjunction.getNext();
        if (next != null) {
            this.visit(next);
        }
    }

    public void visit(RENode.Alternative alternative) throws MalformedRouteException {
        this.visit(alternative.getExp());
        RENode.Alternative next = alternative.getNext();
        if (next != null) {
            this.visit(next);
        }
    }

    public void visit(RENode.Expr expr) throws MalformedRouteException {
        if (expr instanceof RENode.Char) {
            RENode.Char c = (RENode.Char)expr;
            if (c.getValue() == this.src) {
                c.setValue(this.dst);
            }
        } else if (expr instanceof RENode.Group) {
            RENode.Group group = (RENode.Group)expr;
            if (group.getType() == GroupType.CAPTURING_GROUP) {
                group.setType(GroupType.NON_CAPTURING_GROUP);
            }
            this.visit(group.getDisjunction());
        } else if (expr instanceof RENode.Any) {
            RENode.CharacterClass repl = new RENode.CharacterClass(new RENode.CharacterClassExpr.Not(new RENode.CharacterClassExpr.Char('/')));
            repl.setQuantifier(expr.getQuantifier());
            expr.replaceBy(repl);
        } else if (expr instanceof RENode.CharacterClass) {
            RENode.CharacterClass characterClass = (RENode.CharacterClass)expr;
            RENode.CharacterClassExpr ccExpr = characterClass.getExpr();
            RENode.CharacterClassExpr characterClassExpr = ccExpr.replace(this.src, this.dst);
        }
    }
}

