/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.login;

import java.net.URLEncoder;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.login.UIForgetPasswordWizard;
import org.exoplatform.portal.webui.login.UILogin;
import org.exoplatform.portal.webui.login.UILoginForm;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.mail.MailService;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.Query;
import org.exoplatform.services.organization.User;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.web.security.security.RemindPasswordTokenService;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.validator.EmailAddressValidator;
import org.exoplatform.webui.form.validator.MandatoryValidator;
import org.gatein.wci.security.Credentials;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIFormWithTitle.gtmpl", events={@EventConfig(listeners={SendActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={BackActionListener.class})})
public class UIForgetPassword
extends UIForm {
    static final String Username = "username";
    static final String Email = "email";

    public UIForgetPassword() throws Exception {
        this.addUIFormInput((UIFormInput)new UIFormStringInput(Username, null).addValidator(MandatoryValidator.class, new Object[0])).addUIFormInput((UIFormInput)new UIFormStringInput(Email, null).addValidator(MandatoryValidator.class, new Object[0]).addValidator(EmailAddressValidator.class, new Object[0]));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BackActionListener
    extends EventListener<UIForgetPassword> {
        public void execute(Event<UIForgetPassword> event) throws Exception {
            UILogin uilogin = (UILogin)((UIForgetPassword)((Object)event.getSource())).getParent();
            ((UILoginForm)uilogin.getChild(UILoginForm.class)).setRendered(false);
            ((UIForgetPasswordWizard)uilogin.getChild(UIForgetPasswordWizard.class)).setRendered(true);
            ((UIForgetPassword)uilogin.getChild(UIForgetPassword.class)).setRendered(false);
            ((UIForgetPassword)((Object)event.getSource())).reset();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uilogin);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SendActionListener
    extends EventListener<UIForgetPassword> {
        public void execute(Event<UIForgetPassword> event) throws Exception {
            UIForgetPassword uiForm = (UIForgetPassword)((Object)event.getSource());
            UILogin uilogin = (UILogin)uiForm.getParent();
            WebuiRequestContext requestContext = event.getRequestContext();
            PortalRequestContext portalContext = (PortalRequestContext)PortalRequestContext.getCurrentInstance();
            MailService mailSrc = (MailService)uiForm.getApplicationComponent(MailService.class);
            OrganizationService orgSrc = (OrganizationService)uiForm.getApplicationComponent(OrganizationService.class);
            String userName = (String)uiForm.getUIStringInput(UIForgetPassword.Username).getValue();
            String email = (String)uiForm.getUIStringInput(UIForgetPassword.Email).getValue();
            uiForm.reset();
            User user = null;
            String tokenId = null;
            if (userName != null && (user = orgSrc.getUserHandler().findUserByName(userName)) == null) {
                requestContext.getUIApplication().addMessage(new ApplicationMessage("UIForgetPassword.msg.user-not-exist", null));
                return;
            }
            if (user == null && email != null) {
                Query query = new Query();
                query.setEmail(email);
                PageList users = orgSrc.getUserHandler().findUsers(query);
                if (users.getAll().size() > 0) {
                    user = (User)users.getAll().get(0);
                } else {
                    requestContext.getUIApplication().addMessage(new ApplicationMessage("UIForgetPassword.msg.email-not-exist", null));
                    return;
                }
            }
            email = user.getEmail();
            RemindPasswordTokenService tokenService = (RemindPasswordTokenService)uiForm.getApplicationComponent(RemindPasswordTokenService.class);
            Credentials credentials = new Credentials(user.getUserName(), "");
            tokenId = tokenService.createToken(credentials);
            String portalName = URLEncoder.encode(Util.getUIPortal().getName(), "UTF-8");
            ResourceBundle res = requestContext.getApplicationResourceBundle();
            String headerMail = "headermail";
            String footerMail = "footer";
            try {
                headerMail = res.getString(uiForm.getId() + ".mail.header") + "\n\n" + res.getString(uiForm.getId() + ".mail.user") + user.getUserName() + "\n" + res.getString(uiForm.getId() + ".mail.link");
                footerMail = "\n\n\n" + res.getString(uiForm.getId() + ".mail.footer");
            }
            catch (MissingResourceException e) {
                e.printStackTrace();
            }
            HttpServletRequest request = portalContext.getRequest();
            String host = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort();
            String activeLink = host + requestContext.getRequestContextPath() + "/public/" + portalName + "?" + "portal:componentId" + "=UIPortal&portal:action=RecoveryPasswordAndUsername&tokenId=" + tokenId;
            String mailText = headerMail + "\n" + activeLink + footerMail;
            try {
                mailSrc.sendMessage(res.getString("UIForgetPassword.mail.from"), email, res.getString("UIForgetPassword.mail.subject"), mailText);
            }
            catch (Exception e) {
                requestContext.getUIApplication().addMessage(new ApplicationMessage("UIForgetPassword.msg.send-mail-fail", null));
                requestContext.addUIComponentToUpdateByAjax((UIComponent)uilogin);
                return;
            }
            ((UILoginForm)uilogin.getChild(UILoginForm.class)).setRendered(true);
            ((UIForgetPasswordWizard)uilogin.getChild(UIForgetPasswordWizard.class)).setRendered(false);
            ((UIForgetPassword)uilogin.getChild(UIForgetPassword.class)).setRendered(false);
            requestContext.getUIApplication().addMessage(new ApplicationMessage("UIForgetPassword.msg.send-mail-success", null));
            requestContext.addUIComponentToUpdateByAjax((UIComponent)uilogin);
        }
    }
}

