/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.hierarchy.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.distribution.DataDistributionManager;
import org.exoplatform.services.jcr.ext.distribution.DataDistributionMode;
import org.exoplatform.services.jcr.ext.distribution.DataDistributionType;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.jcr.ext.hierarchy.impl.AddPathPlugin;
import org.exoplatform.services.jcr.ext.hierarchy.impl.HierarchyConfig;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.picocontainer.Startable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeHierarchyCreatorImpl
implements NodeHierarchyCreator,
Startable {
    private static final Log log = ExoLogger.getLogger("exo.jcr.component.ext.NodeHierarchyCreatorImpl");
    private static final String USERS_PATH = "usersPath";
    private static final String USER_APPLICATION = "userApplicationData";
    private static final String PUBLIC_APPLICATION = "eXoApplications";
    private static final String USER_PRIVATE = "userPrivate";
    private static final String USER_PUBLIC = "userPublic";
    private final RepositoryService jcrService_;
    private final DataDistributionManager dataDistributionManager_;
    private final List<AddPathPlugin> pathPlugins_ = new ArrayList<AddPathPlugin>();
    private final Map<String, String> paths_ = new HashMap<String, String>();
    private final boolean oldDistribution;
    private final boolean autoMigrate;

    public NodeHierarchyCreatorImpl(RepositoryService jcrService, InitParams params) {
        this(jcrService, null, params);
    }

    public NodeHierarchyCreatorImpl(RepositoryService jcrService, DataDistributionManager dataDistributionManager, InitParams params) {
        if (dataDistributionManager == null) {
            throw new IllegalArgumentException("The DataDistributionManager is now mandatory if you use the NodeHierarchyCreator, so please define it in your configuration as described in the JCR documentation");
        }
        this.jcrService_ = jcrService;
        this.dataDistributionManager_ = dataDistributionManager;
        this.oldDistribution = params != null && params.getValueParam("old-user-distribution") != null && Boolean.valueOf(params.getValueParam("old-user-distribution").getValue()) != false;
        boolean bl = this.autoMigrate = params != null && params.getValueParam("auto-migrate") != null && Boolean.valueOf(params.getValueParam("auto-migrate").getValue()) != false;
        if (PropertyManager.isDevelopping() && !this.oldDistribution) {
            log.info("The NodeHierarchyCreator is configured to use the new distribution mechanism for the users directories, if you prefer to use the old mechanism set the value parameter 'old-user-distribution' to 'true'.");
        }
    }

    public void start() {
        try {
            this.processAddPathPlugin();
        }
        catch (Exception e) {
            log.error((Object)"An error occurs while processing the plugins", e);
        }
        try {
            this.checkForUpgrade();
        }
        catch (RepositoryException e) {
            log.error((Object)"An error occurs while upgrading JCR structure", e);
        }
    }

    public void stop() {
    }

    @Override
    public void init(String repository) throws Exception {
        this.initBasePath(repository);
    }

    @Override
    public void init() throws Exception {
        this.initBasePath(null);
    }

    private void createNode(Node rootNode, String path, String nodeType, List<String> mixinTypes, Map<String, String[]> permissions) throws Exception {
        this.dataDistributionManager_.getDataDistributionType(DataDistributionMode.NONE).getOrCreateDataNode(rootNode, path, nodeType, mixinTypes, permissions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void processAddPathPlugin() throws Exception {
        Session session = null;
        for (AddPathPlugin pathPlugin : this.pathPlugins_) {
            String repositoryName;
            List<HierarchyConfig.JcrPath> jcrPaths;
            HierarchyConfig hierarchyConfig = pathPlugin.getPaths();
            if (hierarchyConfig == null || (jcrPaths = hierarchyConfig.getJcrPaths()) == null) continue;
            LinkedHashSet<String> workspaceNames = new LinkedHashSet<String>();
            if (hierarchyConfig.getWorkspaces() != null) {
                workspaceNames.addAll(hierarchyConfig.getWorkspaces());
            }
            ManageableRepository repository = (repositoryName = hierarchyConfig.getRepository()) == null || repositoryName.isEmpty() ? this.jcrService_.getCurrentRepository() : this.jcrService_.getRepository(repositoryName);
            for (String workspaceName : workspaceNames) {
                Object var16_16;
                HierarchyConfig.JcrPath currentjcrPath = null;
                try {
                    session = repository.getSystemSession(workspaceName);
                    Node rootNode = session.getRootNode();
                    Iterator<HierarchyConfig.JcrPath> i$ = jcrPaths.iterator();
                    while (i$.hasNext()) {
                        HierarchyConfig.JcrPath jcrPath;
                        currentjcrPath = jcrPath = i$.next();
                        if (jcrPath.getAlias().equals(USER_APPLICATION) || jcrPath.getAlias().startsWith(USER_PRIVATE) || jcrPath.getAlias().startsWith(USER_PUBLIC)) continue;
                        this.createNode(rootNode, jcrPath.getPath(), jcrPath.getNodeType(), jcrPath.getMixinTypes(), jcrPath.getPermissions(null));
                    }
                    var16_16 = null;
                    if (session == null) continue;
                }
                catch (Throwable throwable) {
                    var16_16 = null;
                    if (session != null) {
                        session.logout();
                        session = null;
                    }
                    throw throwable;
                }
                session.logout();
                session = null;
                {
                    continue;
                    catch (Exception e) {
                        log.error((Object)("An error occurs while processing the JCR path which alias is " + (currentjcrPath == null ? null : currentjcrPath.getAlias()) + " with the workspace " + workspaceName), e);
                        var16_16 = null;
                        if (session == null) continue;
                        session.logout();
                        session = null;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void initBasePath(String repositoryName) throws Exception {
        Session session = null;
        ManageableRepository manageableRepository = repositoryName == null || repositoryName.isEmpty() ? this.jcrService_.getCurrentRepository() : this.jcrService_.getRepository(repositoryName);
        String defaultWorkspace = manageableRepository.getConfiguration().getDefaultWorkspaceName();
        String systemWorkspace = manageableRepository.getConfiguration().getSystemWorkspaceName();
        boolean isSameWorkspace = defaultWorkspace.equalsIgnoreCase(systemWorkspace);
        String[] workspaceNames = manageableRepository.getWorkspaceNames();
        for (AddPathPlugin pathPlugin : this.pathPlugins_) {
            List<HierarchyConfig.JcrPath> jcrPaths;
            HierarchyConfig hierarchyConfig = pathPlugin.getPaths();
            if (hierarchyConfig == null || (jcrPaths = hierarchyConfig.getJcrPaths()) == null) continue;
            for (String workspaceName : workspaceNames) {
                Object var21_21;
                if (!isSameWorkspace && workspaceName.equalsIgnoreCase(systemWorkspace)) continue;
                HierarchyConfig.JcrPath currentjcrPath = null;
                try {
                    session = manageableRepository.getSystemSession(workspaceName);
                    Node rootNode = session.getRootNode();
                    Iterator<HierarchyConfig.JcrPath> i$ = jcrPaths.iterator();
                    while (i$.hasNext()) {
                        HierarchyConfig.JcrPath jcrPath;
                        currentjcrPath = jcrPath = i$.next();
                        if (jcrPath.getAlias().equals(USER_APPLICATION) || jcrPath.getAlias().startsWith(USER_PRIVATE) || jcrPath.getAlias().startsWith(USER_PUBLIC)) continue;
                        this.createNode(rootNode, jcrPath.getPath(), jcrPath.getNodeType(), jcrPath.getMixinTypes(), jcrPath.getPermissions(null));
                    }
                    var21_21 = null;
                    if (session == null) continue;
                }
                catch (Throwable throwable) {
                    var21_21 = null;
                    if (session != null) {
                        session.logout();
                        session = null;
                    }
                    throw throwable;
                }
                session.logout();
                session = null;
                {
                    continue;
                    catch (Exception e) {
                        log.error((Object)("An error occurs while processing the JCR path which alias is " + (currentjcrPath == null ? null : currentjcrPath.getAlias()) + " with the workspace " + workspaceName), e);
                        var21_21 = null;
                        if (session == null) continue;
                        session.logout();
                        session = null;
                    }
                }
            }
        }
    }

    @Override
    public Node getUserApplicationNode(SessionProvider sessionProvider, String userName) throws Exception {
        Node userNode = this.getUserNode(sessionProvider, userName);
        return this.dataDistributionManager_.getDataDistributionType(DataDistributionMode.NONE).getOrCreateDataNode(userNode, this.getJcrPath(USER_APPLICATION));
    }

    @Override
    public Node getPublicApplicationNode(SessionProvider sessionProvider) throws Exception {
        Session session = this.getSession(sessionProvider);
        Node rootNode = session.getRootNode();
        return this.dataDistributionManager_.getDataDistributionType(DataDistributionMode.NONE).getDataNode(rootNode, this.getJcrPath(PUBLIC_APPLICATION));
    }

    @Override
    public Node getUserNode(SessionProvider sessionProvider, String userName) throws Exception {
        String userPath = this.getJcrPath(USERS_PATH);
        Session session = this.getSession(sessionProvider);
        Node usersNode = (Node)session.getItem(userPath);
        DataDistributionType type = this.dataDistributionManager_.getDataDistributionType(this.oldDistribution ? DataDistributionMode.NONE : DataDistributionMode.READABLE);
        return type.getOrCreateDataNode(usersNode, userName);
    }

    @Override
    public void removeUserNode(SessionProvider sessionProvider, String userName) throws Exception {
        String userPath = this.getJcrPath(USERS_PATH);
        Session session = this.getSession(sessionProvider);
        try {
            Node usersNode = (Node)session.getItem(userPath);
            DataDistributionType type = this.dataDistributionManager_.getDataDistributionType(this.oldDistribution ? DataDistributionMode.NONE : DataDistributionMode.READABLE);
            type.removeDataNode(usersNode, userName);
        }
        catch (PathNotFoundException e) {
            // empty catch block
        }
    }

    private Session getSession(SessionProvider sessionProvider) throws RepositoryException {
        ManageableRepository repo = this.jcrService_.getCurrentRepository();
        return sessionProvider.getSession(repo.getConfiguration().getDefaultWorkspaceName(), repo);
    }

    @Override
    public String getJcrPath(String alias) {
        return this.paths_.get(alias);
    }

    @Override
    public void addPlugin(ComponentPlugin plugin) {
        if (plugin instanceof AddPathPlugin) {
            AddPathPlugin app = (AddPathPlugin)plugin;
            this.pathPlugins_.add(app);
            if (app.getPaths() != null && app.getPaths().getJcrPaths() != null) {
                for (HierarchyConfig.JcrPath jcrPath : app.getPaths().getJcrPaths()) {
                    if (jcrPath.getAlias() == null || jcrPath.getPath() == null) continue;
                    this.paths_.put(jcrPath.getAlias(), jcrPath.getPath());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkForUpgrade() throws RepositoryException {
        if (this.oldDistribution || !this.autoMigrate) return;
        ManageableRepository repo = this.jcrService_.getCurrentRepository();
        Session session = repo.getSystemSession(repo.getConfiguration().getDefaultWorkspaceName());
        try {
            String userPath = this.getJcrPath(USERS_PATH);
            Node usersNode = (Node)session.getItem(userPath);
            this.dataDistributionManager_.getDataDistributionType(DataDistributionMode.READABLE).migrate(usersNode);
            Object var6_5 = null;
            if (session == null) return;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (session == null) throw throwable;
            session.logout();
            throw throwable;
        }
        session.logout();
    }
}

