/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.script.groovy;

import javax.jcr.Node;
import javax.jcr.Session;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import org.exoplatform.services.jcr.ext.script.groovy.GroovyScript2RestLoader;
import org.exoplatform.services.jcr.ext.script.groovy.NodeScriptKey;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.ObjectFactory;
import org.exoplatform.services.rest.ext.groovy.ResourceId;
import org.exoplatform.services.rest.resource.AbstractResourceDescriptor;

public class GroovyScript2RestUpdateListener
implements EventListener {
    private static final Log LOG = ExoLogger.getLogger("exo.jcr.component.ext.GroovyScript2RestUpdateListener");
    private final String repository;
    private final String workspace;
    private final GroovyScript2RestLoader groovyScript2RestLoader;
    private final Session session;

    public GroovyScript2RestUpdateListener(String repository, String workspace, GroovyScript2RestLoader groovyScript2RestLoader, Session session) {
        this.repository = repository;
        this.workspace = workspace;
        this.groovyScript2RestLoader = groovyScript2RestLoader;
        this.session = session;
    }

    public void onEvent(EventIterator eventIterator) {
        try {
            while (eventIterator.hasNext()) {
                Node node;
                Event event = eventIterator.nextEvent();
                String path = event.getPath();
                if (!path.endsWith("/jcr:data")) continue;
                if (event.getType() == 8) {
                    this.unloadScript(path.substring(0, path.lastIndexOf(47)));
                    continue;
                }
                if (event.getType() != 4 && event.getType() != 16 || !(node = this.session.getItem(path).getParent()).getProperty("exo:autoload").getBoolean()) continue;
                this.loadScript(node);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Process event failed. ", e);
        }
    }

    private void loadScript(Node node) throws Exception {
        NodeScriptKey key = new NodeScriptKey(this.repository, this.workspace, node);
        ObjectFactory resource = this.groovyScript2RestLoader.groovyPublisher.unpublishResource((ResourceId)key);
        if (resource != null) {
            this.groovyScript2RestLoader.groovyPublisher.publishPerRequest(node.getProperty("jcr:data").getStream(), (ResourceId)key, ((AbstractResourceDescriptor)resource.getObjectModel()).getProperties());
        } else {
            this.groovyScript2RestLoader.groovyPublisher.publishPerRequest(node.getProperty("jcr:data").getStream(), (ResourceId)key, null);
        }
    }

    private void unloadScript(String path) throws Exception {
        NodeScriptKey key = new NodeScriptKey(this.repository, this.workspace, path);
        this.groovyScript2RestLoader.groovyPublisher.unpublishResource((ResourceId)key);
    }
}

